/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import mtr.block.BlockNode;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.IGui;
import mtr.data.Rail;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.path.PathData;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RenderSignalBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    protected final boolean isSingleSided;
    protected final int aspects;

    public RenderSignalBase(BlockEntityRenderDispatcher dispatcher, boolean isSingleSided, int aspects) {
        super(dispatcher);
        this.isSingleSided = isSingleSided;
        this.aspects = aspects;
    }

    @Deprecated
    public RenderSignalBase(BlockEntityRenderDispatcher dispatcher, boolean isSingleSided) {
        this(dispatcher, isSingleSided, 2);
    }

    public final void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof BlockSignalLightBase) && !(state.m_60734_() instanceof BlockSignalSemaphoreBase)) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalDirectionalBlock.f_54117_);
        if (RenderTrains.shouldNotRender(pos, RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        BlockPos startPos = RenderSignalBase.getNodePos((BlockGetter)world, pos, facing);
        if (startPos == null) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        for (int i = 0; i < 2; ++i) {
            Direction newFacing = i == 1 ? facing.m_122424_() : facing;
            int occupiedAspect = this.getOccupiedAspect(startPos, newFacing.m_122435_() + 90.0f);
            if (occupiedAspect >= 0) {
                matrices.m_85836_();
                UtilitiesClient.rotateYDegrees(matrices, -newFacing.m_122435_());
                VertexConsumer vertexConsumer = vertexConsumers.m_6299_(MoreRenderLayers.getLight(new ResourceLocation("mtr:textures/block/white.png"), false));
                this.render(matrices, vertexConsumers, vertexConsumer, entity, tickDelta, newFacing, occupiedAspect, i == 1);
                this.render(matrices, vertexConsumers, vertexConsumer, entity, tickDelta, newFacing, occupiedAspect == 1, i == 1);
                matrices.m_85849_();
            }
            if (this.isSingleSided) break;
        }
        matrices.m_85849_();
    }

    protected void render(PoseStack matrices, MultiBufferSource vertexConsumers, VertexConsumer vertexConsumer, T entity, float tickDelta, Direction facing, int occupiedAspect, boolean isBackSide) {
    }

    protected void render(PoseStack matrices, MultiBufferSource vertexConsumers, VertexConsumer vertexConsumer, T entity, float tickDelta, Direction facing, boolean isOccupied, boolean isBackSide) {
    }

    private int getOccupiedAspect(BlockPos startPos, float facing) {
        HashMap<BlockPos, Float> nodesToScan = new HashMap<BlockPos, Float>();
        nodesToScan.put(startPos, Float.valueOf(facing));
        int occupiedAspect = -1;
        for (int j = 1; j < this.aspects; ++j) {
            HashMap<BlockPos, Float> newNodesToScan = new HashMap<BlockPos, Float>();
            for (Map.Entry checkNode : nodesToScan.entrySet()) {
                Map<BlockPos, Rail> railMap = ClientData.RAILS.get(checkNode.getKey());
                if (railMap == null) continue;
                for (BlockPos endPos : railMap.keySet()) {
                    Rail rail = railMap.get(endPos);
                    if (!rail.facingStart.similarFacing(((Float)checkNode.getValue()).floatValue())) continue;
                    if (ClientData.SIGNAL_BLOCKS.isOccupied(PathData.getRailProduct((BlockPos)checkNode.getKey(), endPos))) {
                        return j;
                    }
                    Boolean isOccupied = ClientData.OCCUPIED_RAILS.get(PathData.getRailProduct((BlockPos)checkNode.getKey(), endPos));
                    if (isOccupied != null && isOccupied.booleanValue()) {
                        return j;
                    }
                    newNodesToScan.put(endPos, Float.valueOf(rail.facingEnd.getOpposite().angleDegrees));
                    occupiedAspect = 0;
                }
            }
            nodesToScan = newNodesToScan;
        }
        return occupiedAspect;
    }

    private static BlockPos getNodePos(BlockGetter world, BlockPos pos, Direction facing) {
        int[] checkDistance;
        for (int z : checkDistance = new int[]{0, 1, -1, 2, -2, 3, -3, 4, -4}) {
            for (int x : checkDistance) {
                for (int y = -5; y <= 0; ++y) {
                    BlockPos checkPos = pos.m_6630_(y).m_5484_(facing.m_122427_(), x).m_5484_(facing, z);
                    BlockState checkState = world.m_8055_(checkPos);
                    if (!(checkState.m_60734_() instanceof BlockNode)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }
}

