/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.SavedRailBase;
import mtr.data.TransportMode;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.screen.DashboardScreen;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public abstract class SavedRailScreenBase<T extends SavedRailBase>
extends ScreenMapper
implements IGui,
IPacket {
    protected final T savedRailBase;
    protected final int textWidth;
    protected final boolean showScheduleControls;
    protected final WidgetShorterSlider sliderDwellTimeMin;
    protected final WidgetShorterSlider sliderDwellTimeSec;
    private final DashboardScreen dashboardScreen;
    private final WidgetBetterTextField textFieldSavedRailNumber;
    private final Component savedRailNumberText;
    protected static final int SECONDS_PER_MINUTE = 60;
    private static final int MAX_SAVED_RAIL_NUMBER_LENGTH = 10;

    public SavedRailScreenBase(T savedRailBase, TransportMode transportMode, DashboardScreen dashboardScreen, Component ... additionalTexts) {
        super((Component)Text.literal(""));
        this.savedRailBase = savedRailBase;
        this.showScheduleControls = !transportMode.continuousMovement;
        this.dashboardScreen = dashboardScreen;
        this.savedRailNumberText = Text.translatable(this.getNumberStringKey(), new Object[0]);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.textFieldSavedRailNumber = new WidgetBetterTextField("1", 10);
        int additionalTextWidths = 0;
        for (Component additionalText : additionalTexts) {
            additionalTextWidths = Math.max(additionalTextWidths, this.f_96547_.m_92852_((FormattedText)additionalText));
        }
        this.textWidth = Math.max(this.f_96547_.m_92852_((FormattedText)this.savedRailNumberText), additionalTextWidths) + 6;
        this.sliderDwellTimeMin = new WidgetShorterSlider(0, 0, (int)Math.floor(10.0), value -> Text.translatable("gui.mtr.arrival_min", value).getString(), null);
        this.sliderDwellTimeSec = new WidgetShorterSlider(0, 0, 119, 10, 2, value -> Text.translatable("gui.mtr.arrival_sec", Float.valueOf((float)value.intValue() / 2.0f)).getString(), null);
    }

    protected void m_7856_() {
        super.m_7856_();
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldSavedRailNumber, 20 + this.textWidth + 2, 22, this.f_96543_ - this.textWidth - 40 - 4);
        this.textFieldSavedRailNumber.m_94144_(((SavedRailBase)this.savedRailBase).name);
        this.textFieldSavedRailNumber.m_94151_(text -> {
            ((SavedRailBase)this.savedRailBase).name = this.textFieldSavedRailNumber.m_94155_();
        });
        int sliderTextWidth = Math.max(this.f_96547_.m_92852_((FormattedText)Text.translatable("gui.mtr.arrival_min", "88")), this.f_96547_.m_92852_((FormattedText)Text.translatable("gui.mtr.arrival_sec", "88.8"))) + 6;
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderDwellTimeMin, 20 + this.textWidth);
        this.sliderDwellTimeMin.setHeight(10);
        this.sliderDwellTimeMin.m_93674_(this.f_96543_ - this.textWidth - 40 - sliderTextWidth);
        this.sliderDwellTimeMin.setValue((int)Math.floor((float)((SavedRailBase)this.savedRailBase).getDwellTime() / 2.0f / 60.0f));
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderDwellTimeSec, 20 + this.textWidth);
        this.sliderDwellTimeSec.setHeight(10);
        this.sliderDwellTimeSec.m_93674_(this.f_96543_ - this.textWidth - 40 - sliderTextWidth);
        this.sliderDwellTimeSec.setValue(((SavedRailBase)this.savedRailBase).getDwellTime() % 120);
        this.addDrawableChild(this.textFieldSavedRailNumber);
        if (this.showScheduleControls) {
            this.addDrawableChild(this.sliderDwellTimeMin);
            this.addDrawableChild(this.sliderDwellTimeSec);
        }
    }

    public void m_96624_() {
        this.textFieldSavedRailNumber.m_94120_();
        UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldSavedRailNumber, this.shouldRenderExtra() ? this.f_96543_ * 2 : 20 + this.textWidth + 2);
        int maxMin = (int)Math.floor(10.0);
        if (this.sliderDwellTimeMin.getIntValue() == 0 && this.sliderDwellTimeSec.getIntValue() == 0) {
            this.sliderDwellTimeSec.setValue(1);
        }
        if (this.sliderDwellTimeMin.getIntValue() == maxMin && this.sliderDwellTimeSec.getIntValue() > 0) {
            this.sliderDwellTimeSec.setValue(0);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            if (this.shouldRenderExtra()) {
                this.renderExtra(matrices, mouseX, mouseY, delta);
            } else {
                this.f_96547_.m_92889_(matrices, this.savedRailNumberText, 20.0f, 28.0f, -1);
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.f_96541_ != null) {
            UtilitiesClient.setScreen(this.f_96541_, this.dashboardScreen);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected boolean shouldRenderExtra() {
        return false;
    }

    protected void renderExtra(PoseStack matrices, int mouseX, int mouseY, float delta) {
    }

    protected abstract String getNumberStringKey();

    protected abstract ResourceLocation getPacketIdentifier();
}

