/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.stream.Collectors;
import mtr.block.BlockTrainAnnouncer;
import mtr.data.DataConverter;
import mtr.data.RailwayData;
import mtr.mappings.RegistryUtilities;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.DashboardList;
import mtr.screen.TrainSensorScreenBase;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrainAnnouncerScreen
extends TrainSensorScreenBase {
    private final String initialMessage;
    private final String initialSoundIdString;
    private final DashboardList availableSoundsList;
    private static final int MAX_MESSAGE_LENGTH = 256;

    public TrainAnnouncerScreen(BlockPos pos) {
        super(pos, true, new Tuple((Object)new WidgetBetterTextField("", 256), (Object)Text.translatable("gui.mtr.announcement_message", new Object[0])), new Tuple((Object)new WidgetBetterTextField("", 256), (Object)Text.translatable("gui.mtr.sound_file", new Object[0])));
        this.f_96541_ = Minecraft.m_91087_();
        ClientLevel world = this.f_96541_.f_91073_;
        if (world != null) {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof BlockTrainAnnouncer.TileEntityTrainAnnouncer) {
                this.initialMessage = ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).getMessage();
                this.initialSoundIdString = ((BlockTrainAnnouncer.TileEntityTrainAnnouncer)entity).getSoundIdString();
            } else {
                this.initialMessage = "";
                this.initialSoundIdString = "";
            }
        } else {
            this.initialMessage = "";
            this.initialSoundIdString = "";
        }
        this.availableSoundsList = new DashboardList((data, color) -> {
            String soundIdString = data.name;
            if (!soundIdString.isEmpty() && world != null && this.f_96541_.f_91074_ != null) {
                world.m_104677_(pos, RegistryUtilities.createSoundEvent(new ResourceLocation(soundIdString)), SoundSource.BLOCKS, 1000000.0f, 1.0f, false);
            }
        }, null, null, null, (data, color) -> {
            this.textFields[1].m_94144_(data.name);
            this.setListVisibility(false);
        }, null, null, () -> "", text -> {}, false);
        this.availableSoundsList.setData(Minecraft.m_91087_().m_91106_().m_120354_().stream().map(soundId -> new DataConverter(soundId.toString(), -15592942)).sorted().collect(Collectors.toList()), true, false, false, false, true, false);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.textFields[0].m_94144_(this.initialMessage);
        this.textFields[1].m_94144_(this.initialSoundIdString);
        this.setListVisibility(false);
        this.availableSoundsList.y = 58;
        this.availableSoundsList.height = this.f_96544_ - this.availableSoundsList.y - 20;
        this.availableSoundsList.width = this.f_96543_ / 2 - 20;
        this.availableSoundsList.init(this::addDrawableChild);
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.availableSoundsList.tick();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (RailwayData.isBetween(mouseX, UtilitiesClient.getWidgetX((AbstractWidget)this.textFields[1]), UtilitiesClient.getWidgetX((AbstractWidget)this.textFields[1]) + this.textFields[1].m_5711_()) && RailwayData.isBetween(mouseY, UtilitiesClient.getWidgetY((AbstractWidget)this.textFields[1]), UtilitiesClient.getWidgetY((AbstractWidget)this.textFields[1]) + this.textFields[1].m_93694_())) {
                this.setListVisibility(true);
            } else if (!RailwayData.isBetween(mouseX, this.availableSoundsList.x, this.availableSoundsList.x + this.availableSoundsList.width) || !RailwayData.isBetween(mouseY, this.availableSoundsList.y, this.availableSoundsList.y + this.availableSoundsList.height)) {
                this.setListVisibility(false);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.availableSoundsList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.availableSoundsList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    protected void renderAdditional(PoseStack matrices) {
        Gui.m_93172_((PoseStack)matrices, (int)this.availableSoundsList.x, (int)this.availableSoundsList.y, (int)(this.availableSoundsList.x + this.availableSoundsList.width), (int)(this.availableSoundsList.y + this.availableSoundsList.height), (int)-15592942);
        this.availableSoundsList.render(matrices, this.f_96547_);
    }

    private void setListVisibility(boolean visible) {
        this.availableSoundsList.x = visible ? this.f_96543_ / 2 : this.f_96543_;
    }
}

