/*
 * Decompiled with CFR 0.152.
 */
package mtr.servlet;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.RouteType;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.libraries.javax.servlet.AsyncContext;
import mtr.libraries.javax.servlet.http.HttpServlet;
import mtr.libraries.javax.servlet.http.HttpServletRequest;
import mtr.libraries.javax.servlet.http.HttpServletResponse;
import mtr.servlet.IServletHandler;
import mtr.servlet.Webserver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class DataServletHandler
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        Webserver.callback.accept(() -> {
            JsonArray dataArray = new JsonArray();
            Webserver.getWorlds.get().forEach(world -> {
                RailwayData railwayData = RailwayData.getInstance(world);
                JsonArray routesArray = new JsonArray();
                JsonObject stationPositionsObject = new JsonObject();
                JsonObject stationsObject = new JsonObject();
                JsonArray typesObject = new JsonArray();
                HashSet types = new HashSet();
                DataCache dataCache = Webserver.getDataCache.apply(railwayData);
                if (dataCache != null) {
                    Webserver.getRoutes.apply(railwayData).forEach(route -> {
                        if (route.isHidden) {
                            return;
                        }
                        JsonObject routeObject = new JsonObject();
                        routeObject.addProperty("color", (Number)route.color);
                        routeObject.addProperty("name", route.name);
                        routeObject.addProperty("number", route.isLightRailRoute ? route.lightRailRouteNumber : "");
                        String type = IServletHandler.createRouteKey(route.transportMode, route.routeType);
                        routeObject.addProperty("type", type);
                        types.add(type);
                        JsonArray routeStationsArray = new JsonArray();
                        routeObject.add("stations", (JsonElement)routeStationsArray);
                        JsonArray routeDurationsArray = new JsonArray();
                        routeObject.add("durations", (JsonElement)routeDurationsArray);
                        JsonArray routeDensityArray = new JsonArray();
                        routeObject.add("densities", (JsonElement)routeDensityArray);
                        routeObject.addProperty("circular", route.circularState == Route.CircularState.NONE ? "" : (route.circularState == Route.CircularState.CLOCKWISE ? "cw" : "ccw"));
                        Depot depot = dataCache.routeIdToOneDepot.get(route.id);
                        float accumulatedTime = 0.0f;
                        BlockPos prevPlatformPos = null;
                        for (int i = 0; i < route.platformIds.size(); ++i) {
                            Platform platform;
                            long prevPlatformId;
                            long platformId = route.platformIds.get((int)i).platformId;
                            float time = 0.0f;
                            if (i > 0 && depot != null && depot.platformTimes.containsKey(prevPlatformId = route.platformIds.get((int)(i - 1)).platformId) && depot.platformTimes.get(prevPlatformId).containsKey(platformId)) {
                                time = depot.platformTimes.get(prevPlatformId).get(platformId).floatValue();
                            }
                            Station station = dataCache.platformIdToStation.get(platformId);
                            boolean addedStation = false;
                            BlockPos thisPlatformPos = null;
                            if (station != null && (platform = dataCache.platformIdMap.get(platformId)) != null) {
                                try {
                                    String newId = station.id + "_" + route.color;
                                    routeStationsArray.add(newId);
                                    thisPlatformPos = platform.getMidPos();
                                    if (stationPositionsObject.has(newId)) {
                                        stationPositionObject = stationPositionsObject.getAsJsonObject(newId);
                                        int existingX = stationPositionObject.get("x").getAsInt();
                                        int existingZ = stationPositionObject.get("y").getAsInt();
                                        stationPositionObject.addProperty("x", (Number)((existingX + thisPlatformPos.m_123341_()) / 2));
                                        stationPositionObject.addProperty("y", (Number)((existingZ + thisPlatformPos.m_123343_()) / 2));
                                    } else {
                                        stationPositionObject = new JsonObject();
                                        stationPositionObject.addProperty("x", (Number)thisPlatformPos.m_123341_());
                                        stationPositionObject.addProperty("y", (Number)thisPlatformPos.m_123343_());
                                        stationPositionObject.addProperty("vertical", Boolean.valueOf(platform.getAxis() == Direction.Axis.Z));
                                        stationPositionsObject.add(newId, (JsonElement)stationPositionObject);
                                    }
                                    JsonObject stationObject = new JsonObject();
                                    stationObject.addProperty("name", station.name);
                                    stationObject.addProperty("color", (Number)station.color);
                                    stationObject.addProperty("zone", (Number)station.zone);
                                    BlockPos stationCenter = station.getCenter();
                                    stationObject.addProperty("x", (Number)(stationCenter == null ? 0 : stationCenter.m_123341_()));
                                    stationObject.addProperty("z", (Number)(stationCenter == null ? 0 : stationCenter.m_123343_()));
                                    JsonArray stationConnectionsArray = new JsonArray();
                                    dataCache.stationIdToConnectingStations.get(station).forEach(connectingStation -> stationConnectionsArray.add(String.valueOf(connectingStation.id)));
                                    stationObject.add("connections", (JsonElement)stationConnectionsArray);
                                    stationsObject.add(String.valueOf(station.id), (JsonElement)stationObject);
                                    addedStation = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (prevPlatformPos != null && thisPlatformPos != null && railwayData != null) {
                                routeDensityArray.add((Number)railwayData.railwayDataRouteFinderModule.getConnectionDensity(prevPlatformPos, thisPlatformPos));
                            } else {
                                routeDensityArray.add((Number)0);
                            }
                            prevPlatformPos = thisPlatformPos;
                            accumulatedTime += time;
                            if (i <= 0 || !addedStation) continue;
                            routeDurationsArray.add((Number)Float.valueOf(accumulatedTime));
                            accumulatedTime = 0.0f;
                        }
                        routesArray.add((JsonElement)routeObject);
                    });
                }
                for (TransportMode transportMode : TransportMode.values()) {
                    for (RouteType routeType : RouteType.values()) {
                        String type = IServletHandler.createRouteKey(transportMode, routeType);
                        if (!types.contains(type)) continue;
                        typesObject.add(type);
                    }
                }
                JsonObject dataObject = new JsonObject();
                dataObject.add("routes", (JsonElement)routesArray);
                dataObject.add("positions", (JsonElement)stationPositionsObject);
                dataObject.add("stations", (JsonElement)stationsObject);
                dataObject.add("types", (JsonElement)typesObject);
                dataArray.add((JsonElement)dataObject);
            });
            IServletHandler.sendResponse(response, asyncContext, dataArray.toString());
        });
    }
}

