/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityPheasant;
import dev.itsmeow.betteranimalsplus.common.entity.ai.EntityAIEatBerries;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithSelectiveTypes;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class EntityBoar
extends EntityAnimalWithSelectiveTypes
implements Enemy,
IDropHead<EntityAnimalWithTypes> {
    private static final String[] SNOWY_CONIFEROUS_TYPES = new String[]{"dark_brown", "gray"};
    private static final String[] ALL_BOAR_TYPES = new String[]{"dark_brown", "light_brown", "gray"};

    public EntityBoar(EntityType<? extends EntityBoar> entityType, Level worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)entityType, worldIn);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            public boolean m_8036_() {
                return !EntityBoar.this.m_6162_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !EntityBoar.this.m_6162_() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        if (this.getContainer().getCustomConfiguration().getBoolean("nerf_options/eat_crops")) {
            this.f_21345_.m_25352_(4, (Goal)new BoarAIEatCrops(this));
            this.f_21345_.m_25352_(5, (Goal)new EntityAIEatBerries((PathfinderMob)this, 1.0, 12, 2){

                @Override
                protected void eatBerry() {
                    super.eatBerry();
                    if (EntityBoar.this.getContainer().getCustomConfiguration().getBoolean("nerf_options/breed_from_crops")) {
                        EntityBoar.this.m_27595_(null);
                    }
                }
            });
        }
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return !EntityBoar.this.m_6162_() && !EntityBoar.this.isPeaceful() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !EntityBoar.this.m_6162_() && !EntityBoar.this.isPeaceful() && super.m_8045_();
            }
        }.m_26044_(new Class[]{EntityBoar.class}));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<Animal>((Mob)this, Animal.class, 90, true, true, in -> in instanceof Chicken || in instanceof EntityPheasant || in instanceof Animal && in.m_6162_() && !(in instanceof EntityBoar) && !(in instanceof Pig) && !(in instanceof Hoglin)){

            public boolean m_8036_() {
                return EntityBoar.this.shouldAttack() && EntityBoar.this.attackChance() && super.m_8036_();
            }

            public boolean m_8045_() {
                return EntityBoar.this.shouldAttack() && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 50, true, true, in -> in instanceof Animal && !(in instanceof EntityBoar) && !(in instanceof Pig) && !(in instanceof Hoglin) || in instanceof Player){

            public boolean m_8036_() {
                return EntityBoar.this.shouldAttack() && EntityBoar.this.attackChance() && super.m_8036_();
            }

            public boolean m_8045_() {
                return EntityBoar.this.shouldAttack() && super.m_8045_();
            }
        });
    }

    public boolean shouldAttack() {
        return !this.m_6162_() && !this.isPeaceful();
    }

    public boolean attackChance() {
        return (double)this.getContainer().getCustomConfiguration().getInt("nerf_options/target_chance") / 100.0 > Math.random();
    }

    public boolean isPeaceful() {
        return this.f_19853_.m_46791_() == Difficulty.PEACEFUL;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12233_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12235_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12234_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.doHeadDrop();
    }

    protected ResourceLocation m_7582_() {
        return EntityType.f_20510_.m_20677_();
    }

    public boolean m_7327_(Entity entityIn) {
        Vec3 pos = this.m_20182_();
        Vec3 targetPos = entityIn.m_20182_();
        ((LivingEntity)entityIn).m_147240_((double)0.8f, pos.f_82479_ - targetPos.f_82479_, pos.f_82481_ - targetPos.f_82481_);
        return super.m_7327_(entityIn);
    }

    public void m_8038_(ServerLevel p_241841_1_, LightningBolt p_241841_2_) {
        if (!this.f_19853_.f_46443_ && !this.f_20890_) {
            ZombifiedPiglin entitypigzombie = (ZombifiedPiglin)EntityType.f_20531_.m_20615_(this.f_19853_);
            entitypigzombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
            entitypigzombie.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            entitypigzombie.m_21557_(this.m_21525_());
            if (this.m_8077_()) {
                entitypigzombie.m_6593_(this.m_7770_());
                entitypigzombie.m_20340_(true);
            }
            this.f_19853_.m_7967_((Entity)entitypigzombie);
            this.m_146870_();
        }
    }

    @Override
    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        if (this.getVariant().isPresent()) {
            if (ageable instanceof EntityBoar) {
                EntityBoar boar = (EntityBoar)this.getContainer().getEntityType().m_20615_((Level)world);
                boar.setType((IVariant)this.getVariant().get());
                return boar;
            }
            if (ageable instanceof Pig) {
                Pig pig = new Pig(EntityType.f_20510_, this.f_19853_);
                EntityBoar boar = (EntityBoar)this.getContainer().getEntityType().m_20615_((Level)world);
                boar.setType((IVariant)this.getVariant().get());
                return this.f_19796_.nextBoolean() ? pig : boar;
            }
        }
        return null;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal != this && (otherAnimal instanceof EntityBoar || otherAnimal instanceof Pig)) {
            return otherAnimal.m_27593_() && this.m_27593_();
        }
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == DamageSource.f_19325_;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42619_ || stack.m_41720_() == Items.f_42677_;
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (types.contains(BiomeTypes.CONIFEROUS) && types.contains(BiomeTypes.SNOWY)) {
            return SNOWY_CONIFEROUS_TYPES;
        }
        if (types.contains(BiomeTypes.SNOWY) && !types.contains(BiomeTypes.CONIFEROUS) && !types.contains(BiomeTypes.FOREST)) {
            return new String[]{"gray"};
        }
        return ALL_BOAR_TYPES;
    }

    @Override
    public EntityTypeContainer<EntityBoar> getContainer() {
        return ModEntities.BOAR;
    }

    @Override
    protected EntityAnimalWithTypes getBaseChild() {
        return (EntityAnimalWithTypes)this.getContainer().getEntityType().m_20615_(this.f_19853_);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        return EntityUtil.childChance((AgeableMob)this, reason, super.m_6518_(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    public static class BoarAIEatCrops
    extends MoveToBlockGoal {
        private final EntityBoar boar;

        public BoarAIEatCrops(EntityBoar boarIn) {
            super((PathfinderMob)boarIn, 0.7, 16);
            this.boar = boarIn;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0 && !ModPlatformEvents.mobGrief(this.boar.f_19853_, (Mob)this.boar)) {
                return false;
            }
            return !this.boar.m_27593_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.boar.m_27593_() && super.m_8045_();
        }

        public void m_8037_() {
            if (!this.f_25602_.m_123314_((Vec3i)this.f_25598_.m_142538_(), this.m_8052_())) {
                this.boar.m_21566_().m_6849_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5, this.f_25599_);
            } else {
                Level world = this.boar.f_19853_;
                BlockPos pos = this.f_25602_;
                BlockState state = world.m_8055_(pos);
                Block block = state.m_60734_();
                if (!this.boar.m_27593_() && block instanceof CropBlock && ((CropBlock)block).m_52307_(state)) {
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                    world.m_46961_(pos, true);
                    if (this.boar.getContainer().getCustomConfiguration().getBoolean("nerf_options/breed_from_crops")) {
                        this.boar.m_27595_(null);
                    }
                }
            }
            this.boar.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_() + 0.5, (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.boar.m_8132_());
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            BlockState state = worldIn.m_8055_(pos);
            Block block = state.m_60734_();
            if (!this.boar.m_27593_() && block instanceof CropBlock && ((CropBlock)block).m_52307_(state)) {
                return worldIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50093_;
            }
            return false;
        }
    }
}

