/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.ai.HungerNonTamedTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityTameableBetterAnimalsPlus;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityTameableWithSelectiveTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.EntityVariant;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import dev.itsmeow.betteranimalsplus.init.ModResources;
import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityFeralWolf
extends EntityTameableWithSelectiveTypes
implements IDropHead<EntityTameableBetterAnimalsPlus>,
IHaveHunger<EntityTameableBetterAnimalsPlus> {
    public static final double TAMED_HEALTH = 30.0;
    public static final double UNTAMED_HEALTH = 10.0;
    protected static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.m_135353_(EntityFeralWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final String[] SNOWY_CONIFEROUS_TYPES = new String[]{"snowy", "timber"};
    private static final String[] CONIFEROUS_FOREST_TYPES = new String[]{"brown", "red", "timber", "black"};
    private static final String[] ALL_TYPES = new String[]{"black", "snowy", "timber", "arctic", "brown", "red"};
    private int hunger;

    public EntityFeralWolf(EntityType<? extends EntityFeralWolf> entityType, Level worldIn) {
        super((EntityType<? extends EntityTameableWithSelectiveTypes>)entityType, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, e -> e.f_19853_.m_46791_() != Difficulty.PEACEFUL));
        this.f_21346_.m_25352_(4, new HungerNonTamedTargetGoal<Animal, EntityFeralWolf>(this, Animal.class, false, e -> e instanceof Sheep || e instanceof Rabbit));
        this.f_21346_.m_25352_(4, new HungerNonTamedTargetGoal<Villager, EntityFeralWolf>(this, Villager.class, false, e -> true));
        this.f_21346_.m_25352_(4, new HungerNonTamedTargetGoal<AbstractIllager, EntityFeralWolf>(this, AbstractIllager.class, false, e -> true));
        this.f_21346_.m_25352_(4, new HungerNonTamedTargetGoal<Chicken, EntityFeralWolf>(this, Chicken.class, false, e -> true));
        this.f_21346_.m_25352_(5, new HungerNearestAttackableTargetGoal<AbstractSkeleton, EntityFeralWolf>(this, AbstractSkeleton.class, false));
    }

    @Override
    public int getHunger() {
        return this.hunger;
    }

    @Override
    public void setHunger(int hunger) {
        this.hunger = hunger;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeHunger(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.readHunger(compound);
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.doHeadDrop();
    }

    protected void m_8024_() {
        super.m_8024_();
        this.f_19804_.m_135381_(DATA_HEALTH_ID, (Object)Float.valueOf(this.m_21223_()));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HEALTH_ID, (Object)Float.valueOf(this.m_21223_()));
    }

    protected void m_7355_(BlockPos pos, BlockState blockStateIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        if (!this.m_21824_() || this.m_5448_() != null) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.nextInt(3) == 0) {
            return this.m_21824_() && (double)((Float)this.f_19804_.m_135370_(DATA_HEALTH_ID)).floatValue() < 15.0 ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            this.incrementHunger();
        }
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (this.m_21825_()) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_21824_()) {
            FoodProperties food;
            if (!itemstack.m_41619_() && itemstack.m_41720_().m_41472_() && (food = itemstack.m_41720_().m_41473_()).m_38746_() && (double)((Float)this.f_19804_.m_135370_(DATA_HEALTH_ID)).floatValue() < 30.0) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(food.m_38744_());
                return InteractionResult.SUCCESS;
            }
            if (!(!this.m_21830_((LivingEntity)player) || this.f_19853_.f_46443_ || this.m_6898_(itemstack) || itemstack.m_41720_().m_41472_() && itemstack.m_41720_().m_41473_().m_38746_())) {
                this.m_21839_(!this.m_21825_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
        } else if (this.isTamingItem(itemstack.m_41720_())) {
            ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
            if (stack.m_204117_(ModResources.Tags.Items.FERAL_WOLF_TAME_ARMOR)) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    if (this.f_19796_.nextInt(100) <= 14 && !ModPlatformEvents.tame(this, player)) {
                        this.m_21828_(player);
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        this.m_21839_(true);
                        this.m_21153_(30.0f);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_) {
                player.m_6352_((Component)new TranslatableComponent("entity.betteranimalsplus.feralwolf.message.wear_head"), Util.f_137441_);
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_142668_() {
        return this.m_21824_() && super.m_142668_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (!this.m_21824_()) {
            return -0.15f;
        }
        return this.m_21824_() ? 0.25f - (this.m_21233_() - ((Float)this.f_19804_.m_135370_(DATA_HEALTH_ID)).floatValue()) * 0.04f : -0.85f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ModItems.ANTLER.get();
    }

    public int m_5792_() {
        return 8;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper) && !(target instanceof Ghast)) {
            EntityFeralWolf entityferalwolf;
            if (target instanceof EntityFeralWolf && (entityferalwolf = (EntityFeralWolf)target).m_21824_() && entityferalwolf.m_142480_() == owner) {
                return false;
            }
            if (target instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).m_30614_();
        }
        return false;
    }

    public boolean m_6573_(Player player) {
        return this.m_21824_() && super.m_6573_(player);
    }

    @Override
    protected EntityFeralWolf getBaseChild() {
        EntityFeralWolf wolf = (EntityFeralWolf)this.getContainer().getEntityType().m_20615_(this.f_19853_);
        if (this.m_21824_()) {
            wolf.m_7105_(true);
            wolf.m_21816_(this.m_142504_());
        }
        return wolf;
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (types.contains(BiomeTypes.FOREST) && !types.contains(BiomeTypes.CONIFEROUS)) {
            return new String[]{"timber", "red"};
        }
        if (types.contains(BiomeTypes.CONIFEROUS)) {
            if (types.contains(BiomeTypes.SNOWY)) {
                return SNOWY_CONIFEROUS_TYPES;
            }
            return new String[]{"black", "timber", "red"};
        }
        if (types.contains(BiomeTypes.SNOWY) && !types.contains(BiomeTypes.FOREST)) {
            return new String[]{"snowy", "arctic"};
        }
        if (types.contains(BiomeTypes.FOREST) && types.contains(BiomeTypes.CONIFEROUS) && !types.contains(BiomeTypes.SNOWY)) {
            return CONIFEROUS_FOREST_TYPES;
        }
        return ALL_TYPES;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        this.setInitialHunger();
        return EntityUtil.childChance((AgeableMob)this, reason, super.m_6518_(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    protected ResourceLocation m_7582_() {
        IVariant variant;
        if (this.getVariant().isPresent() && (variant = (IVariant)this.getVariant().get()) instanceof WolfVariant) {
            return ((WolfVariant)variant).getLootTable();
        }
        return null;
    }

    @Override
    public EntityTypeContainerBAPTameable<? extends EntityFeralWolf> getContainer() {
        return ModEntities.FERAL_WOLF;
    }

    public static class WolfVariant
    extends EntityVariant {
        private final ResourceLocation neutralTexture;
        private final ResourceLocation lootTable;

        public WolfVariant(String nameTexture) {
            super("betteranimalsplus", nameTexture, "feralwolf_" + nameTexture);
            this.neutralTexture = new ResourceLocation("betteranimalsplus", "textures/entity/feralwolf_" + nameTexture + "_neutral.png");
            this.lootTable = new ResourceLocation("betteranimalsplus", "entities/feralwolf_" + nameTexture);
        }

        @Override
        public ResourceLocation getTexture(Entity entity) {
            if (entity instanceof EntityFeralWolf && ((EntityFeralWolf)entity).m_21824_()) {
                return this.neutralTexture;
            }
            return super.getTexture(entity);
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }
    }
}

