/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.IDropHead;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import java.util.Calendar;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityReindeer
extends Animal
implements PlayerRideableJumping,
IVariantTypes<EntityReindeer>,
IDropHead<EntityReindeer> {
    protected static final Predicate<LivingEntity> IS_REINDEER_BREEDING = entity -> entity instanceof EntityReindeer && ((EntityReindeer)entity).isBreeding();
    private static final TargetingConditions PARENT_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26888_(IS_REINDEER_BREEDING);
    protected static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.m_135353_(EntityReindeer.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int eatingCounter;
    private int openMouthCounter;
    private int jumpRearingCounter;
    public int tailCounter;
    public int sprintCounter;
    protected boolean reindeerJumping;
    protected float jumpPower;
    private boolean allowStandSliding;
    private float headLean;
    private float prevHeadLean;
    private float rearingAmount;
    private float prevRearingAmount;
    private float mouthOpenness;
    private float prevMouthOpenness;
    protected boolean canGallop = true;
    protected int gallopTime;
    public boolean parentRudolph = false;
    public static final String CREATE_SNOW_KEY = "create_snow";

    public EntityReindeer(EntityType<? extends EntityReindeer> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0, EntityReindeer.class));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerTypeKey();
        this.f_19804_.m_135372_(STATUS, (Object)0);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean flag;
        ItemStack itemstack = player.m_21120_(hand);
        boolean bl = flag = !itemstack.m_41619_();
        if (flag && itemstack.m_41720_() instanceof SpawnEggItem) {
            return super.m_6071_(player, hand);
        }
        if (!this.m_6162_()) {
            if (player.m_6047_()) {
                return InteractionResult.PASS;
            }
            if (this.m_20160_()) {
                return super.m_6071_(player, hand);
            }
        }
        if (flag) {
            if (this.handleEating(player, itemstack)) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41647_(player, (LivingEntity)this, hand) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
        }
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        this.mountTo(player);
        return InteractionResult.SUCCESS;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityReindeer)) {
            return false;
        }
        return this.canMate() && ((EntityReindeer)otherAnimal).canMate();
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob ageable) {
        EntityReindeer reindeer = (EntityReindeer)this.getContainer().getEntityType().m_20615_((Level)world);
        this.setOffspringAttributes(ageable, reindeer);
        if (ageable instanceof EntityReindeer) {
            EntityReindeer other = (EntityReindeer)ageable;
            if (other.getVariantNameOrEmpty().endsWith("christmas")) {
                reindeer.setType((IVariant)other.getVariant().get());
            } else {
                reindeer.setType((IVariant)this.getVariant().get());
            }
            if (other.m_8077_() && other.m_7770_().getString().equalsIgnoreCase("rudolph") || this.m_8077_() && this.m_7770_().getString().equalsIgnoreCase("rudolph")) {
                reindeer.parentRudolph = true;
            }
        } else {
            reindeer.setType((IVariant)this.getVariant().get());
        }
        return reindeer;
    }

    protected boolean getReindeerWatchableBoolean(int p_110233_1_) {
        return ((Byte)this.f_19804_.m_135370_(STATUS) & p_110233_1_) != 0;
    }

    protected void setReindeerWatchableBoolean(int p_110208_1_, boolean p_110208_2_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(STATUS);
        if (p_110208_2_) {
            this.f_19804_.m_135381_(STATUS, (Object)((byte)(b0 | p_110208_1_)));
        } else {
            this.f_19804_.m_135381_(STATUS, (Object)((byte)(b0 & ~p_110208_1_)));
        }
    }

    public boolean isReindeerJumping() {
        return this.reindeerJumping;
    }

    public void setReindeerJumping(boolean jumping) {
        this.reindeerJumping = jumping;
    }

    public boolean m_6573_(Player player) {
        return super.m_6573_(player);
    }

    protected void m_7880_(float p_142017_1_) {
        if (p_142017_1_ > 6.0f && this.isEatingHaystack()) {
            this.setEatingHaystack(false);
        }
    }

    public boolean isEatingHaystack() {
        return this.getReindeerWatchableBoolean(16);
    }

    public boolean isRearing() {
        return this.getReindeerWatchableBoolean(32);
    }

    public boolean isBreeding() {
        return this.getReindeerWatchableBoolean(8);
    }

    public void setBreeding(boolean breeding) {
        this.setReindeerWatchableBoolean(8, breeding);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7639_();
        return (!this.m_20160_() || entity == null || !this.m_20363_(entity)) && super.m_6469_(source, amount);
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    private void eatingReindeer() {
        this.openReindeerMouth();
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11976_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource src) {
        int i;
        if (distance > 1.0f) {
            this.m_5496_(SoundEvents.f_11980_, 0.4f, 1.0f);
        }
        if ((i = Mth.m_14167_((float)((distance * 0.5f - 3.0f) * damageMultiplier))) > 0) {
            BlockPos pos;
            BlockState iblockstate;
            this.m_6469_(DamageSource.f_19315_, i);
            if (this.m_20160_()) {
                for (Entity entity : this.m_146897_()) {
                    entity.m_6469_(DamageSource.f_19315_, (float)i);
                }
            }
            if ((iblockstate = this.f_19853_.m_8055_(pos = new BlockPos(this.m_20185_(), this.m_20186_() - 0.2 - (double)this.f_19859_, this.m_20189_()))).m_60767_() != Material.f_76296_ && !this.m_20067_()) {
                Block block = iblockstate.m_60734_();
                SoundType soundtype = block.m_49962_(block.m_49966_());
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundtype.m_56776_(), this.m_5720_(), soundtype.m_56773_() * 0.5f, soundtype.m_56774_() * 0.75f);
            }
        }
        return true;
    }

    public double getReindeerJumpStrength() {
        return this.m_21051_(Attributes.f_22288_).m_22135_();
    }

    protected SoundEvent m_5592_() {
        this.openReindeerMouth();
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        this.openReindeerMouth();
        if (this.f_19796_.nextInt(3) == 0) {
            this.makeReindeerRear();
        }
        return null;
    }

    protected SoundEvent m_7515_() {
        this.openReindeerMouth();
        if (this.f_19796_.nextInt(10) == 0 && !this.m_6107_()) {
            this.makeReindeerRear();
        }
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState blockStateIn) {
        if (!blockStateIn.m_60767_().m_76332_()) {
            SoundType soundtype = blockStateIn.m_60827_();
            if (this.f_19853_.m_8055_(pos.m_7494_()).m_60734_() == Blocks.f_50125_) {
                soundtype = Blocks.f_50125_.m_49962_(Blocks.f_50125_.m_49966_());
            }
            if (this.m_20160_() && this.canGallop) {
                ++this.gallopTime;
                if (this.gallopTime > 5 && this.gallopTime % 3 == 0) {
                    this.playGallopSound(soundtype);
                } else if (this.gallopTime <= 5) {
                    this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
                }
            } else if (soundtype == SoundType.f_56736_) {
                this.m_5496_(SoundEvents.f_12036_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            } else {
                this.m_5496_(SoundEvents.f_12035_, soundtype.m_56773_() * 0.15f, soundtype.m_56774_());
            }
        }
    }

    protected void playGallopSound(SoundType p_190680_1_) {
        this.m_5496_(SoundEvents.f_11977_, p_190680_1_.m_56773_() * 0.15f, p_190680_1_.m_56774_());
    }

    public int m_5792_() {
        return 6;
    }

    protected float m_6121_() {
        return 0.8f;
    }

    public int m_8100_() {
        return 400;
    }

    protected boolean handleEating(Player player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        Item item = stack.m_41720_();
        if (item == Items.f_42405_ || item == Items.f_42619_) {
            f = 2.0f;
            i = 20;
            if (!this.m_6162_() && !this.m_27593_()) {
                flag = true;
                this.m_27595_(player);
            }
        } else if (item == Items.f_42501_) {
            f = 1.0f;
            i = 30;
        } else if (item == Blocks.f_50335_.m_5456_()) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.f_42410_) {
            f = 3.0f;
            i = 60;
        } else if (item == Items.f_42677_) {
            f = 4.0f;
            i = 60;
            if (this.m_146764_() == 0 && !this.m_27593_()) {
                flag = true;
                this.m_27595_(player);
            }
        } else if (item == Items.f_42436_) {
            f = 10.0f;
            i = 240;
            if (this.m_146764_() == 0 && !this.m_27593_()) {
                flag = true;
                this.m_27595_(player);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
            if (!this.f_19853_.f_46443_) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (flag) {
            this.eatingReindeer();
        }
        return flag;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.doHeadDrop();
    }

    protected void mountTo(Player player) {
        player.m_146922_(this.m_146908_());
        player.m_146926_(this.m_146909_());
        this.setEatingHaystack(false);
        this.setRearing(false);
        if (player instanceof ServerPlayer) {
            ModTriggers.RIDE_REINDEER.trigger((ServerPlayer)player);
        }
        if (!this.f_19853_.f_46443_) {
            player.m_20329_((Entity)this);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() && this.m_20160_() || this.isEatingHaystack() || this.isRearing();
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public void m_8107_() {
        if (this.f_19796_.nextInt(200) == 0) {
            this.moveTail();
        }
        super.m_8107_();
        if (this.f_19853_.m_5776_() && this.getContainer().getCustomConfigurationClient().getBoolean(CREATE_SNOW_KEY) && this.f_19796_.nextInt(10) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_() + (double)this.f_19796_.nextInt(4) - 2.0, this.m_20186_() + (double)this.f_19796_.nextInt(4), this.m_20189_() + (double)this.f_19796_.nextInt(4) - 2.0, 0.0, (double)-0.2f, 0.0);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.f_19796_.nextInt(900) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEatingHaystack() && !this.m_20160_() && this.f_19796_.nextInt(300) == 0 && this.f_19853_.m_8055_(new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()) - 1, Mth.m_14107_((double)this.m_20189_()))).m_60734_() == Blocks.f_50034_) {
                    this.setEatingHaystack(true);
                }
                if (this.isEatingHaystack() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEatingHaystack(false);
                }
            }
            this.followMother();
        }
    }

    protected void followMother() {
        LivingEntity livingentity;
        if (this.isBreeding() && this.m_6162_() && !this.isEatingHaystack() && (livingentity = this.f_19853_.m_45963_(AbstractHorse.class, PARENT_TARGETING, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_142469_().m_82400_(16.0))) != null && this.m_20280_((Entity)livingentity) > 4.0) {
            this.f_21344_.m_6570_((Entity)livingentity, 0);
        }
    }

    public boolean canEatGrass() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.openMouthCounter > 0 && ++this.openMouthCounter > 30) {
            this.openMouthCounter = 0;
            this.setReindeerWatchableBoolean(64, false);
        }
        if (this.m_6109_() && this.jumpRearingCounter > 0 && ++this.jumpRearingCounter > 20) {
            this.jumpRearingCounter = 0;
            this.setRearing(false);
        }
        if (this.tailCounter > 0 && ++this.tailCounter > 8) {
            this.tailCounter = 0;
        }
        if (this.sprintCounter > 0) {
            ++this.sprintCounter;
            if (this.sprintCounter > 300) {
                this.sprintCounter = 0;
            }
        }
        this.prevHeadLean = this.headLean;
        if (this.isEatingHaystack()) {
            this.headLean += (1.0f - this.headLean) * 0.4f + 0.05f;
            if (this.headLean > 1.0f) {
                this.headLean = 1.0f;
            }
        } else {
            this.headLean += (0.0f - this.headLean) * 0.4f - 0.05f;
            if (this.headLean < 0.0f) {
                this.headLean = 0.0f;
            }
        }
        this.prevRearingAmount = this.rearingAmount;
        if (this.isRearing()) {
            this.prevHeadLean = this.headLean = 0.0f;
            this.rearingAmount += (1.0f - this.rearingAmount) * 0.4f + 0.05f;
            if (this.rearingAmount > 1.0f) {
                this.rearingAmount = 1.0f;
            }
        } else {
            this.allowStandSliding = false;
            this.rearingAmount += (0.8f * this.rearingAmount * this.rearingAmount * this.rearingAmount - this.rearingAmount) * 0.6f - 0.05f;
            if (this.rearingAmount < 0.0f) {
                this.rearingAmount = 0.0f;
            }
        }
        this.prevMouthOpenness = this.mouthOpenness;
        if (this.getReindeerWatchableBoolean(64)) {
            this.mouthOpenness += (1.0f - this.mouthOpenness) * 0.7f + 0.05f;
            if (this.mouthOpenness > 1.0f) {
                this.mouthOpenness = 1.0f;
            }
        } else {
            this.mouthOpenness += (0.0f - this.mouthOpenness) * 0.7f - 0.05f;
            if (this.mouthOpenness < 0.0f) {
                this.mouthOpenness = 0.0f;
            }
        }
    }

    private void openReindeerMouth() {
        if (!this.f_19853_.f_46443_) {
            this.openMouthCounter = 1;
            this.setReindeerWatchableBoolean(64, true);
        }
    }

    public void setEatingHaystack(boolean p_110227_1_) {
        this.setReindeerWatchableBoolean(16, p_110227_1_);
    }

    public void setRearing(boolean rearing) {
        if (rearing) {
            this.setEatingHaystack(false);
        }
        this.setReindeerWatchableBoolean(32, rearing);
    }

    private void makeReindeerRear() {
        if (this.m_6109_()) {
            this.jumpRearingCounter = 1;
            this.setRearing(true);
        }
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_20160_() && this.m_5807_()) {
            double d0;
            LivingEntity entitylivingbase = (LivingEntity)this.m_6688_();
            this.m_146922_(entitylivingbase.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entitylivingbase.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            vec = vec.m_82520_((double)(entitylivingbase.f_20900_ * 0.5f) - vec.f_82479_, vec.f_82480_, vec.f_82481_);
            vec = vec.m_82520_(vec.f_82479_, vec.f_82480_, (double)entitylivingbase.f_20902_ - vec.f_82481_);
            if (vec.f_82481_ <= 0.0) {
                vec = vec.m_82542_(1.0, 1.0, 0.25);
                this.gallopTime = 0;
            }
            if (this.f_19861_ && this.jumpPower == 0.0f && this.isRearing() && !this.allowStandSliding) {
                vec = vec.m_82542_(0.0, 1.0, 0.0);
            }
            if (this.jumpPower > 0.0f && !this.isReindeerJumping() && this.f_19861_) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, this.getReindeerJumpStrength() * (double)this.jumpPower - this.m_20184_().f_82480_, 0.0));
                if (this.m_21023_(MobEffects.f_19603_)) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)((float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1) * 0.1f), 0.0));
                }
                this.setReindeerJumping(true);
                this.f_19812_ = true;
                if (vec.f_82481_ > 0.0) {
                    float f = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    float f1 = Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
                    this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f * this.jumpPower), 0.0, (double)(0.4f * f1 * this.jumpPower)));
                    this.m_5496_(SoundEvents.f_11979_, 0.4f, 1.0f);
                }
                this.jumpPower = 0.0f;
            }
            this.f_20887_ = this.m_6113_() * 0.1f;
            if (this.m_6109_()) {
                this.m_7910_((float)this.m_21051_(Attributes.f_22279_).m_22135_());
                super.m_7023_(vec);
            } else if (entitylivingbase instanceof Player) {
                this.m_20334_(0.0, 0.0, 0.0);
            }
            if (this.f_19861_) {
                this.jumpPower = 0.0f;
                this.setReindeerJumping(false);
            }
            this.f_20923_ = this.f_20924_;
            double d1 = this.m_20185_() - this.f_19854_;
            double f2 = Math.sqrt(d1 * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0;
            if (f2 > 1.0) {
                f2 = 1.0;
            }
            this.f_20924_ = (float)((double)this.f_20924_ + (f2 - (double)this.f_20924_) * (double)0.4f);
            this.f_20925_ += this.f_20924_;
        } else {
            this.f_20887_ = 0.02f;
            super.m_7023_(vec);
        }
    }

    public void m_6593_(Component comp) {
        if (comp != null && comp.getString().equalsIgnoreCase("rudolph") && this.getVariant().isPresent() && !this.getVariantNameOrEmpty().endsWith("_christmas")) {
            this.setType(this.getVariantNameOrEmpty() + "_christmas");
        }
        super.m_6593_(comp);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("EatingHaystack", this.isEatingHaystack());
        compound.m_128379_("Bred", this.isBreeding());
        this.writeType(compound);
        compound.m_128379_("IsParentRudolph", this.parentRudolph);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEatingHaystack(compound.m_128471_("EatingHaystack"));
        this.setBreeding(compound.m_128471_("Bred"));
        this.parentRudolph = compound.m_128471_("IsParentRudolph");
        this.readType(compound);
        Calendar calendar = Calendar.getInstance();
        if (!(!this.getVariantNameOrEmpty().endsWith("_christmas") || calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28 || this.m_7770_().getString().equalsIgnoreCase("rudolph") || this.parentRudolph)) {
            this.setType(this.getVariantNameOrEmpty().substring(0, 1));
        }
    }

    protected boolean canMate() {
        return !this.m_20160_() && this.m_20202_() == null && !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    protected void setOffspringAttributes(AgeableMob p_190681_1_, EntityReindeer p_190681_2_) {
        double d0 = this.m_21172_(Attributes.f_22276_) + p_190681_1_.m_21172_(Attributes.f_22276_) + (double)this.getModifiedMaxHealth();
        p_190681_2_.m_21051_(Attributes.f_22276_).m_22100_(d0 / 3.0);
        double d1 = this.m_21172_(Attributes.f_22288_) + p_190681_1_.m_21172_(Attributes.f_22288_) + this.getModifiedJumpStrength();
        p_190681_2_.m_21051_(Attributes.f_22288_).m_22100_(d1 / 3.0);
        double d2 = this.m_21172_(Attributes.f_22279_) + p_190681_1_.m_21172_(Attributes.f_22279_) + this.getModifiedMovementSpeed();
        p_190681_2_.m_21051_(Attributes.f_22279_).m_22100_(d2 / 3.0);
    }

    public boolean m_5807_() {
        return this.m_6688_() instanceof LivingEntity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getGrassEatingAmount(float p_110258_1_) {
        return this.prevHeadLean + (this.headLean - this.prevHeadLean) * p_110258_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRearingAmount(float p_110223_1_) {
        return this.prevRearingAmount + (this.rearingAmount - this.prevRearingAmount) * p_110223_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getMouthOpennessAngle(float p_110201_1_) {
        return this.prevMouthOpenness + (this.mouthOpenness - this.prevMouthOpenness) * p_110201_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7888_(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        } else {
            this.allowStandSliding = true;
            this.makeReindeerRear();
        }
        this.jumpPower = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    public boolean m_7132_() {
        return true;
    }

    public void m_7199_(int p_184775_1_) {
        this.allowStandSliding = true;
        this.makeReindeerRear();
    }

    public void m_8012_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void spawnReindeerParticles(boolean p_110216_1_) {
        SimpleParticleType enumparticletypes = p_110216_1_ ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)enumparticletypes, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 7) {
            this.spawnReindeerParticles(true);
        } else if (id == 6) {
            this.spawnReindeerParticles(false);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (passenger instanceof Mob) {
            Mob entityliving = (Mob)passenger;
            this.f_20883_ = entityliving.f_20883_;
        }
        if (this.prevRearingAmount > 0.0f) {
            float f3 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = 0.7f * this.prevRearingAmount;
            float f2 = 0.15f * this.prevRearingAmount;
            passenger.m_6034_(this.m_20185_() + (double)(f1 * f3), this.m_20186_() + this.m_6048_() + passenger.m_6049_() + (double)f2, this.m_20189_() - (double)(f1 * f));
            if (passenger instanceof LivingEntity) {
                ((LivingEntity)passenger).f_20883_ = this.f_20883_;
            }
        }
    }

    protected float getModifiedMaxHealth() {
        return 15.0f + (float)this.f_19796_.nextInt(8) + (float)this.f_19796_.nextInt(9);
    }

    protected double getModifiedJumpStrength() {
        return (double)0.4f + this.f_19796_.nextDouble() * 0.2 + this.f_19796_.nextDouble() * 0.2 + this.f_19796_.nextDouble() * 0.2;
    }

    protected double getModifiedMovementSpeed() {
        return ((double)0.45f + this.f_19796_.nextDouble() * 0.3 + this.f_19796_.nextDouble() * 0.3 + this.f_19796_.nextDouble() * 0.3) * 0.25;
    }

    public boolean m_6147_() {
        return false;
    }

    public Entity m_6688_() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.getModifiedMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.getModifiedMovementSpeed());
        this.m_21051_(Attributes.f_22288_).m_22100_(this.getModifiedJumpStrength());
        return this.initAgeableData((LevelAccessor)world, reason, super.m_6518_(world, difficulty, reason, livingdata, compound));
    }

    @Override
    public IVariant getRandomType() {
        Calendar calendar = Calendar.getInstance();
        boolean isChristmasSeason = calendar.get(2) + 1 == 12 && calendar.get(5) >= 22 && calendar.get(5) <= 28;
        boolean redNosed = this.f_19796_.nextInt(9) == 0;
        return this.getContainer().getVariantForName(this.f_19796_.nextInt(4) + 1 + (isChristmasSeason && redNosed ? "_christmas" : "")).orElse(IVariantTypes.super.getRandomType());
    }

    public boolean m_6785_(double range) {
        return this.despawn(range);
    }

    @Override
    public EntityReindeer getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<EntityReindeer> getContainer() {
        return ModEntities.REINDEER;
    }

    @Override
    public void doHeadDrop() {
        this.getHeadType().drop((Mob)this, 12, this.getContainer().getVariantForName(this.getVariantNameOrEmpty().substring(0, 1)).get());
    }
}

