/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity.util.abstracts;

import dev.itsmeow.betteranimalsplus.common.entity.ai.PeacefulNearestAttackableTargetGoal;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingWithTypesBucketable;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityEelBase
extends EntityWaterMobPathingWithTypesBucketable {
    private static final Predicate<ItemEntity> ITEM_SELECTOR = item -> !item.m_32063_() && item.m_6084_() && item.m_32055_().m_41614_();
    private int collideWithItemTicks = 0;
    private ItemEntity collidedItem = null;

    public EntityEelBase(EntityType<? extends EntityEelBase> entityType, Level worldIn) {
        super((EntityType<? extends EntityWaterMobPathingWithTypesBucketable>)entityType, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.8, false){

            public boolean m_8045_() {
                if (EntityEelBase.this.shouldCheckTarget() && EntityEelBase.this.m_5448_() != null && !EntityEelBase.isHoldingFood(EntityEelBase.this.m_5448_())) {
                    EntityEelBase.this.m_6710_(null);
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MoveToFoodItemsGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.25, 1));
        this.f_21346_.m_25352_(1, new PeacefulNearestAttackableTargetGoal<Player>((Mob)this, Player.class, 0, true, true, EntityEelBase::isHoldingFood));
    }

    protected boolean shouldCheckTarget() {
        return true;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public void m_8119_() {
        super.m_8119_();
        List items = this.f_19853_.m_6443_(ItemEntity.class, this.m_142469_().m_82400_(0.4), ITEM_SELECTOR);
        if (items.size() > 0 && (this.collidedItem == null || items.contains(this.collidedItem))) {
            if (this.collidedItem == null) {
                this.collidedItem = (ItemEntity)items.get(this.m_21187_().nextInt(items.size()));
            }
            ++this.collideWithItemTicks;
            if (this.collideWithItemTicks > 35) {
                if (this.m_21187_().nextFloat() < 0.1f) {
                    this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
                if (this.collideWithItemTicks > 40 && this.m_21187_().nextInt(20) == 0) {
                    this.collideWithItemTicks = 0;
                    ItemEntity item = this.collidedItem;
                    ItemStack stack = item.m_32055_();
                    if (stack.m_41614_()) {
                        this.m_5634_(stack.m_41720_().m_41473_().m_38745_());
                        item.m_146870_();
                        this.collidedItem = null;
                        this.collideWithItemTicks = 0;
                    }
                }
            }
        } else {
            this.collideWithItemTicks = 0;
            this.collidedItem = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack stack;
            if (this.collidedItem != null && !(stack = this.collidedItem.m_32055_()).m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3d = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        return entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
    }

    protected static boolean isHoldingFood(LivingEntity entity) {
        return entity.m_21205_().m_41614_() || entity.m_21206_().m_41614_();
    }

    public class MoveToFoodItemsGoal
    extends Goal {
        public MoveToFoodItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (EntityEelBase.this.m_5448_() == null && EntityEelBase.this.m_142581_() == null) {
                if (EntityEelBase.this.m_21187_().nextInt(2) != 0) {
                    return false;
                }
                List list = EntityEelBase.this.f_19853_.m_6443_(ItemEntity.class, EntityEelBase.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ITEM_SELECTOR);
                return !list.isEmpty();
            }
            return false;
        }

        public void m_8037_() {
            List list = EntityEelBase.this.f_19853_.m_6443_(ItemEntity.class, EntityEelBase.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityEelBase.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = EntityEelBase.this.f_19853_.m_6443_(ItemEntity.class, EntityEelBase.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityEelBase.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

