/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.UsernameCache;

public class PlayerRenderer {
    private static final Map<UUID, GameProfile> PLAYER_PROFILE_MAP = new HashMap<UUID, GameProfile>();
    private static final HashSet<UUID> FETCH_QUEUE = new HashSet();

    public static void renderPlayerHead(UUID player, PoseStack poseStack, int x, int y, int width, int height) {
        ScreenUtils.bindTexture((ResourceLocation)PlayerRenderer.getPlayerSkin(player));
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)x, (float)y, (float)width, (float)height, (float)0.125f, (float)0.125f, (float)0.125f, (float)0.125f);
    }

    public static String getPlayerUsername(UUID player) {
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        return profile == null ? UsernameCache.getLastKnownUsername((UUID)player) : profile.getName();
    }

    public static ResourceLocation getPlayerSkin(UUID player) {
        SkinManager skinManager;
        Map map;
        GameProfile profile = PlayerRenderer.fetchPlayerProfile(player);
        if (profile != null && (map = (skinManager = ClientUtils.getMinecraft().m_91109_()).m_118815_(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return skinManager.m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        return DefaultPlayerSkin.m_118627_((UUID)player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GameProfile fetchPlayerProfile(UUID player) {
        Object object = PLAYER_PROFILE_MAP;
        synchronized (object) {
            GameProfile profile = PLAYER_PROFILE_MAP.get(player);
            if (profile != null) {
                return profile;
            }
        }
        object = FETCH_QUEUE;
        synchronized (object) {
            if (!FETCH_QUEUE.contains(player)) {
                FETCH_QUEUE.add(player);
                new Thread(() -> {
                    GameProfile profile;
                    boolean success = false;
                    String name = PlayerRenderer.fetchPlayerName(player);
                    if (name != null && (profile = PlayerRenderer.updateGameProfile(new GameProfile(player, name))) != null) {
                        Map<UUID, GameProfile> map = PLAYER_PROFILE_MAP;
                        synchronized (map) {
                            PLAYER_PROFILE_MAP.put(player, profile);
                        }
                        success = true;
                    }
                    if (!success) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    HashSet<UUID> hashSet = FETCH_QUEUE;
                    synchronized (hashSet) {
                        FETCH_QUEUE.remove(player);
                    }
                }, "Tesseract - UUID to username").start();
            }
        }
        return null;
    }

    @Nullable
    private static GameProfile updateGameProfile(@Nullable GameProfile input) {
        if (!(input == null || input.getName() == null || input.getName().isEmpty() || input.isComplete() && input.getProperties().containsKey((Object)"textures"))) {
            Optional optionalGameProfile;
            GameProfileCache profileCache = PlayerRenderer.getProfileCache();
            MinecraftSessionService sessionService = PlayerRenderer.getSessionService();
            if (profileCache != null && sessionService != null && (optionalGameProfile = profileCache.m_10996_(input.getName())).isPresent()) {
                GameProfile gameProfile = (GameProfile)optionalGameProfile.get();
                Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    gameProfile = sessionService.fillProfileProperties(gameProfile, true);
                }
                return gameProfile;
            }
        }
        return null;
    }

    private static String fetchPlayerName(UUID player) {
        try {
            String s;
            InputStream inputStream = new URL("https://api.mojang.com/user/profiles/" + player + "/names").openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                builder.append(s);
            }
            if (builder.length() > 0) {
                JsonArray array = GsonHelper.m_13864_((String)("{\"array\":" + builder + "}")).getAsJsonArray("array");
                String latestName = null;
                long changeDate = -1L;
                for (JsonElement element : array) {
                    long date = element.getAsJsonObject().has("changedToAt") ? element.getAsJsonObject().get("changedToAt").getAsLong() : 0L;
                    if (date <= changeDate) continue;
                    latestName = element.getAsJsonObject().get("name").getAsString();
                    changeDate = date;
                }
                if (latestName != null) {
                    return latestName;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static GameProfileCache getProfileCache() {
        return ClientUtils.getMinecraft().m_91092_().m_129927_();
    }

    private static MinecraftSessionService getSessionService() {
        return ClientUtils.getMinecraft().m_91108_();
    }
}

