/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.RegistryObject;

public class BottlingMachineRecipe
extends MultiblockRecipe {
    public static RecipeType<BottlingMachineRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<BottlingMachineRecipe>> SERIALIZER;
    public static final CachedRecipeList<BottlingMachineRecipe> RECIPES;
    public final IngredientWithSize[] inputs;
    public final FluidTagInput fluidInput;
    public final Lazy<NonNullList<ItemStack>> output = Lazy.of(() -> output.stream().map(Supplier::get).collect(Collectors.toCollection(NonNullList::m_122779_)));

    public BottlingMachineRecipe(ResourceLocation id, List<Lazy<ItemStack>> output, IngredientWithSize[] inputs, FluidTagInput fluidInput) {
        super(output.get(0), TYPE, id);
        this.inputs = inputs;
        this.fluidInput = fluidInput;
        this.setTimeAndEnergy(60, 480);
        this.setInputListWithSizes(Lists.newArrayList((Object[])this.inputs));
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.fluidInput});
        this.outputList = this.output;
    }

    public BottlingMachineRecipe(ResourceLocation id, List<Lazy<ItemStack>> output, IngredientWithSize input, FluidTagInput fluidInput) {
        this(id, output, new IngredientWithSize[]{input}, fluidInput);
    }

    protected IERecipeSerializer<BottlingMachineRecipe> getIESerializer() {
        return (IERecipeSerializer)((Object)SERIALIZER.get());
    }

    public boolean matches(ItemStack[] input, FluidStack fluid) {
        if (!this.fluidInput.test(fluid)) {
            return false;
        }
        HashMap<ItemStack, Integer> available = new HashMap<ItemStack, Integer>();
        for (ItemStack itemStack : input) {
            available.put(itemStack, itemStack.m_41613_());
        }
        for (IngredientWithSize ingredientWithSize : this.inputs) {
            int need = ingredientWithSize.getCount();
            for (ItemStack stack : input) {
                if (!ingredientWithSize.test(stack)) continue;
                int take = Math.min(need, (Integer)available.get(stack));
                available.put(stack, (Integer)available.get(stack) - (need -= take));
            }
            if (need <= 0) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getDisplayStacks(ItemStack[] input) {
        NonNullList list = NonNullList.m_122780_((int)this.inputs.length, (Object)ItemStack.f_41583_);
        block0: for (int i = 0; i < this.inputs.length; ++i) {
            for (ItemStack stack : input) {
                if (!this.inputs[i].test(stack)) continue;
                list.set(i, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)this.inputs[i].getCount()));
                continue block0;
            }
        }
        return list;
    }

    public static BottlingMachineRecipe findRecipe(Level level, ItemStack[] input, FluidStack fluid) {
        if (fluid.isEmpty()) {
            return null;
        }
        for (BottlingMachineRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.matches(input, fluid)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList<BottlingMachineRecipe>(() -> TYPE, BottlingMachineRecipe.class);
    }
}

