/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.client.manual.ManualElementIECrafting;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class ManualElementBottling
extends ManualElementIECrafting {
    public ManualElementBottling(ManualInstance manual, ItemStack ... stacks) {
        super(manual, stacks);
        this.recalculateCraftingRecipes();
    }

    @Override
    public void recalculateCraftingRecipes() {
        this.recipes.clear();
        for (BottlingMachineRecipe recipe : BottlingMachineRecipe.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_)) {
            for (int iStack = 0; iStack < this.stacks.length; ++iStack) {
                ItemStack output = this.stacks[iStack];
                if (((NonNullList)recipe.output.get()).isEmpty() || !((NonNullList)recipe.output.get()).stream().anyMatch(itemStack -> ManualUtils.stackMatchesObject(output, itemStack))) continue;
                int h = (int)Math.ceil((float)((NonNullList)recipe.output.get()).size() / 2.0f);
                int middle = (int)((float)h / 2.0f * 18.0f);
                FluidStack fs = recipe.fluidInput.getRandomizedExampleStack(0);
                ItemStack bucket = fs.getFluid().m_6859_().m_7968_();
                if (fs.hasTag()) {
                    bucket.m_41751_(fs.getTag());
                }
                String bucketFraction = FluidUtils.getBucketFraction(recipe.fluidInput.getAmount());
                int inputSize = recipe.inputs.length;
                int outputSize = ((NonNullList)recipe.output.get()).size();
                PositionedItemStack[] pIngredients = new PositionedItemStack[inputSize + outputSize + 1];
                int idx = 0;
                for (int i = 0; i < inputSize; ++i) {
                    pIngredients[idx++] = new PositionedItemStack(recipe.inputs[i].getMatchingStacks(), 20 - i % 2 * 18, 8 + i / 2 * 18);
                }
                pIngredients[idx++] = new PositionedItemStack(bucket, 46, middle - 8, bucketFraction);
                List outputs = (List)recipe.output.get();
                for (int i = 0; i < outputs.size(); ++i) {
                    int j = i + 2;
                    pIngredients[idx++] = new PositionedItemStack((ItemStack)outputs.get(i), 70 + j % 2 * 18, -10 + j / 2 * 18);
                }
                this.recipes.add(pIngredients);
                this.arrowPositions.add(new ManualElementIECrafting.ArrowPosition(46, h * 18 + 1));
                if (h * 18 <= this.yOff) continue;
                this.yOff = h * 18 + 14;
            }
        }
        this.providedItems.clear();
        for (ItemStack stack : this.stacks) {
            this.addProvidedItem(stack);
        }
    }
}

