/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.common.blocks.plant.EnumHempGrowth;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ClocheRenderFunctions {
    public static void init() {
        ClocheRecipe.registerSoilTexture(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42329_), new ItemStack((ItemLike)Items.f_42382_), new ItemStack((ItemLike)Items.f_42276_), new ItemStack((ItemLike)Items.f_151032_)}), new ResourceLocation("block/farmland_moist"));
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("crop", RenderFunctionCrop::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("stacking", RenderFunctionStacking::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("stem", RenderFunctionStem::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("generic", RenderFunctionGeneric::new);
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("hemp", block -> new RenderFunctionHemp());
        ClocheRenderFunction.RENDER_FUNCTION_FACTORIES.put("chorus", block -> new RenderFunctionChorus());
    }

    public static class RenderFunctionChorus
    implements ClocheRenderFunction {
        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.5f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            Transformation bottom = new Transformation(new Vector3f(0.0f, (growth *= 2.0f) - 2.0f, 0.0f), null, null, null);
            Transformation middle = new Transformation(new Vector3f(0.0f, growth - 1.0f, 0.0f), null, null, null);
            Transformation top = new Transformation(new Vector3f(0.0f, growth, 0.0f), null, null, null);
            BlockState stem = (BlockState)((BlockState)Blocks.f_50490_.m_49966_().m_61124_((Property)ChorusPlantBlock.f_55153_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ChorusPlantBlock.f_55152_, (Comparable)Boolean.valueOf(true));
            return ImmutableList.of((Object)Pair.of((Object)stem, (Object)bottom), (Object)Pair.of((Object)stem, (Object)middle), (Object)Pair.of((Object)Blocks.f_50491_.m_49966_(), (Object)top));
        }
    }

    public static class RenderFunctionHemp
    implements ClocheRenderFunction {
        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.6875f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            int age = Math.min(4, Math.round(growth * 4.0f));
            if (age == 4) {
                Transformation top = new Transformation(new Vector3f(0.0f, 1.0f, 0.0f), null, null, null);
                return ImmutableList.of((Object)Pair.of((Object)((BlockState)IEBlocks.Misc.HEMP_PLANT.defaultBlockState().m_61124_(HempBlock.GROWTH, (Comparable)((Object)EnumHempGrowth.BOTTOM4))), (Object)new Transformation(null)), (Object)Pair.of((Object)((BlockState)IEBlocks.Misc.HEMP_PLANT.defaultBlockState().m_61124_(HempBlock.GROWTH, (Comparable)((Object)EnumHempGrowth.TOP0))), (Object)top));
            }
            return ImmutableList.of((Object)Pair.of((Object)((BlockState)IEBlocks.Misc.HEMP_PLANT.defaultBlockState().m_61124_(HempBlock.GROWTH, (Comparable)((Object)EnumHempGrowth.values()[age]))), (Object)new Transformation(null)));
        }
    }

    public static class RenderFunctionGeneric
    implements ClocheRenderFunction {
        final Block cropBlock;

        public RenderFunctionGeneric(Block cropBlock) {
            this.cropBlock = cropBlock;
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.75f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            Vector3f transl = new Vector3f(0.5f - growth / 2.0f, 0.0f, 0.5f - growth / 2.0f);
            Vector3f scale = new Vector3f(growth, growth, growth);
            return ImmutableList.of((Object)Pair.of((Object)this.cropBlock.m_49966_(), (Object)new Transformation(transl, null, scale, null)));
        }
    }

    public static class RenderFunctionStem
    implements ClocheRenderFunction {
        final StemGrownBlock cropBlock;
        final StemBlock stemBlock;
        final AttachedStemBlock attachedStemBlock;

        public RenderFunctionStem(Block cropBlock) {
            Preconditions.checkArgument((boolean)(cropBlock instanceof StemGrownBlock));
            this.cropBlock = (StemGrownBlock)cropBlock;
            this.stemBlock = this.cropBlock.m_7161_();
            this.attachedStemBlock = this.cropBlock.m_7810_();
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 1.0f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            PoseStack transform = new PoseStack();
            transform.m_85837_(0.0, 0.0625, 0.25);
            if ((double)growth < 0.375) {
                int age = Math.round(7.0f * growth / 0.375f);
                return ImmutableList.of((Object)Pair.of((Object)((BlockState)this.stemBlock.m_49966_().m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(age))), (Object)new Transformation(transform.m_85850_().m_85861_())));
            }
            float scale = (growth - 0.375f) / 0.625f * 0.3125f;
            Transformation cropMatrix = new Transformation(new Vector3f(0.5f - scale / 2.0f, 0.5625f - scale, 0.25f - scale / 2.0f), null, new Vector3f(scale, scale, scale), null);
            return ImmutableList.of((Object)Pair.of((Object)this.attachedStemBlock.m_49966_(), (Object)new Transformation(transform.m_85850_().m_85861_())), (Object)Pair.of((Object)this.cropBlock.m_49966_(), (Object)cropMatrix));
        }
    }

    public static class RenderFunctionStacking
    implements ClocheRenderFunction {
        final Block cropBlock;

        public RenderFunctionStacking(Block cropBlock) {
            this.cropBlock = cropBlock;
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.6875f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            Transformation bottom = new Transformation(new Vector3f(0.0f, growth - 1.0f, 0.0f), null, null, null);
            Transformation top = new Transformation(new Vector3f(0.0f, growth, 0.0f), null, null, null);
            return ImmutableList.of((Object)Pair.of((Object)this.cropBlock.m_49966_(), (Object)bottom), (Object)Pair.of((Object)this.cropBlock.m_49966_(), (Object)top));
        }
    }

    public static class RenderFunctionCrop
    implements ClocheRenderFunction {
        final Block cropBlock;
        int maxAge;
        IntegerProperty ageProperty;

        public RenderFunctionCrop(Block cropBlock) {
            this.cropBlock = cropBlock;
            if (cropBlock instanceof CropBlock) {
                this.maxAge = ((CropBlock)cropBlock).m_7419_();
                this.ageProperty = ((CropBlock)cropBlock).m_7959_();
            } else {
                for (Property prop : cropBlock.m_49966_().m_61147_()) {
                    if (!"age".equals(prop.m_61708_()) || !(prop instanceof IntegerProperty)) continue;
                    int tmp = -1;
                    for (Integer allowed : ((IntegerProperty)prop).m_6908_()) {
                        if (allowed == null || allowed <= tmp) continue;
                        tmp = allowed;
                    }
                    if (tmp <= 0) continue;
                    this.maxAge = tmp;
                    this.ageProperty = (IntegerProperty)prop;
                    break;
                }
            }
            if (this.ageProperty == null || this.maxAge <= 0) {
                throw new IllegalArgumentException("Block " + cropBlock.m_7705_() + " is not a valid crop block");
            }
        }

        @Override
        public float getScale(ItemStack seed, float growth) {
            return 0.875f;
        }

        @Override
        public Collection<Pair<BlockState, Transformation>> getBlocks(ItemStack stack, float growth) {
            int age = Math.min(this.maxAge, Math.round((float)this.maxAge * growth));
            return ImmutableList.of((Object)Pair.of((Object)((BlockState)this.cropBlock.m_49966_().m_61124_((Property)this.ageProperty, (Comparable)Integer.valueOf(age))), (Object)new Transformation(null)));
        }
    }
}

