/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.SpawnInterdictionHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElectricLanternBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.ISpawnInterdiction,
IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IActiveState,
EnergyTransferHandler.EnergyConnector {
    public int energyStorage = 0;
    private final int energyDraw;
    private final int maximumStorage;

    public ElectricLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.ELECTRIC_LANTERN.get(), pos, state);
        this.energyDraw = (Integer)IEServerConfig.MACHINES.lantern_energyDraw.get();
        this.maximumStorage = (Integer)IEServerConfig.MACHINES.lantern_maximumStorage.get();
    }

    @Override
    public void tickServer() {
        boolean activeBeforeTick = this.getIsActive();
        if (this.energyStorage >= this.energyDraw) {
            this.energyStorage -= this.energyDraw;
            if (!activeBeforeTick) {
                this.setActive(true);
            }
        } else if (activeBeforeTick) {
            this.setActive(false);
        }
        if (this.getIsActive() != activeBeforeTick) {
            this.checkLight();
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.getIsActive() ? 1024.0 : 0.0;
    }

    @Override
    public void setRemovedIE() {
        SpawnInterdictionHandler.removeFromInterdictionTiles(this);
        super.setRemovedIE();
    }

    @Override
    public void onChunkUnloaded() {
        SpawnInterdictionHandler.removeFromInterdictionTiles(this);
        super.onChunkUnloaded();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        SpawnInterdictionHandler.addInterdictionTile(this);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage = nbt.m_128451_("energyStorage");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128405_("energyStorage", this.energyStorage);
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 1) {
            this.markContainingBlockForUpdate(null);
            this.checkLight();
            return true;
        }
        return super.m_7531_(id, arg);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "LV".equals(cableType.getCategory());
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        boolean flipped;
        BlockPos otherPos = other.position();
        int xDif = otherPos.m_123341_() - this.f_58858_.m_123341_();
        int zDif = otherPos.m_123343_() - this.f_58858_.m_123343_();
        boolean bl = flipped = this.getFacing() == Direction.UP;
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return new Vec3(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5), flipped ? 0.9375 : 0.0625, 0.5);
        }
        return new Vec3(0.5, flipped ? 0.9375 : 0.0625, zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5));
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_TOP_DOWN;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.FIXED_DOWN;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.f_58857_.f_46443_) {
            this.setFacing(this.getFacing().m_122424_());
        }
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            for (Connection c : this.getLocalNet(cp.index()).getConnections(cp)) {
                if (c.isInternal()) continue;
                this.globalNet.updateCatenaryData(c);
            }
        }
        this.m_6596_();
        this.markContainingBlockForUpdate(this.m_58900_());
        return true;
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return true;
    }

    @Override
    public int getRequestedEnergy() {
        return this.maximumStorage - this.energyStorage;
    }

    @Override
    public void insertEnergy(int amount) {
        this.energyStorage += amount;
    }
}

