/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.energy.WindmillBiome;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.NonNullSupplier;

public class WindmillBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IReadOnPlacement,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockBounds {
    public float rotation = 0.0f;
    public float turnSpeed = 0.0f;
    public int sails = 0;
    private final CapabilityReference<IRotationAcceptor> outputCap = CapabilityReference.forNeighbor((BlockEntity)this, IRotationAcceptor.CAPABILITY, (NonNullSupplier<Direction>)((NonNullSupplier)() -> this.getFacing().m_122424_()));
    private final BiFunction<Level, Holder<Biome>, Float> biomeModifier = CachedRecipe.cached(WindmillBiome::getBiome).andThen(mod -> Float.valueOf(mod == null ? 1.0f : mod.getModifier()));
    private AABB renderAABB;
    private static final CachedVoxelShapes<Direction> SHAPES = new CachedVoxelShapes<Direction>(WindmillBlockEntity::getShape);

    public WindmillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.WINDMILL.get(), pos, state);
    }

    @Override
    public void tickClient() {
        this.rotation = (float)((double)this.rotation + this.getActualTurnSpeed());
        this.rotation %= 1.0f;
    }

    public double getActualTurnSpeed() {
        if (this.turnSpeed == 0.0f) {
            return 0.0;
        }
        double mod = 5.0E-5;
        if (!this.f_58857_.m_46471_()) {
            mod *= 0.75;
        }
        if (!this.f_58857_.m_46470_()) {
            mod *= 0.66;
        }
        mod *= (double)this.biomeModifier.apply(this.f_58857_, (Holder<Biome>)this.f_58857_.m_204166_(this.m_58899_())).floatValue();
        return (mod *= (double)this.getSpeedModifier()) * (double)this.turnSpeed;
    }

    @Override
    public void tickServer() {
        this.tickClient();
        if (this.f_58857_.m_46467_() % 128L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x7F)) {
            float oldTurnSpeed = this.turnSpeed;
            this.turnSpeed = this.computeTurnSpeed();
            if (oldTurnSpeed != this.turnSpeed) {
                this.markContainingBlockForUpdate(null);
            }
        }
        if (this.turnSpeed == 0.0f) {
            return;
        }
        IRotationAcceptor dynamo = this.outputCap.getNullable();
        if (dynamo != null) {
            double power = this.getActualTurnSpeed() * 800.0;
            dynamo.inputRotation(Math.abs(power));
        }
    }

    protected float getSpeedModifier() {
        return 0.5f + (float)this.sails * 0.125f;
    }

    public float computeTurnSpeed() {
        Direction facing = this.getFacing();
        if (facing.m_122434_() == Direction.Axis.Y) {
            return 0.0f;
        }
        float turnSpeed = 0.0f;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                if (hh == 0 && ww == 0 || this.f_58857_.m_46859_(this.m_58899_().m_5484_(facing.m_122427_(), ww).m_6630_(hh))) continue;
                return 0.0f;
            }
        }
        int blocked = 0;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                for (int dd = 1; dd < 8; ++dd) {
                    BlockPos pos = this.m_58899_().m_6630_(hh).m_5484_(facing, dd).m_5484_(facing.m_122427_(), ww);
                    if (!this.f_58857_.isAreaLoaded(pos, 1) || this.f_58857_.m_46859_(pos)) {
                        turnSpeed += 1.0f;
                        continue;
                    }
                    if (this.f_58857_.m_7702_(pos) instanceof WindmillBlockEntity) {
                        blocked += 20;
                        turnSpeed -= 179.0f;
                        continue;
                    }
                    ++blocked;
                }
            }
            if (blocked <= 100) continue;
            return 0.0f;
        }
        return turnSpeed;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.sails = nbt.m_128451_("sails");
        this.rotation = nbt.m_128457_("rotation");
        this.turnSpeed = nbt.m_128457_("turnSpeed");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128405_("sails", this.sails);
        nbt.m_128350_("rotation", this.rotation);
        nbt.m_128350_("turnSpeed", this.turnSpeed);
    }

    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            Direction facing = this.getFacing();
            this.renderAABB = new AABB((double)(this.m_58899_().m_123341_() - (facing.m_122434_() == Direction.Axis.Z ? 6 : 0)), (double)(this.m_58899_().m_123342_() - 6), (double)(this.m_58899_().m_123343_() - (facing.m_122434_() == Direction.Axis.Z ? 0 : 6)), (double)(this.m_58899_().m_123341_() + (facing.m_122434_() == Direction.Axis.Z ? 7 : 0)), (double)(this.m_58899_().m_123342_() + 7), (double)(this.m_58899_().m_123343_() + (facing.m_122434_() == Direction.Axis.Z ? 0 : 7)));
        }
        return this.renderAABB;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.sails < 8 && heldItem.m_41720_() == IEItems.Ingredients.WINDMILL_SAIL.m_5456_()) {
            ++this.sails;
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            this.m_6596_();
            return true;
        }
        return false;
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "sails")) {
            this.sails = ItemNBTHelper.getInt(stack, "sails");
        }
    }

    private static List<AABB> getShape(Direction key) {
        return Lists.newArrayList((Object[])new AABB[]{key.m_122434_() == Direction.Axis.Z ? new AABB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 1.0) : new AABB(0.0, 0.0625, 0.0625, 1.0, 0.9375, 0.9375)});
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.getFacing());
    }
}

