/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TeleportPos {
    public final ResourceKey<Level> dimension;
    public final BlockPos pos;
    public long time;

    public TeleportPos(ResourceKey<Level> d, BlockPos p) {
        this.dimension = d;
        this.pos = p;
        this.time = System.currentTimeMillis();
    }

    public TeleportPos(Level world, BlockPos p) {
        this((ResourceKey<Level>)world.m_46472_(), p);
    }

    public TeleportPos(Entity entity) {
        this(entity.f_19853_, entity.m_142538_());
    }

    public TeleportPos(CompoundTag tag) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim")));
        this.pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
        this.time = tag.m_128454_("time");
    }

    public TeleportResult teleport(ServerPlayer player) {
        ServerLevel world = player.f_8924_.m_129880_(this.dimension);
        if (world == null) {
            return TeleportResult.DIMENSION_NOT_FOUND;
        }
        int lvl = player.f_36078_;
        player.m_8999_(world, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.1, (double)this.pos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        player.m_9174_(lvl);
        return TeleportResult.SUCCESS;
    }

    public SNBTCompoundTag write() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.singleLine();
        tag.m_128359_("dim", this.dimension.m_135782_().toString());
        tag.m_128405_("x", this.pos.m_123341_());
        tag.m_128405_("y", this.pos.m_123342_());
        tag.m_128405_("z", this.pos.m_123343_());
        tag.m_128356_("time", this.time);
        return tag;
    }

    public String distanceString(TeleportPos origin) {
        if (origin.dimension == this.dimension) {
            double dx = this.pos.m_123341_() - origin.pos.m_123341_();
            double dz = this.pos.m_123343_() - origin.pos.m_123343_();
            return (int)Math.sqrt(dx * dx + dz * dz) + "m";
        }
        ResourceLocation s = this.dimension.m_135782_();
        if (s.m_135827_().equals("minecraft")) {
            return switch (s.m_135815_()) {
                case "overworld" -> "Overworld";
                case "the_nether" -> "The Nether";
                case "the_end" -> "The End";
                default -> s.m_135815_();
            };
        }
        return s.m_135815_() + " [" + s.m_135827_() + "]";
    }

    @FunctionalInterface
    public static interface TeleportResult {
        public static final TeleportResult SUCCESS = new TeleportResult(){

            @Override
            public int runCommand(ServerPlayer player) {
                return 1;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }
        };
        public static final TeleportResult DIMENSION_NOT_FOUND = player -> {
            player.m_5661_((Component)new TextComponent("Dimension not found!"), false);
            return 0;
        };

        public int runCommand(ServerPlayer var1);

        default public boolean isSuccess() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface CooldownTeleportResult
    extends TeleportResult {
        public long getCooldown();

        @Override
        default public int runCommand(ServerPlayer player) {
            player.m_5661_((Component)new TextComponent("Can't teleport yet! Cooldown: " + TimeUtils.prettyTimeString((long)(this.getCooldown() / 1000L))), false);
            return 0;
        }
    }
}

