/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.condition;

import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

class ResourceConditions {
    private static final Map<ResourceConditionSerializer<?>, IConditionSerializer<?>> TO_UNDERLYING_MAP = new HashMap();

    ResourceConditions() {
    }

    static ConditionWrapper wrap(ResourceCondition condition) {
        return new ConditionWrapper(condition);
    }

    static IConditionSerializer<?> wrap(ResourceLocation identifier, ResourceConditionSerializer<?> serializer) {
        ConditionSerializerWrapper forgeSerializer = new ConditionSerializerWrapper(identifier, serializer);
        TO_UNDERLYING_MAP.put(serializer, forgeSerializer);
        return forgeSerializer;
    }

    private static class ConditionWrapper
    implements ICondition {
        private final ResourceCondition condition;

        ConditionWrapper(ResourceCondition condition) {
            this.condition = condition;
        }

        public ResourceLocation getID() {
            return TO_UNDERLYING_MAP.get(this.condition.getSerializer()).getID();
        }

        public boolean test() {
            return this.test(ICondition.IContext.EMPTY);
        }

        public boolean test(ICondition.IContext context) {
            return this.condition.test(new ResourceConditionContext(context));
        }
    }

    private static class ConditionSerializerWrapper
    implements IConditionSerializer<ConditionWrapper> {
        private final ResourceLocation identifier;
        private final ResourceConditionSerializer<ResourceCondition> serializer;

        private ConditionSerializerWrapper(ResourceLocation identifier, ResourceConditionSerializer<?> serializer) {
            this.identifier = identifier;
            this.serializer = serializer;
        }

        public void write(JsonObject json, ConditionWrapper value) {
            this.serializer.serialize(json, value.condition);
        }

        public ConditionWrapper read(JsonObject json) {
            return ResourceConditions.wrap(this.serializer.deserialize(json));
        }

        public ResourceLocation getID() {
            return this.identifier;
        }
    }
}

