/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

public abstract class ResourceCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public abstract boolean doesResourceExist(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void trackToBeGeneratedResource(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void saveResource(ResourceType var1, byte[] var2, String var3, String var4, String var5, String var6);

    public void saveJsonResource(ResourceType resourceType, JsonObject json, String namespace, String directory, String fileName) {
        byte[] bytes = GSON.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8);
        this.saveResource(resourceType, bytes, namespace, directory, fileName, fileName.endsWith(".json") ? "" : ".json");
    }

    public abstract Optional<InputStream> getManualResource(ResourceType var1, String var2, String var3, String var4, String var5);

    @ApiStatus.Internal
    static ResourceCache wrap(ExistingFileHelper existingFileHelper, HashCache cachedOutput, Path outputDirectory) {
        return new ExistingFileHelperWrapper(existingFileHelper, cachedOutput, outputDirectory);
    }

    private static class ExistingFileHelperWrapper
    extends ResourceCache {
        private final Map<Path, HashCode> writtenFiles = new HashMap<Path, HashCode>();
        private final ExistingFileHelper existingFileHelper;
        private final Path outputDirectory;
        private final HashCache cache;

        private ExistingFileHelperWrapper(ExistingFileHelper existingFileHelper, HashCache hashCache, Path outputFolder) {
            if (outputFolder == null) {
                throw new IllegalArgumentException("Output directory must not be null!");
            }
            this.outputDirectory = outputFolder;
            this.existingFileHelper = existingFileHelper;
            this.cache = hashCache;
        }

        @Override
        public boolean doesResourceExist(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            ResourceLocation location = new ResourceLocation(namespace, directory + "/" + fileName + extension);
            return this.existingFileHelper.exists(location, resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES);
        }

        @Override
        public void trackToBeGeneratedResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            ResourceLocation location = new ResourceLocation(namespace, fileName);
            this.existingFileHelper.trackGenerated(location, resourceType == ResourceType.DATA ? PackType.SERVER_DATA : PackType.CLIENT_RESOURCES, extension, directory);
        }

        @Override
        public Optional<InputStream> getManualResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            Path fullPath = this.outputDirectory.resolve(path);
            if (!Files.exists(fullPath, new LinkOption[0])) {
                return Optional.empty();
            }
            try {
                return Optional.of(Files.newInputStream(fullPath, new OpenOption[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Path constructPath(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            return Paths.get(resourceType.getDirectoryName(), namespace, directory, fileName + extension);
        }

        @Override
        public void saveResource(ResourceType resourceType, byte[] data, String namespace, String directory, String fileName, String extension) {
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            Path fullPath = this.outputDirectory.resolve(path);
            if (this.writtenFiles.containsKey(path) || this.cache.f_123931_.containsKey(fullPath)) {
                throw new RuntimeException("Duplicate file '" + path + "'!");
            }
            HashCode hashCode = Hashing.sha1().hashBytes(data);
            if (hashCode.toString().equals(this.cache.m_123938_(fullPath)) && fullPath.toFile().exists()) {
                this.writtenFiles.put(path, hashCode);
                this.cache.m_123940_(fullPath, hashCode.toString());
                return;
            }
            fullPath.getParent().toFile().mkdirs();
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                outputStream.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.writtenFiles.put(path, hashCode);
            this.cache.m_123940_(fullPath, hashCode.toString());
        }
    }
}

