/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.item.EditableClientItemExtensions;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.TriFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientRegistrationHandler {
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP = new HashMap<String, ClientRegistrationHandler>();
    private final String modid;
    private final Set<ResourceLocation> models = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, Supplier<BakedModel>> specialModels = new HashMap<ResourceLocation, Supplier<BakedModel>>();
    private final List<Pair<Predicate<ResourceLocation>, Function<BakedModel, BakedModel>>> modelOverwrites = new ArrayList<Pair<Predicate<ResourceLocation>, Function<BakedModel, BakedModel>>>();
    private final List<Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?>>>> entityRenderers = new ArrayList();
    private final List<Pair<Supplier<BlockEntityType<?>>, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<?>>>> blockEntityRenderers = new ArrayList();
    private final Map<ResourceLocation, Set<ResourceLocation>> textureAtlasSprites = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    private final List<Pair<Supplier<Item>, Supplier<BlockEntityWithoutLevelRenderer>>> customItemRenderers = new ArrayList<Pair<Supplier<Item>, Supplier<BlockEntityWithoutLevelRenderer>>>();
    private final List<Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<Block>, Supplier<RenderType>>> blockRenderTypes = new ArrayList<Pair<Supplier<Block>, Supplier<RenderType>>>();
    private boolean passedModelRegistry;
    private boolean passedModelBake;
    private boolean passedRegisterRenderers;
    private boolean passedTextureStitch;

    public static synchronized ClientRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleModelRegistryEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleModelBakeEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleRegisterRenderersEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleTextureStitchEvent);
    }

    public void registerModel(ResourceLocation identifier) {
        if (this.passedModelRegistry) {
            throw new IllegalStateException("Cannot register new models after ModelRegistryEvent has been fired!");
        }
        if (this.models.contains(identifier)) {
            throw new RuntimeException("Duplicate model location '" + identifier + "'!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model location '" + identifier + "'!");
        }
        this.models.add(identifier);
    }

    public void registerModel(String namespace, String identifier) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerModel(new ResourceLocation(namespace, identifier));
    }

    public void registerModel(String identifier) {
        this.registerModel(this.modid, identifier);
    }

    public void registerSpecialModel(String identifier, Supplier<BakedModel> model) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new special models after ModelBakeEvent has been fired!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(this.modid, identifier);
        if (this.specialModels.containsKey(fullIdentifier)) {
            throw new RuntimeException("Duplicate special model entry '" + fullIdentifier + "'!");
        }
        this.specialModels.put(fullIdentifier, model);
    }

    public void registerSpecialModel(String identifier, BakedModel model) {
        this.registerSpecialModel(identifier, () -> model);
    }

    public void registerModelOverwrite(ResourceLocation identifier, Function<BakedModel, BakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model overwrite '" + identifier + "'!");
        }
        this.modelOverwrites.add(Pair.of(arg_0 -> ((ResourceLocation)identifier).equals(arg_0), modelOverwrite));
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Function<BakedModel, BakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        if (!RegistryUtil.isValidPath(variant)) {
            throw new IllegalArgumentException("Variant '" + variant + "' must only contain characters [a-z0-9_./-]!");
        }
        ModelResourceLocation fullIdentifier = new ModelResourceLocation(namespace, identifier, variant);
        this.registerModelOverwrite((ResourceLocation)fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, Function<BakedModel, BakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
        this.registerModelOverwrite(fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Supplier<BakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, Supplier<BakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, BakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (BakedModel model) -> modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, BakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (BakedModel model) -> modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Function<BakedModel, BakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(identifier -> {
            ResourceLocation blockIdentifier = Registries.BLOCKS.getIdentifier((Block)block.get());
            return identifier instanceof ModelResourceLocation && identifier.m_135827_().equals(blockIdentifier.m_135827_()) && identifier.m_135815_().equals(blockIdentifier.m_135815_());
        }, modelOverwrite));
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Supplier<BakedModel> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, BakedModel modelOverwrite) {
        this.registerBlockModelOverwrite(block, (BakedModel model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Function<BakedModel, BakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(identifier -> {
            ResourceLocation itemIdentifier = Registries.ITEMS.getIdentifier((Item)item.get());
            return identifier.m_135827_().equals(itemIdentifier.m_135827_()) && (identifier instanceof ModelResourceLocation ? identifier.m_135815_().equals(itemIdentifier.m_135815_()) && ((ModelResourceLocation)identifier).m_119448_().equals("inventory") : identifier.m_135815_().equals("item/" + itemIdentifier.m_135815_()));
        }, modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Supplier<BakedModel> modelOverwrite) {
        this.registerItemModelOverwrite(item, (BakedModel model) -> (BakedModel)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<Item> item, BakedModel modelOverwrite) {
        this.registerItemModelOverwrite(item, (BakedModel model) -> modelOverwrite);
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Function<EntityRendererProvider.Context, EntityRenderer<? super T>> entityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.entityRenderers.add(Pair.of(entityType, entityRenderer));
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Supplier<EntityRenderer<? super T>> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> (EntityRenderer)entityRenderer.get());
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, EntityRenderer<? super T> entityRenderer) {
        this.registerEntityRenderer(entityType, (EntityRendererProvider.Context context) -> entityRenderer);
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Function<BlockEntityRendererProvider.Context, BlockEntityRenderer<? super T>> blockEntityRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<BlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> (BlockEntityRenderer)blockEntityRenderer.get());
    }

    public <T extends BlockEntity> void registerBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, BlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> blockEntityRenderer);
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends BlockEntity> void registerCustomBlockEntityRenderer(Supplier<BlockEntityType<T>> entityType, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (BlockEntityRendererProvider.Context context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, String spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after TextureStitchEvent has been fired!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullSpriteLocation = new ResourceLocation(this.modid, spriteLocation);
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(fullSpriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + fullSpriteLocation + "' for atlas '" + textureAtlas + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(fullSpriteLocation);
    }

    public void registerItemRenderer(Supplier<Item> item, Supplier<BlockEntityWithoutLevelRenderer> itemRenderer) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new renderers after item RegistryEvent has been fired!");
        }
        this.customItemRenderers.add(Pair.of(item, itemRenderer));
    }

    public void registerItemRenderer(Supplier<Item> item, BlockEntityWithoutLevelRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> itemRenderer);
    }

    public void registerItemRenderer(Item item, Supplier<BlockEntityWithoutLevelRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, itemRenderer);
    }

    public void registerItemRenderer(Item item, BlockEntityWithoutLevelRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> itemRenderer);
    }

    public void registerCustomItemRenderer(Supplier<Item> item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Supplier<Item> item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public void registerCustomItemRenderer(Item item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Item item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(Supplier<MenuType<T>> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, TriFunction<T, Inventory, Component, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public <T extends AbstractContainerMenu, U extends Screen> void registerContainerScreen(MenuType<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, (T container, Inventory inventory, Component title) -> (Screen)screenSupplier.apply(container));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, Supplier<RenderType> renderTypeSupplier) {
        if (this.passedRegisterRenderers) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderTypeSupplier));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, RenderType renderType) {
        this.registerBlockModelRenderType(block, renderType);
    }

    public void registerBlockModelRenderType(Block block, Supplier<RenderType> renderTypeSupplier) {
        this.registerBlockModelRenderType(() -> block, renderTypeSupplier);
    }

    public void registerBlockModelSolidRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::m_110451_);
    }

    public void registerBlockModelSolidRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::m_110451_);
    }

    public void registerBlockModelCutoutMippedRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::m_110457_);
    }

    public void registerBlockModelCutoutMippedRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::m_110457_);
    }

    public void registerBlockModelCutoutRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::m_110463_);
    }

    public void registerBlockModelCutoutRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::m_110463_);
    }

    public void registerBlockModelTranslucentRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::m_110466_);
    }

    public void registerBlockModelTranslucentRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::m_110466_);
    }

    private void handleModelRegistryEvent(ModelRegistryEvent e) {
        this.passedModelRegistry = true;
        for (ResourceLocation model : this.models) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)model);
        }
    }

    private void handleModelBakeEvent(ModelBakeEvent e) {
        this.passedModelBake = true;
        for (Map.Entry<ResourceLocation, Supplier<BakedModel>> entry : this.specialModels.entrySet()) {
            ResourceLocation identifier2 = entry.getKey();
            if (e.getModelRegistry().containsKey(identifier2)) {
                throw new RuntimeException("Special model '" + identifier2 + "' is trying to overwrite another model!");
            }
            BakedModel model = entry.getValue().get();
            if (model == null) {
                throw new RuntimeException("Got null object for special model '" + entry.getKey() + "'!");
            }
            e.getModelRegistry().put(entry.getKey(), model);
        }
        for (Pair pair : this.modelOverwrites) {
            List modelIdentifiers = e.getModelRegistry().keySet().stream().filter(identifier -> ((Predicate)pair.left()).test(identifier)).collect(Collectors.toList());
            for (ResourceLocation identifier3 : modelIdentifiers) {
                if (!e.getModelRegistry().containsKey(identifier3)) {
                    throw new RuntimeException("No model registered for model overwrite '" + identifier3 + "'!");
                }
                BakedModel model = (BakedModel)e.getModelRegistry().get(identifier3);
                model = (BakedModel)((Function)pair.right()).apply(model);
                if (model == null) {
                    throw new RuntimeException("Model overwrite for '" + identifier3 + "' returned a null model!");
                }
                e.getModelRegistry().put(identifier3, model);
            }
        }
    }

    private void handleRegisterRenderersEvent(EntityRenderersEvent.RegisterRenderers e) {
        this.passedRegisterRenderers = true;
        HashSet entityTypes = new HashSet();
        for (Pair<Supplier<EntityType<?>>, Function<EntityRendererProvider.Context, EntityRenderer<?>>> entry : this.entityRenderers) {
            EntityType<?> entityType = entry.left().get();
            if (entityType == null) {
                throw new RuntimeException("Entity renderer registered with null entity type!");
            }
            if (entityTypes.contains(entityType)) {
                throw new RuntimeException("Duplicate entity renderer for entity type '" + Registries.ENTITY_TYPES.getIdentifier(entityType) + "'!");
            }
            entityTypes.add(entityType);
            e.registerEntityRenderer(entityType, ((Function)entry.right())::apply);
        }
        HashSet<BlockEntityType> blockEntityTypes = new HashSet<BlockEntityType>();
        for (Pair pair : this.blockEntityRenderers) {
            BlockEntityType blockEntityType = (BlockEntityType)((Supplier)pair.left()).get();
            if (blockEntityType == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(blockEntityType)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier(blockEntityType) + "'!");
            }
            blockEntityTypes.add(blockEntityType);
            e.registerBlockEntityRenderer(blockEntityType, ((Function)pair.right())::apply);
        }
        HashSet<Item> items = new HashSet<Item>();
        for (Pair<Supplier<Item>, Supplier<BlockEntityWithoutLevelRenderer>> pair : this.customItemRenderers) {
            Item item = pair.left().get();
            if (item == null) {
                throw new RuntimeException("Custom item renderer registered with null item!");
            }
            if (items.contains(item)) {
                throw new RuntimeException("Duplicate custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            Object renderProperties = item.getRenderPropertiesInternal();
            if (!(renderProperties instanceof EditableClientItemExtensions)) {
                throw new RuntimeException("Cannot register custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "' without EditableClientItemExtensions render properties!");
            }
            BlockEntityWithoutLevelRenderer customRenderer = pair.right().get();
            if (customRenderer == null) {
                throw new RuntimeException("Got null custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            items.add(item);
            ((EditableClientItemExtensions)renderProperties).setCustomRenderer(customRenderer);
        }
        HashSet hashSet = new HashSet();
        for (Pair<Supplier<MenuType<?>>, TriFunction<AbstractContainerMenu, Inventory, Component, Screen>> pair : this.containerScreens) {
            MenuType<?> menuType = pair.left().get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (hashSet.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + Registries.MENU_TYPES.getIdentifier(menuType) + "'!");
            }
            hashSet.add(menuType);
            MenuScreens.m_96206_(menuType, pair.right()::apply);
        }
        HashSet<Block> hashSet2 = new HashSet<Block>();
        for (Pair<Supplier<Block>, Supplier<RenderType>> entry : this.blockRenderTypes) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Block render type registered for null block!");
            }
            if (hashSet2.contains(block)) {
                throw new RuntimeException("Duplicate render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            RenderType renderType = entry.right().get();
            if (renderType == null) {
                throw new RuntimeException("Got null render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            hashSet2.add(block);
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
        }
    }

    private void handleTextureStitchEvent(TextureStitchEvent.Pre e) {
        this.passedTextureStitch = true;
        Set<ResourceLocation> sprites = this.textureAtlasSprites.get(e.getAtlas().m_118330_());
        if (sprites == null) {
            return;
        }
        sprites.forEach(arg_0 -> ((TextureStitchEvent.Pre)e).addSprite(arg_0));
    }
}

