/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;

public class DistillationTowerRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, DistillationTowerRecipe> recipes = new HashMap<ResourceLocation, DistillationTowerRecipe>();
    protected final FluidTagInput input;
    protected final FluidStack[] fluidOutput;
    protected final ItemStack[] itemOutput;
    protected final double[] chances;

    public static DistillationTowerRecipe findRecipe(FluidStack input) {
        if (!recipes.isEmpty()) {
            for (DistillationTowerRecipe r : recipes.values()) {
                if (r.input == null || !r.input.testIgnoringAmount(input)) continue;
                return r;
            }
        }
        return null;
    }

    public static DistillationTowerRecipe loadFromNBT(CompoundTag nbt) {
        FluidStack input = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("input"));
        return DistillationTowerRecipe.findRecipe(input);
    }

    public DistillationTowerRecipe(ResourceLocation id, FluidStack[] fluidOutput, ItemStack[] itemOutput, FluidTagInput input, int energy, int time, double[] chances) {
        super(ItemStack.f_41583_, (Supplier<? extends RecipeType<?>>)IPRecipeTypes.DISTILLATION, id);
        this.fluidOutput = fluidOutput;
        this.itemOutput = itemOutput;
        this.chances = chances;
        this.input = input;
        this.fluidInputList = Collections.singletonList(input);
        this.fluidOutputList = Arrays.asList(this.fluidOutput);
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])itemOutput));
        this.timeAndEnergy(time, energy);
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.distillationTower_timeModifier.get(), () -> IPServerConfig.REFINING.distillationTower_energyModifier.get());
    }

    protected IERecipeSerializer<DistillationTowerRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.DISTILLATION_SERIALIZER.get();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public NonNullList<ItemStack> getActualItemOutputs(BlockEntity tile) {
        NonNullList output = NonNullList.m_122779_();
        for (int i = 0; i < this.itemOutput.length; ++i) {
            Level level = tile.m_58904_();
            if (!((double)level.f_46441_.nextFloat() <= this.chances[i])) continue;
            output.add((Object)this.itemOutput[i]);
        }
        return output;
    }

    public FluidTagInput getInputFluid() {
        return this.input;
    }

    public double[] chances() {
        return this.chances;
    }
}

