/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class ReservoirBuilder
extends IEFinishedRecipe<ReservoirBuilder> {
    private String fluid;
    private int fluidMinimum;
    private int fluidMaximum;
    private int fluidTrace;
    private int weight;
    private boolean isDimBlacklist = false;
    private final JsonArray dimensions = new JsonArray();
    private boolean isBioBlacklist = false;
    private final JsonArray biomes = new JsonArray();

    private ReservoirBuilder() {
        super((IERecipeSerializer)Serializers.RESERVOIR_SERIALIZER.get());
        this.addWriter(writer -> {
            writer.addProperty("fluid", this.fluid);
            writer.addProperty("fluidminimum", (Number)this.fluidMinimum);
            writer.addProperty("fluidcapacity", (Number)this.fluidMaximum);
            writer.addProperty("fluidtrace", (Number)this.fluidTrace);
            writer.addProperty("weight", (Number)this.weight);
        });
        this.addWriter(writer -> {
            JsonObject dimensions = new JsonObject();
            dimensions.add("isBlacklist", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isDimBlacklist)));
            dimensions.add("list", (JsonElement)this.dimensions);
            writer.add("dimensions", (JsonElement)dimensions);
        });
        this.addWriter(writer -> {
            JsonObject biomes = new JsonObject();
            biomes.add("isBlacklist", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.isBioBlacklist)));
            biomes.add("list", (JsonElement)this.biomes);
            writer.add("biomes", (JsonElement)biomes);
        });
    }

    public static ReservoirBuilder builder(String name) {
        return (ReservoirBuilder)new ReservoirBuilder().addWriter(writer -> writer.addProperty("name", name));
    }

    public static ReservoirBuilder builder(String name, Fluid fluid, double min, double max, double trace, int weight) {
        return ReservoirBuilder.builder(name).setFluid(fluid).min(min).max(max).trace(trace).weight(weight);
    }

    public ReservoirBuilder setFluid(Fluid fluid) {
        this.fluid = fluid.getRegistryName().toString();
        return this;
    }

    public ReservoirBuilder min(double amount) {
        this.fluidMinimum = (int)Math.floor(amount * 1000.0);
        return this;
    }

    public ReservoirBuilder max(double amount) {
        this.fluidMaximum = (int)Math.floor(amount * 1000.0);
        return this;
    }

    public ReservoirBuilder trace(double amount) {
        this.fluidTrace = (int)Math.floor(amount * 1000.0);
        return this;
    }

    public ReservoirBuilder weight(int weight) {
        this.weight = weight;
        return this;
    }

    public ReservoirBuilder setDimensions(boolean isBlacklist, @Nonnull ResourceLocation[] dimensions) {
        if (this.dimensions.size() > 0) {
            throw new IllegalArgumentException("Dimensions list already set.");
        }
        Objects.requireNonNull(dimensions);
        this.isDimBlacklist = isBlacklist;
        for (ResourceLocation rl : dimensions) {
            if (rl == null || this.dimensions.contains((JsonElement)new JsonPrimitive(rl.toString()))) continue;
            this.dimensions.add(rl.toString());
        }
        return this;
    }

    public ReservoirBuilder setBiomes(boolean isBlacklist, @Nonnull ResourceLocation[] biomes) {
        if (this.biomes.size() > 0) {
            throw new IllegalArgumentException("Biomes list already set.");
        }
        Objects.requireNonNull(biomes);
        this.isBioBlacklist = isBlacklist;
        for (ResourceLocation rl : biomes) {
            if (rl == null || this.biomes.contains((JsonElement)new JsonPrimitive(rl.toString()))) continue;
            this.biomes.add(rl.toString());
        }
        return this;
    }
}

