/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.client.particle.IPParticleTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidParticleData
implements ParticleOptions {
    public static final Codec<FluidParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("fluid").forGetter(data -> data.fluid.getRegistryName().toString())).apply((Applicative)instance, FluidParticleData::new));
    public static final ParticleOptions.Deserializer<FluidParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FluidParticleData>(){

        @Nonnull
        public FluidParticleData fromCommand(@Nonnull ParticleType<FluidParticleData> particleTypeIn, StringReader reader) {
            String name = reader.getString();
            return new FluidParticleData(name);
        }

        @Nonnull
        public FluidParticleData fromNetwork(@Nonnull ParticleType<FluidParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            String name = buffer.m_130277_();
            return new FluidParticleData(name);
        }
    };
    private final Fluid fluid;

    public FluidParticleData(String name) {
        this((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name)));
    }

    public FluidParticleData(Fluid fluid) {
        this.fluid = fluid;
    }

    @Nonnull
    public ParticleType<FluidParticleData> m_6012_() {
        return IPParticleTypes.FLUID_SPILL;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.fluid.getRegistryName().toString());
    }

    @Nonnull
    public String m_5942_() {
        return this.fluid.getRegistryName().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Fluid getFluid() {
        return this.fluid;
    }
}

