/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.fluids.NapalmFluid;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEventHandler {
    static final Random random = new Random();
    public static final Map<ResourceLocation, List<BlockPos>> napalmPositions = new HashMap<ResourceLocation, List<BlockPos>>();
    public static final Map<ResourceLocation, List<BlockPos>> toRemove = new HashMap<ResourceLocation, List<BlockPos>>();

    @SubscribeEvent
    public void onSave(WorldEvent.Save event) {
        if (!event.getWorld().m_5776_()) {
            IPSaveData.markInstanceAsDirty();
        }
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        if (!event.getWorld().m_5776_()) {
            IPSaveData.markInstanceAsDirty();
        }
    }

    @SubscribeEvent
    public void handleBoatImmunity(LivingAttackEvent event) {
        if (event.getSource() == DamageSource.f_19308_ || event.getSource() == DamageSource.f_19307_ || event.getSource() == DamageSource.f_19305_) {
            LivingEntity entity = event.getEntityLiving();
            Entity entity2 = entity.m_20202_();
            if (entity2 instanceof MotorboatEntity) {
                MotorboatEntity boat = (MotorboatEntity)entity2;
                if (boat.isFireproof) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (entity.m_20094_() > 0 && entity.m_21124_((MobEffect)IPEffects.ANTI_DISMOUNT_FIRE.get()) != null) {
                entity.m_20095_();
                entity.m_21195_((MobEffect)IPEffects.ANTI_DISMOUNT_FIRE.get());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void handleBoatImmunity(TickEvent.PlayerTickEvent event) {
        Entity entity;
        Player entity2 = event.player;
        if (entity2.m_6060_() && (entity = entity2.m_20202_()) instanceof MotorboatEntity) {
            MotorboatEntity boat = (MotorboatEntity)entity;
            if (boat.isFireproof) {
                entity2.m_20095_();
                boat.m_20115_(0, false);
            }
        }
    }

    @SubscribeEvent
    public void handleDismountingBoat(EntityMountEvent event) {
        if (event.getEntityMounting() == null) {
            return;
        }
        Entity entity = event.getEntityMounting();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity = event.getEntityBeingMounted();
            if (entity instanceof MotorboatEntity) {
                FluidState fluidstate;
                MotorboatEntity boat = (MotorboatEntity)entity;
                if (event.isDismounting() && boat.isFireproof && (fluidstate = event.getWorldObj().m_8055_(new BlockPos(boat.m_20182_().m_82520_(0.5, 0.0, 0.5))).m_60819_()) != Fluids.f_76191_.m_76145_() && fluidstate.m_205070_(FluidTags.f_13132_)) {
                    living.m_7292_(new MobEffectInstance((MobEffect)IPEffects.ANTI_DISMOUNT_FIRE.get(), 1, 0, false, false));
                }
            }
        }
    }

    @SubscribeEvent
    public void handleLubricatingMachinesServer(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CommonEventHandler.handleLubricatingMachines(event.world);
        }
    }

    public static void handleLubricatingMachines(Level world) {
        HashSet<LubricatedHandler.LubricatedTileInfo> toRemove = new HashSet<LubricatedHandler.LubricatedTileInfo>();
        for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
            BlockEntity te;
            LubricatedHandler.ILubricationHandler<BlockEntity> lubeHandler;
            if (info.world != world.m_46472_() || !world.isAreaLoaded(info.pos, 0) || (lubeHandler = LubricatedHandler.getHandlerForTile(te = world.m_7702_(info.pos))) == null) continue;
            if (lubeHandler.isMachineEnabled(world, te)) {
                if (world.f_46443_) {
                    lubeHandler.lubricateClient((ClientLevel)world, info.lubricant, info.ticks, te);
                } else {
                    lubeHandler.lubricateServer((ServerLevel)world, info.lubricant, info.ticks, te);
                }
            }
            if (world.f_46443_ && te instanceof MultiblockPartBlockEntity) {
                MultiblockPartBlockEntity part = (MultiblockPartBlockEntity)te;
                Vec3i size = lubeHandler.getStructureDimensions();
                int numBlocks = (int)((float)(size.m_123341_() * size.m_123342_() * size.m_123343_()) * 0.25f);
                for (int i = 0; i < numBlocks; ++i) {
                    MultiblockPartBlockEntity part2;
                    BlockEntity te2;
                    BlockPos pos = part.getBlockPosForPos(new BlockPos((double)((float)size.m_123341_() * random.nextFloat()), (double)((float)size.m_123342_() * random.nextFloat()), (double)((float)size.m_123343_() * random.nextFloat())));
                    if (world.m_8055_(pos) == Blocks.f_50016_.m_49966_() || !((te2 = world.m_7702_(pos)) instanceof MultiblockPartBlockEntity) || (part2 = (MultiblockPartBlockEntity)te2).master() != part.master()) continue;
                    for (Direction facing : Direction.Plane.HORIZONTAL) {
                        if (world.f_46441_.nextInt(30) != 0) continue;
                        Vec3i direction = facing.m_122436_();
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123780_, (double)((float)pos.m_123341_() + 0.5f + (float)direction.m_123341_() * 0.65f), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + 0.5f + (float)direction.m_123343_() * 0.65f), 0.0, 0.0, 0.0);
                    }
                }
            }
            if (info.ticks-- > 0) continue;
            toRemove.add(info);
        }
        for (LubricatedHandler.LubricatedTileInfo info : toRemove) {
            LubricatedHandler.lubricatedTiles.remove(info);
        }
    }

    @SubscribeEvent
    public void onEntityJoiningWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getEntity() instanceof FakePlayer) {
                return;
            }
            if (((Boolean)IPServerConfig.MISCELLANEOUS.autounlock_recipes.get()).booleanValue()) {
                ArrayList l = new ArrayList();
                Collection recipes = event.getWorld().m_7465_().m_44051_();
                recipes.forEach(recipe -> {
                    ResourceLocation name = recipe.m_6423_();
                    if (name.m_135827_().equals("immersivepetroleum")) {
                        l.add(recipe);
                    }
                });
                player.m_7281_(l);
            }
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Skeleton) {
            DamageSource src;
            Entity entity;
            Skeleton skelly = (Skeleton)livingEntity;
            if (!skelly.f_19853_.f_46443_ && (entity = (src = event.getSource()).m_7639_()) instanceof Player) {
                Entity entity2;
                Player player = (Player)entity;
                if (!player.f_19853_.f_46443_ && (entity2 = player.m_20202_()) instanceof MotorboatEntity) {
                    MotorboatEntity motorboat = (MotorboatEntity)entity2;
                    if (!motorboat.f_19853_.f_46443_ && src.m_19360_() && motorboat.isSpinningFastEnough() && motorboat.hasRudders) {
                        Utils.unlockIPAdvancement(player, "main/rudders");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleNapalm(TickEvent.WorldTickEvent event) {
        block5: {
            ResourceLocation d;
            block4: {
                d = event.world.m_46472_().m_135782_();
                if (event.phase != TickEvent.Phase.START) break block4;
                toRemove.put(d, new ArrayList());
                if (napalmPositions.get(d) == null) break block5;
                ArrayList iterate = new ArrayList(napalmPositions.get(d));
                for (BlockPos position : iterate) {
                    BlockState state = event.world.m_8055_(position);
                    if (state.m_60734_() instanceof LiquidBlock && state.m_60734_() == IPContent.Fluids.NAPALM.block().get()) {
                        NapalmFluid.processFire(IPContent.Fluids.NAPALM, event.world, position);
                    }
                    toRemove.get(d).add(position);
                }
                break block5;
            }
            if (event.phase == TickEvent.Phase.END && toRemove.get(d) != null && napalmPositions.get(d) != null) {
                for (BlockPos position : toRemove.get(d)) {
                    napalmPositions.get(d).remove(position);
                }
            }
        }
    }
}

