/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.survey.ISurveyInfo;
import flaxbeard.immersivepetroleum.common.util.survey.IslandInfo;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class SurveyResultItem
extends IPItemBase {
    public SurveyResultItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        String selfKey = this.m_5671_(stack);
        return new TranslatableComponent(selfKey).m_130940_(ChatFormatting.GOLD);
    }

    public void m_7373_(ItemStack stack, Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (stack.m_41782_() && stack.m_41783_() != null) {
            ISurveyInfo info = ISurveyInfo.from(stack);
            if (info instanceof SurveyScan) {
                SurveyScan scan = (SurveyScan)info;
                tooltip.add((Component)new TranslatableComponent("desc.immersivepetroleum.flavour.surveytool.holdme"));
                if (flagIn == TooltipFlag.Default.ADVANCED) {
                    tooltip.add((Component)new TextComponent("ID: " + (scan.getUuid() != null ? scan.getUuid().toString() : "Null")));
                    tooltip.add((Component)new TextComponent("dSize: " + (Serializable)(scan.getData() != null ? Integer.valueOf(scan.getData().length) : "Null")));
                }
            }
            if (info instanceof IslandInfo) {
                IslandInfo islandInfo = (IslandInfo)info;
                int expected = islandInfo.getExpected();
                long amount = islandInfo.getAmount();
                byte percentage = islandInfo.getStatus();
                FluidStack fs = islandInfo.getFluidStack();
                tooltip.add((Component)new TranslatableComponent(fs.getTranslationKey()).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)new TranslatableComponent("desc.immersivepetroleum.info.survey_result.amount", new Object[]{String.format(Locale.ENGLISH, "%,.3f", (double)amount / 1000.0), percentage}).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)new TranslatableComponent("desc.immersivepetroleum.info.survey_result.expected", new Object[]{expected}).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (info != null) {
                int x = info.getX();
                int z = info.getZ();
                tooltip.add((Component)new TranslatableComponent("desc.immersivepetroleum.flavour.surveytool.location", new Object[]{x, z}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }
}

