/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class CokerUnitRecipeCategory
extends IPRecipeCategory<CokerUnitRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("cokerunit");
    private final IDrawableStatic tankOverlay;

    public CokerUnitRecipeCategory(IGuiHelper guiHelper) {
        super(CokerUnitRecipe.class, guiHelper, ID, "block.immersivepetroleum.coker_unit");
        ResourceLocation background = ResourceUtils.ip("textures/gui/jei/coker.png");
        ResourceLocation coker = ResourceUtils.ip("textures/gui/coker.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 150, 77));
        this.setIcon(new ItemStack((ItemLike)IPContent.Multiblock.COKERUNIT.get()));
        this.tankOverlay = guiHelper.createDrawable(coker, 200, 0, 20, 51);
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, CokerUnitRecipe recipe, @Nonnull IFocusGroup focuses) {
        int total = 0;
        List list = recipe.inputFluid.getMatchingFluidStacks();
        if (!list.isEmpty()) {
            for (FluidStack f : list) {
                total += f.getAmount();
            }
        } else {
            total = 100;
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).setFluidRenderer(total, false, 20, 51).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, list);
        total = 0;
        list = recipe.outputFluid.getMatchingFluidStacks();
        if (!list.isEmpty()) {
            for (FluidStack f : list) {
                total += f.getAmount();
            }
        } else {
            total = 100;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 2).setFluidRenderer(total, false, 20, 51).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, list);
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 58).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.inputItem.getMatchingStacks()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 52, 58).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList((ItemStack)recipe.outputItem.get()));
    }

    public void draw(CokerUnitRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        Font font = MCUtil.getFont();
        int time = (recipe.getTotalProcessTime() + 2 + 5) * recipe.inputItem.getCount();
        int energy = recipe.getTotalProcessEnergy();
        matrix.m_85836_();
        String text0 = I18n.m_118938_((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.fDecimal(energy)});
        float f = bWidth - 5 - font.m_92895_(text0);
        int n = bHeight / 3;
        Objects.requireNonNull(font);
        font.m_92883_(matrix, text0, f, (float)(n + 9), -1);
        String text1 = I18n.m_118938_((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.fDecimal((double)time / 20.0)});
        float f2 = bWidth - 10 - font.m_92895_(text1);
        int n2 = bHeight / 3;
        Objects.requireNonNull(font);
        font.m_92883_(matrix, text1, f2, (float)(n2 + 9 * 2), -1);
        matrix.m_85849_();
    }

    @Deprecated
    public ResourceLocation getUid() {
        return null;
    }

    @Deprecated
    public Class<? extends CokerUnitRecipe> getRecipeClass() {
        return null;
    }
}

