/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockCarWorkshop
extends BlockBase
implements EntityBlock,
IItemBlock {
    public static final BooleanProperty VALID = BooleanProperty.m_61465_((String)"valid");

    protected BlockCarWorkshop() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60978_(3.0f).m_60918_(SoundType.f_56743_));
        this.setRegistryName(new ResourceLocation("car", "car_workshop"));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VALID, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().m_41491_(ModItemGroups.TAB_CAR)).setRegistryName(this.getRegistryName());
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        TileEntityCarWorkshop workshop = this.getOwnTileEntity(worldIn, pos);
        if (workshop == null) {
            return InteractionResult.FAIL;
        }
        if (!workshop.areBlocksAround()) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            TileEntityContainerProvider.openGui((ServerPlayer)player, workshop, (i, playerInventory, playerEntity) -> new ContainerCarWorkshopCrafting(i, workshop, playerInventory));
        }
        return InteractionResult.SUCCESS;
    }

    public TileEntityCarWorkshop getOwnTileEntity(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile == null) {
            return null;
        }
        if (!(tile instanceof TileEntityCarWorkshop)) {
            return null;
        }
        return (TileEntityCarWorkshop)tile;
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        TileEntityCarWorkshop workshop = this.getOwnTileEntity(worldIn, pos);
        if (workshop == null) {
            return;
        }
        workshop.checkValidity();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)VALID, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VALID});
    }

    public void setValid(Level world, BlockPos pos, BlockState state, boolean valid) {
        if (((Boolean)state.m_61143_((Property)VALID)).equals(valid)) {
            return;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)VALID, (Comparable)Boolean.valueOf(valid)), 2);
        if (tileentity != null) {
            tileentity.m_6339_();
            world.m_151523_(tileentity);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityCarWorkshop workshop = this.getOwnTileEntity(worldIn, pos);
        if (workshop != null) {
            Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)workshop);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TileEntityCarWorkshop(blockPos, blockState);
    }
}

