/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public final class TagHelper {
    public static boolean hasCompoundTag(CompoundTag compound, String tagName) {
        return compound.m_128425_(tagName, Types.COMPOUND.id);
    }

    public static CompoundTag serialize(INBTSerializable<CompoundTag> source) {
        if (source instanceof BlockEntity) {
            BlockEntity tile = (BlockEntity)source;
            return tile.m_187482_();
        }
        return (CompoundTag)source.serializeNBT();
    }

    @Nullable
    public static CompoundTag getNestedCompound(CompoundTag compound, String path) {
        String[] split;
        if (path.isEmpty()) {
            return compound;
        }
        for (String key : split = path.split("/")) {
            Tag tag = compound.m_128423_(key);
            if (!(tag instanceof CompoundTag)) {
                return null;
            }
            compound = (CompoundTag)tag;
        }
        return compound;
    }

    @Nullable
    public static Tag getTag(CompoundTag compound, KeyPathPair pair) {
        return (compound = TagHelper.getNestedCompound(compound, pair.path)) != null ? compound.m_128423_(pair.key) : null;
    }

    public static Types getType(CompoundTag compound, String key) {
        byte id = compound.m_128435_(key);
        for (Types type : Types.values()) {
            if (type.id != id) continue;
            return type;
        }
        return Types.NULL;
    }

    public static void putVect3d(CompoundTag compound, String key, Vect3d vec) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_(Vec3Keys.x.name(), vec.x);
        tag.m_128347_(Vec3Keys.y.name(), vec.y);
        tag.m_128347_(Vec3Keys.z.name(), vec.z);
        compound.m_128365_(key, (Tag)tag);
    }

    public static Vect3d getVect3d(CompoundTag compound, String key) {
        CompoundTag tag = compound.m_128469_(key);
        return Vect3d.from(tag.m_128459_(Vec3Keys.x.name()), tag.m_128459_(Vec3Keys.y.name()), tag.m_128459_(Vec3Keys.z.name()));
    }

    public static void putBlockPos(CompoundTag compound, String key, BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(Vec3Keys.x.name(), pos.m_123341_());
        tag.m_128405_(Vec3Keys.y.name(), pos.m_123342_());
        tag.m_128405_(Vec3Keys.z.name(), pos.m_123343_());
        compound.m_128365_(key, (Tag)tag);
    }

    public static BlockPos getBlockPos(CompoundTag compound, String key) {
        CompoundTag tag = compound.m_128469_(key);
        return new BlockPos(tag.m_128451_(Vec3Keys.x.name()), tag.m_128451_(Vec3Keys.y.name()), tag.m_128451_(Vec3Keys.z.name()));
    }

    @Nullable
    public static <T extends Enum<T>> T getEnumValue(CompoundTag compound, Class<T> enumClass) {
        String name = compound.m_128461_(enumClass.getSimpleName());
        return name.isEmpty() ? null : (T)Enum.valueOf(enumClass, name);
    }

    public static <T extends Enum<T>> void putEnumValue(CompoundTag compound, T enumValue) {
        compound.m_128359_(enumValue.getClass().getSimpleName(), enumValue.name());
    }

    public static String[] getStringArray(CompoundTag compound, String key) {
        ListTag list = compound.m_128437_(key, Types.STRING.id);
        int count = list.size();
        String[] strings = new String[count];
        for (int i = 0; i < count; ++i) {
            strings[i] = list.m_128778_(i);
        }
        return strings;
    }

    public static void putStringArray(CompoundTag compound, String key, String ... strings) {
        ListTag list = new ListTag();
        for (String str : strings) {
            StringTag tag = StringTag.m_129297_((String)str);
            list.add((Object)tag);
        }
        compound.m_128365_(key, (Tag)list);
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> getByTag(String tag, IForgeRegistry<T> registry) {
        ITagManager allTags = registry.tags();
        if (allTags != null) {
            ResourceLocation location = UnitId.from(tag).toResLoc();
            return allTags.getTagNames().filter(name -> name.f_203868_().equals((Object)location)).filter(arg_0 -> ((ITagManager)allTags).isKnownTagName(arg_0)).map(arg_0 -> ((ITagManager)allTags).getTag(arg_0)).flatMap(ITag::stream).toList();
        }
        return Collections.emptyList();
    }

    public static enum Types {
        NULL(0),
        BYTE(1),
        SHORT(2),
        INT(3),
        LONG(4),
        FLOAT(5),
        DOUBLE(6),
        BYTE$$(7),
        STRING(8),
        LIST(9),
        COMPOUND(10),
        INT$$(11),
        LONG$$(12),
        ORDINAL(99);

        public final int id;

        private Types(int id) {
            this.id = id;
        }

        public boolean isOrdinal() {
            return this.id == 99 || this.id >= 1 && this.id <= 6;
        }

        public String toString() {
            String string = this.name().toLowerCase(Locale.ROOT);
            return this.isOrdinal() ? string : CommonString.capitalizeFirstChar(string).replace("$$", "[]");
        }
    }

    public record KeyPathPair(String path, String key) {
        public static KeyPathPair parse(String str) {
            int pos = str.lastIndexOf("/");
            if (pos < 0) {
                return new KeyPathPair("", str);
            }
            return new KeyPathPair(str.substring(0, pos), str.substring(pos + 1));
        }
    }

    static enum Vec3Keys {
        x,
        y,
        z;

    }

    static enum UUIDKeys {
        m,
        l;

    }
}

