/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.content.mobs.entity.Toretoise;

public class ToretoiseModel
extends EntityModel<Toretoise> {
    private Toretoise entity;
    private float animFrames;
    public ModelPart body;
    public ModelPart head;
    public ModelPart rightFrontLeg;
    public ModelPart leftFrontLeg;
    public ModelPart rightBackLeg;
    public ModelPart leftBackLeg;
    public ModelPart mouth;
    public ModelPart CoalOre1;
    public ModelPart CoalOre2;
    public ModelPart CoalOre3;
    public ModelPart CoalOre4;
    public ModelPart IronOre1;
    public ModelPart IronOre2;
    public ModelPart IronOre3;
    public ModelPart LapisOre1;
    public ModelPart LapisOre2;
    public ModelPart LapisOre3;
    public ModelPart LapisOre4;
    public ModelPart RedstoneOre1;
    public ModelPart RedstoneOre2;
    public ModelPart RedstoneOre3;
    public ModelPart RedstoneOre4;
    public ModelPart RedstoneOre5;

    public ToretoiseModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.rightFrontLeg = root.m_171324_("rightFrontLeg");
        this.leftFrontLeg = root.m_171324_("leftFrontLeg");
        this.rightBackLeg = root.m_171324_("rightBackLeg");
        this.leftBackLeg = root.m_171324_("leftBackLeg");
        this.mouth = this.head.m_171324_("mouth");
        this.CoalOre1 = this.body.m_171324_("CoalOre1");
        this.CoalOre2 = this.body.m_171324_("CoalOre2");
        this.CoalOre3 = this.body.m_171324_("CoalOre3");
        this.CoalOre4 = this.body.m_171324_("CoalOre4");
        this.IronOre1 = this.body.m_171324_("IronOre1");
        this.IronOre2 = this.body.m_171324_("IronOre2");
        this.IronOre3 = this.body.m_171324_("IronOre3");
        this.LapisOre1 = this.body.m_171324_("LapisOre1");
        this.LapisOre2 = this.body.m_171324_("LapisOre2");
        this.LapisOre3 = this.body.m_171324_("LapisOre3");
        this.LapisOre4 = this.body.m_171324_("LapisOre4");
        this.RedstoneOre1 = this.body.m_171324_("RedstoneOre1");
        this.RedstoneOre2 = this.body.m_171324_("RedstoneOre2");
        this.RedstoneOre3 = this.body.m_171324_("RedstoneOre3");
        this.RedstoneOre4 = this.body.m_171324_("RedstoneOre4");
        this.RedstoneOre5 = this.body.m_171324_("RedstoneOre5");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-11.0f, 0.0f, -13.0f, 22.0f, 12.0f, 26.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171481_(-4.0f, -4.0f, -8.0f, 8.0f, 5.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-13.0f));
        head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(66, 38).m_171481_(-4.5f, -2.5f, -8.0f, 9.0f, 4.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-1.0f));
        root.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171480_().m_171514_(34, 38).m_171481_(-4.0f, -2.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171423_((float)10.0f, (float)16.0f, (float)-12.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        root.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(34, 38).m_171481_(-4.0f, -2.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171423_((float)-10.0f, (float)16.0f, (float)12.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(34, 38).m_171481_(-4.0f, -2.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171423_((float)-10.0f, (float)16.0f, (float)-12.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        root.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171480_().m_171514_(34, 38).m_171481_(-4.0f, -2.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171423_((float)10.0f, (float)16.0f, (float)12.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        body.m_171599_("CoalOre1", CubeListBuilder.m_171558_().m_171514_(36, 56).m_171481_(0.0f, -7.0f, -6.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("CoalOre2", CubeListBuilder.m_171558_().m_171514_(42, 56).m_171481_(7.0f, -2.0f, -10.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("CoalOre3", CubeListBuilder.m_171558_().m_171514_(66, 50).m_171481_(-2.0f, -7.0f, -4.0f, 7.0f, 7.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("CoalOre4", CubeListBuilder.m_171558_().m_171514_(60, 64).m_171481_(-15.0f, 0.0f, 1.0f, 4.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("IronOre1", CubeListBuilder.m_171558_().m_171514_(36, 89).m_171481_(1.0f, -3.0f, 1.0f, 8.0f, 3.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("IronOre2", CubeListBuilder.m_171558_().m_171514_(32, 81).m_171481_(-7.0f, -2.0f, -11.0f, 6.0f, 2.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("IronOre3", CubeListBuilder.m_171558_().m_171514_(30, 76).m_171481_(-9.0f, -1.0f, 6.0f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("LapisOre1", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171481_(-5.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("LapisOre2", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171481_(-1.0f, -8.0f, -4.0f, 0.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("LapisOre3", CubeListBuilder.m_171558_().m_171514_(18, 51).m_171481_(-10.0f, -8.0f, 8.0f, 8.0f, 8.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("LapisOre4", CubeListBuilder.m_171558_().m_171514_(18, 53).m_171481_(-6.0f, -8.0f, 4.0f, 0.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("RedstoneOre1", CubeListBuilder.m_171558_().m_171514_(0, 83).m_171481_(-8.0f, -12.0f, -6.0f, 5.0f, 12.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("RedstoneOre2", CubeListBuilder.m_171558_().m_171514_(0, 74).m_171481_(6.0f, -6.0f, -1.0f, 3.0f, 6.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("RedstoneOre3", CubeListBuilder.m_171558_().m_171514_(12, 76).m_171481_(-7.0f, -4.0f, 2.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("RedstoneOre4", CubeListBuilder.m_171558_().m_171514_(20, 87).m_171481_(1.0f, -9.0f, -9.0f, 4.0f, 9.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("RedstoneOre5", CubeListBuilder.m_171558_().m_171514_(15, 77).m_171481_(-1.0f, -5.0f, 5.0f, 5.0f, 5.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)100, (int)100);
    }

    public void setupAnim(@Nonnull Toretoise entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.entity = entity;
        this.animFrames = limbSwing;
    }

    public void m_7695_(PoseStack matrix, @Nonnull VertexConsumer vb, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrix.m_85836_();
        int bufferTime = 10;
        if (this.entity.angeryTicks > 0 && this.entity.angeryTicks < 20 - bufferTime) {
            double angeryTime = (double)(((float)this.entity.angeryTicks - ClientTicker.partialTicks) / (float)(20 - bufferTime)) * Math.PI;
            angeryTime = Math.sin(angeryTime) * -20.0;
            matrix.m_85837_(0.0, 1.0, 1.0);
            matrix.m_85845_(Vector3f.f_122223_.m_122240_((float)angeryTime));
            matrix.m_85837_(0.0, -1.0, -1.0);
        }
        float animSpeed = 30.0f;
        float animPause = 12.0f;
        float actualFrames = this.animFrames * 10.0f;
        float doubleAnimSpeed = animSpeed * 2.0f;
        float animBuff = animSpeed - animPause;
        float scale = 0.02f;
        float bodyTrans = (float)(Math.sin((double)(actualFrames / doubleAnimSpeed) * Math.PI) + 1.0) * scale;
        float rideMultiplier = 0.0f;
        if (this.entity.rideTime > 0) {
            rideMultiplier = Math.min(30.0f, (float)(this.entity.rideTime - 1) + ClientTicker.partialTicks) / 30.0f;
        }
        matrix.m_85837_(0.0, (double)(bodyTrans *= 1.0f - rideMultiplier), 0.0);
        matrix.m_85845_(Vector3f.f_122227_.m_122270_((bodyTrans - scale) * 0.5f));
        this.body.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrix.m_85836_();
        matrix.m_85837_(0.0, (double)bodyTrans, (double)rideMultiplier * 0.3);
        this.head.f_104203_ = bodyTrans * 2.0f;
        this.head.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrix.m_85849_();
        float finalRideMultiplier = rideMultiplier;
        BiConsumer<ModelPart, Float> draw = (renderer, frames) -> {
            float time = Math.min(animBuff, frames.floatValue() % doubleAnimSpeed);
            float trans = (float)(Math.sin((double)(time / animBuff) * Math.PI) + 1.0) / -2.0f * 0.12f + 0.06f;
            float rotTime = frames.floatValue() % doubleAnimSpeed;
            float rot = ((float)Math.sin((double)(rotTime / doubleAnimSpeed) * Math.PI) + 1.0f) * -0.25f;
            trans *= 1.0f - finalRideMultiplier;
            rot *= 1.0f - finalRideMultiplier;
            trans = (float)((double)trans + (double)finalRideMultiplier * -0.2);
            matrix.m_85836_();
            ModelPart.Cube box = renderer.m_104328_(this.entity.m_21187_());
            double spread = -0.1125 * (double)finalRideMultiplier;
            double x = renderer.f_104200_ + box.f_104335_;
            double z = renderer.f_104202_ + box.f_104337_;
            x *= spread / Math.abs(x);
            z *= spread / Math.abs(z);
            matrix.m_85837_(x, 0.0, z);
            matrix.m_85837_(0.0, (double)trans, 0.0);
            float yRot = renderer.f_104204_;
            renderer.f_104203_ = rot;
            renderer.f_104204_ *= 1.0f - finalRideMultiplier;
            renderer.m_104306_(matrix, vb, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            renderer.f_104204_ = yRot;
            matrix.m_85849_();
        };
        draw.accept(this.leftFrontLeg, Float.valueOf(actualFrames));
        draw.accept(this.rightFrontLeg, Float.valueOf(actualFrames + animSpeed));
        draw.accept(this.leftBackLeg, Float.valueOf(actualFrames + animSpeed * 0.5f));
        draw.accept(this.rightBackLeg, Float.valueOf(actualFrames + animSpeed * 1.5f));
        matrix.m_85849_();
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

