/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VacuumTube
extends DamageableItem {
    public static final FloatBounds SUCK_INTERVAL_BOUNDS_IN_SEC = FloatBounds.between((Float)Float.valueOf(0.25f), (Float)Float.valueOf(1.0f));
    protected final GameTime suckInterval;
    protected final float speed;
    protected final boolean canSuckIntoInventory;

    public VacuumTube(AbstractForgeMod mod, UnitConfig config, Materials material) {
        super(mod, config, material.getName() + "_vacuum_tube", new Item.Properties().m_41491_(CreativeModeTab.f_40756_), material.durability, UnitId.from((String)material.tag));
        this.speed = UnitConfig.getFloat((UnitConfig)this.getConfig(), (String)this.getUnitCategory(), (String)"speed", (float)material.speed, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Defines operating speed for the vacuum cleaner.");
        this.suckInterval = GameTime.seconds((float)SUCK_INTERVAL_BOUNDS_IN_SEC.interpolateDown(this.speed).floatValue());
        this.canSuckIntoInventory = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getUnitCategory(), (String)"canSuckIntoInventory", (boolean)false, (String)"Defines the ability to suck pollution into a player's inventory");
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        BlockHitResult result;
        BlockPos pos;
        BlockState state;
        Level level = living.f_19853_;
        if (level == null || !this.isClientSide((LevelReader)level)) {
            return;
        }
        if (!(living instanceof LocalPlayer)) {
            return;
        }
        if (!this.suckInterval.pastIn(level)) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        float reachDistance = Optional.ofNullable(mc.f_91072_).map(mode -> Float.valueOf(mode.m_105286_())).orElse(Float.valueOf(5.0f)).floatValue();
        Optional hit = ForgeEntity.rayTraceBlockBeingLookedAt((Entity)living, (ClipContext.Block)ClipContext.Block.VISUAL, (ClipContext.Fluid)ClipContext.Fluid.ANY, (float)1.0f, (float)reachDistance);
        if (hit.isPresent() && (state = level.m_8055_(pos = ((BlockHitResult)hit.get()).m_82425_())).m_60734_() instanceof AbstractGas) {
            new BlockSuckInMsg(pos).sendToServer();
            return;
        }
        Vec3 startVec = living.m_20299_(1.0f);
        Vec3 lookVec = living.m_20252_(1.0f).m_82490_((double)reachDistance);
        Vec3 endVec = startVec.m_82549_(lookVec);
        AABB boundingBox = living.m_142469_().m_82369_(lookVec).m_82377_(1.0, 1.0, 1.0);
        double minDistance = Double.MAX_VALUE;
        Entity closestTarget = null;
        Vec3 closestHit = null;
        for (Entity target : level.m_45976_(GasEntity.class, boundingBox)) {
            double distance;
            AABB aabb = target.m_142469_().m_82400_(0.3);
            Vec3 hit2 = aabb.m_82371_(startVec, endVec).orElse(null);
            if (hit2 == null || !((distance = startVec.m_82557_(hit2)) < minDistance)) continue;
            closestTarget = target;
            closestHit = hit2;
            minDistance = distance;
        }
        if (closestTarget != null && closestHit != null && ((result = level.m_45547_(new ClipContext(startVec, closestHit, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)living))) == null || result.m_6662_() == HitResult.Type.MISS)) {
            new EntitySuckInMsg((GasEntity)closestTarget).sendToServer();
            return;
        }
    }

    public boolean suckIn(AbstractGas gas, ServerPlayer player) {
        VacuumBag bag;
        ItemStack stack;
        ServerLevel world = player.m_183503_();
        boolean suckedIn = false;
        Iterator iterator = ForgeEntity.getEquipmentOn((Entity)player).iterator();
        while (!(!iterator.hasNext() || (stack = (ItemStack)iterator.next()).m_41720_() instanceof VacuumBag && (suckedIn = (bag = (VacuumBag)stack.m_41720_()).fill(stack, (Pollutant<?>)gas, 1) > 0))) {
        }
        if (!suckedIn && (this.canSuckIntoInventory || player.m_7500_())) {
            suckedIn = player.m_150109_().m_36054_(new ItemStack((ItemLike)gas));
        }
        if (!suckedIn) {
            BlockPos toPos = player.m_142538_();
            boolean bl = suckedIn = gas.pump((LevelAccessor)world, toPos) || gas.pump((LevelAccessor)world, toPos.m_7494_());
        }
        if (suckedIn) {
            world.m_5594_(null, player.m_142538_(), SoundEvents.f_11893_, SoundSource.BLOCKS, 0.1f, this.speed);
        }
        return suckedIn;
    }

    public GameTime getSuckInterval() {
        return this.suckInterval;
    }

    public static class BlockSuckInMsg
    extends AbstractSuckInMsg<BlockSuckInMsg> {
        public BlockPos pos;

        public BlockSuckInMsg() {
        }

        public BlockSuckInMsg(BlockPos pos) {
            this.pos = pos;
        }

        public BlockSuckInMsg create() {
            return new BlockSuckInMsg();
        }

        @Override
        public void handle(Level world, VacuumTube tube, ServerPlayer player) {
            AbstractGas gas;
            Block block = world.m_8055_(this.pos).m_60734_();
            if (block instanceof AbstractGas && tube.suckIn(gas = (AbstractGas)block, player)) {
                gas.spend((LevelAccessor)world, this.pos);
            }
        }
    }

    public static class EntitySuckInMsg
    extends AbstractSuckInMsg<EntitySuckInMsg> {
        public int gasEntityId;

        public EntitySuckInMsg() {
        }

        public EntitySuckInMsg(GasEntity gas) {
            this.gasEntityId = gas.m_142049_();
        }

        public EntitySuckInMsg create() {
            return new EntitySuckInMsg();
        }

        @Override
        public void handle(Level world, VacuumTube tube, ServerPlayer player) {
            GasEntity gasCarrier;
            Optional<AbstractGas> gas;
            Entity entity = world.m_6815_(this.gasEntityId);
            if (entity instanceof GasEntity && (gas = (gasCarrier = (GasEntity)entity).getPollutant().filter(p -> p instanceof AbstractGas).map(p -> (AbstractGas)((Object)p))).isPresent() && tube.suckIn(gas.get(), player)) {
                gasCarrier.spend();
            }
        }
    }

    static abstract class AbstractSuckInMsg<T extends AbstractSuckInMsg<T>>
    extends ForgeNetMsg<T> {
        AbstractSuckInMsg() {
        }

        public final void handle(Level level, Player sender) {
            ServerPlayer player;
            Item item;
            if (sender instanceof ServerPlayer && (item = (player = (ServerPlayer)sender).m_21211_().m_41720_()) instanceof VacuumTube) {
                this.handle(level, (VacuumTube)item, player);
            }
        }

        public abstract void handle(Level var1, VacuumTube var2, ServerPlayer var3);

        public void sendToServer() {
            AdPother.getInstance().getConnection().sendToServer((Object)this);
        }
    }
}

