/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.RiftStabilizerBlock;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class RiftStabilizerBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
ILockable,
IToggleableEntries<TeleportationType> {
    private final Option.IntOption signalLength = new Option.IntOption(() -> ((RiftStabilizerBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);
    private final Option.IntOption range = new Option.IntOption(() -> ((RiftStabilizerBlockEntity)this).m_58899_(), "range", 5, 1, 15, 1, true);
    private final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private final Map<TeleportationType, Boolean> teleportationFilter = new EnumMap<TeleportationType, Boolean>(TeleportationType.class);
    private double lastTeleportDistance;
    private TeleportationType lastTeleportationType;
    private boolean tracked = false;

    public RiftStabilizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get(), pos, state);
        this.teleportationFilter.put(TeleportationType.CHORUS_FRUIT, true);
        this.teleportationFilter.put(TeleportationType.ENDER_PEARL, true);
        this.teleportationFilter.put(TeleportationType.ENDERMAN, false);
        this.teleportationFilter.put(TeleportationType.SHULKER, false);
        this.teleportationFilter.put(TeleportationType.MODDED, false);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.tracked) {
            BlockEntityTracker.RIFT_STABILIZER.track(this);
            this.tracked = true;
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        BlockEntityTracker.RIFT_STABILIZER.stopTracking(this);
    }

    @Override
    public void setFilter(TeleportationType teleportationType, boolean allowed) {
        if (this.teleportationFilter.containsKey((Object)teleportationType)) {
            RiftStabilizerBlockEntity connectedBlockEntity;
            this.teleportationFilter.put(teleportationType, allowed);
            this.m_6596_();
            if (this.f_58857_.f_46443_) {
                SecurityCraft.channel.sendToServer((Object)new SyncRiftStabilizer(this.f_58858_, teleportationType, allowed));
            }
            if ((connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.f_58857_, this.f_58858_)) != null) {
                connectedBlockEntity.teleportationFilter.put(teleportationType, allowed);
                connectedBlockEntity.m_6596_();
                if (this.f_58857_.f_46443_) {
                    SecurityCraft.channel.sendToServer((Object)new SyncRiftStabilizer(connectedBlockEntity.f_58858_, teleportationType, allowed));
                }
            }
        }
    }

    @Override
    public boolean getFilter(TeleportationType teleportationType) {
        return this.teleportationFilter.containsKey((Object)teleportationType) && this.teleportationFilter.get((Object)teleportationType) != false;
    }

    @Override
    public ToIntFunction<TeleportationType> getComparatorOutputFunction() {
        return t -> t.ordinal() + 1;
    }

    @Override
    public Map<TeleportationType, Boolean> getFilters() {
        return this.teleportationFilter;
    }

    @Override
    public TeleportationType getDefaultType() {
        return TeleportationType.MODDED;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag teleportationNBT = new CompoundTag();
        int i = 0;
        for (boolean b : this.teleportationFilter.values()) {
            teleportationNBT.m_128379_("teleportationType" + i, b);
            ++i;
        }
        tag.m_128365_("teleportationTypes", (Tag)teleportationNBT);
        tag.m_128347_("lastTeleportDistance", this.lastTeleportDistance);
        if (this.lastTeleportationType != null) {
            tag.m_128405_("lastTeleportationType", this.lastTeleportationType.ordinal());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("teleportationTypes", 10)) {
            CompoundTag teleportationNBT = tag.m_128469_("teleportationTypes");
            int i = 0;
            for (TeleportationType teleportationType : this.teleportationFilter.keySet()) {
                this.teleportationFilter.put(teleportationType, teleportationNBT.m_128471_("teleportationType" + i));
                ++i;
            }
        }
        this.lastTeleportDistance = tag.m_128459_("lastTeleportDistance");
        if (tag.m_128441_("lastTeleportationType")) {
            this.lastTeleportationType = TeleportationType.values()[tag.m_128451_("lastTeleportationType")];
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        RiftStabilizerBlockEntity connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.f_58857_, this.f_58858_);
        if (connectedBlockEntity != null && (toggled ? !connectedBlockEntity.isModuleEnabled(module) : !connectedBlockEntity.hasModule(module))) {
            connectedBlockEntity.insertModule(stack, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(this, stack);
            if (connectedBlockEntity != null) {
                this.onInsertDisguiseModule(connectedBlockEntity, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        RiftStabilizerBlockEntity connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.f_58857_, this.f_58858_);
        if (connectedBlockEntity != null && (toggled ? connectedBlockEntity.isModuleEnabled(module) : connectedBlockEntity.hasModule(module))) {
            connectedBlockEntity.removeModule(module, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(this, stack);
            if (connectedBlockEntity != null) {
                this.onRemoveDisguiseModule(connectedBlockEntity, stack);
            }
        } else if (module == ModuleType.SMART) {
            this.onRemoveSmartModule(this);
            if (connectedBlockEntity != null) {
                this.onRemoveSmartModule(connectedBlockEntity);
            }
        }
    }

    private void onInsertDisguiseModule(BlockEntity be, ItemStack stack) {
        if (!be.m_58904_().f_46443_) {
            be.m_58904_().m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        } else {
            ClientHandler.putDisguisedBeRenderer(be, stack);
        }
    }

    private void onRemoveDisguiseModule(BlockEntity be, ItemStack stack) {
        if (!be.m_58904_().f_46443_) {
            be.m_58904_().m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
    }

    private void onRemoveSmartModule(RiftStabilizerBlockEntity be) {
        be.teleportationFilter.put(TeleportationType.CHORUS_FRUIT, true);
        be.teleportationFilter.put(TeleportationType.ENDER_PEARL, true);
        be.teleportationFilter.put(TeleportationType.ENDERMAN, false);
        be.teleportationFilter.put(TeleportationType.SHULKER, false);
        be.teleportationFilter.put(TeleportationType.MODDED, false);
    }

    public void setLastTeleport(double teleportDistance, TeleportationType type) {
        this.lastTeleportDistance = teleportDistance;
        this.lastTeleportationType = type;
    }

    public double getLastTeleportDistance() {
        return this.lastTeleportDistance;
    }

    public TeleportationType getLastTeleportationType() {
        return this.lastTeleportationType;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.HARMING, ModuleType.SMART};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        RiftStabilizerBlockEntity connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.f_58857_, this.f_58858_);
        if (connectedBlockEntity != null) {
            if (option.getName().equals("signalLength")) {
                connectedBlockEntity.setSignalLength((Integer)((Option.IntOption)option).get());
            } else if (option.getName().equals("range")) {
                connectedBlockEntity.setRange((Integer)((Option.IntOption)option).get());
            } else if (option.getName().equals("disabled")) {
                connectedBlockEntity.setDisabled((Boolean)((Option.BooleanOption)option).get());
            } else if (option.getName().equals("ignoreOwner")) {
                connectedBlockEntity.setIgnoresOwner((Boolean)((Option.BooleanOption)option).get());
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength, this.range, this.disabled, this.ignoreOwner};
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player) {
        RiftStabilizerBlockEntity be = RiftStabilizerBlock.getConnectedBlockEntity(level, pos);
        if (be != null) {
            be.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.f_46443_) {
                level.m_142572_().m_6846_().m_11268_((Packet)be.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player);
    }

    public void setSignalLength(int signalLength) {
        if (this.getSignalLength() != signalLength) {
            this.signalLength.setValue(signalLength);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public void setRange(int range) {
        if (this.getRange() != range) {
            this.range.setValue(range);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            this.disabled.setValue(disabled);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setIgnoresOwner(boolean ignoresOwner) {
        if (this.ignoresOwner() != ignoresOwner) {
            this.ignoreOwner.setValue(ignoresOwner);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public static enum TeleportationType {
        CHORUS_FRUIT(Items.f_42730_.m_5524_()),
        ENDER_PEARL(Items.f_42584_.m_5524_()),
        ENDERMAN(EntityType.f_20566_.m_20675_()),
        SHULKER(EntityType.f_20521_.m_20675_()),
        MODDED("gui.securitycraft:rift_stabilizer.modded");

        public final String label;

        private TeleportationType(String label) {
            this.label = label;
        }

        public static TeleportationType getTypeFromEvent(EntityTeleportEvent event) {
            if (event instanceof EntityTeleportEvent.ChorusFruit) {
                return CHORUS_FRUIT;
            }
            if (event instanceof EntityTeleportEvent.EnderPearl) {
                return ENDER_PEARL;
            }
            if (event instanceof EntityTeleportEvent.EnderEntity) {
                EntityTeleportEvent.EnderEntity enderEntityEvent = (EntityTeleportEvent.EnderEntity)event;
                if (enderEntityEvent.getEntityLiving() instanceof EnderMan) {
                    return ENDERMAN;
                }
                if (enderEntityEvent.getEntityLiving() instanceof Shulker) {
                    return SHULKER;
                }
                return MODDED;
            }
            if (event instanceof EntityTeleportEvent.TeleportCommand || event instanceof EntityTeleportEvent.SpreadPlayersCommand) {
                return null;
            }
            return MODDED;
        }

        public String toString() {
            return this.label;
        }
    }
}

