/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IronFenceBlock
extends OwnableBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)PipeBlock.f_55154_.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] shapes;
    private final VoxelShape[] renderShapes;

    public IronFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.renderShapes = this.makeShapes(2.0f, 1.0f, 16.0f, 6.0f, 15.0f);
        this.collisionShapes = this.makeShapes(2.0f, 2.0f, 24.0f, 0.0f, 24.0f);
        this.shapes = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.renderShapes[this.getIndex(state)];
    }

    protected VoxelShape[] makeShapes(float nodeWith, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        float f = 8.0f - nodeWith;
        float f1 = 8.0f + nodeWith;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)nodeHeight, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)extensionBottom, (double)0.0, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)extensionBottom, (double)f2, (double)f3, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)extensionBottom, (double)f2, (double)16.0, (double)extensionHeight, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] returnValue = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            returnValue[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)returnValue[i]);
        }
        return returnValue;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes[this.getIndex(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.collisionShapes[this.getIndex(state)];
    }

    public boolean connectsTo(BlockState state, boolean isFaceSturdy, Direction direction) {
        Block block = state.m_60734_();
        boolean isFence = state.m_204336_(BlockTags.f_13039_) && state.m_60767_() == this.f_60442_;
        boolean isFenceGate = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return !IronFenceBlock.m_152463_((BlockState)state) && isFaceSturdy || isFence || isFenceGate;
    }

    private static int getMask(Direction facing) {
        return 1 << facing.m_122416_();
    }

    protected int getIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            i |= IronFenceBlock.getMask(Direction.NORTH);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            i |= IronFenceBlock.getMask(Direction.EAST);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            i |= IronFenceBlock.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            i |= IronFenceBlock.getMask(Direction.WEST);
        }
        return i;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> super.m_6943_(state, mirror);
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos clickedPos = ctx.m_8083_();
        BlockPos northPos = clickedPos.m_142127_();
        BlockPos eastPos = clickedPos.m_142126_();
        BlockPos southPos = clickedPos.m_142128_();
        BlockPos westPos = clickedPos.m_142125_();
        BlockState northState = level.m_8055_(northPos);
        BlockState eastState = level.m_8055_(eastPos);
        BlockState southState = level.m_8055_(southPos);
        BlockState westState = level.m_8055_(westPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(northState, northState.m_60783_((BlockGetter)level, northPos, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(eastState, eastState.m_60783_((BlockGetter)level, eastPos, Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(southState, southState.m_60783_((BlockGetter)level, southPos, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(westState, westState.m_60783_((BlockGetter)level, westPos, Direction.EAST), Direction.EAST)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? (BlockState)state.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.connectsTo(facingState, facingState.m_60783_((BlockGetter)level, facingPos, facing.m_122424_()), facing.m_122424_()))) : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.FAIL;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity)).m_83215_().m_82338_(pos).m_82400_(0.01).m_82381_(entity.m_142469_())) {
            return;
        }
        if (entity instanceof ItemEntity) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((OwnableBlockEntity)level.m_7702_(pos)).isOwnedBy(player)) {
                return;
            }
        } else if (!level.f_46443_ && entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            LightningBolt lightning = LevelUtils.createLightning(level, Vec3.m_82539_((Vec3i)pos), true);
            creeper.m_8038_((ServerLevel)level, lightning);
            creeper.m_20095_();
            return;
        }
        entity.m_6469_(CustomDamageSources.ELECTRICITY, 6.0f);
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, level, pos, eventID, eventParam);
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity == null ? false : blockEntity.m_7531_(eventID, eventParam);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity((BlockEntityType)SCContent.ABSTRACT_BLOCK_ENTITY.get(), pos, state);
    }
}

