/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.sentry;

import java.util.EnumSet;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class AttackRangedIfEnabledGoal
extends Goal {
    private Sentry sentry;
    private LivingEntity attackTarget;
    private int rangedAttackTime;
    private final Supplier<Integer> maxAttackTime;
    private final float attackRadius;

    public AttackRangedIfEnabledGoal(RangedAttackMob attacker, Supplier<Integer> maxAttackTime, float maxAttackDistance) {
        this.sentry = (Sentry)attacker;
        this.rangedAttackTime = -1;
        this.maxAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity potentialTarget = this.sentry.m_5448_();
        if (potentialTarget == null || this.sentry.isShutDown()) {
            return false;
        }
        this.attackTarget = potentialTarget;
        return this.sentry.getMode() != Sentry.SentryMode.IDLE;
    }

    public void m_8041_() {
        this.attackTarget = null;
        this.rangedAttackTime = -3;
    }

    public void m_8037_() {
        double targetDistance = this.sentry.m_20275_(this.attackTarget.m_20185_(), this.attackTarget.m_142469_().f_82289_, this.attackTarget.m_20189_());
        this.sentry.m_21563_().m_24960_((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (!this.sentry.m_21574_().m_148306_((Entity)this.attackTarget)) {
                return;
            }
            float f = Mth.m_14116_((float)((float)targetDistance)) / this.attackRadius;
            float distanceFactor = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.sentry.m_6504_(this.attackTarget, distanceFactor);
            this.rangedAttackTime = Mth.m_14143_((float)this.maxAttackTime.get().intValue());
        } else if (this.rangedAttackTime < 0) {
            this.rangedAttackTime = Mth.m_14143_((float)this.maxAttackTime.get().intValue());
        }
    }
}

