function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/contraptions/processing/InWorldProcessing',
		'methodName' : 'applyProcessing', 
		'methodDesc' : '(Lnet/minecraft/world/entity/item/ItemEntity;Lcom/simibubi/create/content/contraptions/processing/InWorldProcessing$Type;)V'
	}

	var node = {
		'class' : 'net/minecraft/world/entity/item/ItemEntity',
		'methodName' : resolveName('m_146870_'), // discard
		'methodDesc' : '()V'
	}

	var world = {
		'class' : 'net/minecraft/world/entity/item/ItemEntity',
		'methodName' : resolveName('m_183503_'), // getLevel
		'methodDesc' : '()Lnet/minecraft/world/level/Level;'
	}

	var position = {
		'class' : 'net/minecraft/world/entity/item/ItemEntity',
		'methodName' : resolveName('m_142538_'), // blockPosition
		'methodDesc' : '()Lnet/minecraft/core/BlockPos;'
	}

	var ordinal = {
		'class' : 'com/simibubi/create/content/contraptions/processing/InWorldProcessing$Type',
		'methodName' : 'ordinal', 
		'methodDesc' : '()I'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Create',
		'methodName' : 'handleInWorldProcessing',
		'methodDesc' : '(Lnet/minecraft/world/entity/item/ItemEntity;I)V'
	}

	var instructions = [ 
		insnLoadObj(0, "item entity"),
		insnLoadObj(1, "type"),
		insnInvokeVirtual(ordinal),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}