function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/entity/animal/Animal',
		'methodName' : resolveName('m_142075_'), // usePlayerItem
		'methodDesc' : '(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V'
	}

    var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : resolveName('m_41774_'), // shrink
		'methodDesc' : '(I)V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFoodConsumed',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/entity/Entity;)V'
	}

	var instructions = [
	    insnPushValue(1, "food amount"),
		insnLoadThis("animal"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("food stack"), instructions));
				return method;
			}
		}
	}
}