/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.util.IfFlagGoal;
import vazkii.quark.content.mobs.ai.ActWaryGoal;
import vazkii.quark.content.mobs.ai.FavorBlockGoal;
import vazkii.quark.content.mobs.ai.RunAndPoofGoal;
import vazkii.quark.content.mobs.module.StonelingsModule;
import vazkii.quark.content.tools.entity.Pickarang;
import vazkii.quark.content.world.module.GlimmeringWealdModule;
import vazkii.quark.content.world.module.NewStoneTypesModule;

public class Stoneling
extends PathfinderMob {
    public static final ResourceLocation CARRY_LOOT_TABLE = new ResourceLocation("quark", "entities/stoneling_carry");
    private static final EntityDataAccessor<ItemStack> CARRYING_ITEM = SynchedEntityData.m_135353_(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> HOLD_ANGLE = SynchedEntityData.m_135353_(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> HAS_LICHEN = SynchedEntityData.m_135353_(Stoneling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String TAG_CARRYING_ITEM = "carryingItem";
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_HAS_LICHEN = "has_lichen";
    private static final String TAG_HOLD_ANGLE = "itemAngle";
    private static final String TAG_PLAYER_MADE = "playerMade";
    private ActWaryGoal waryGoal;
    private boolean isTame;

    public Stoneling(EntityType<? extends Stoneling> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.DAMAGE_CACTUS, 1.0f);
        this.m_21441_(BlockPathTypes.DANGER_CACTUS, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CARRYING_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(HOLD_ANGLE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HAS_LICHEN, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.2, 0.98f));
        this.f_21345_.m_25352_(4, (Goal)new FavorBlockGoal((PathfinderMob)this, 0.2, s -> s.m_204336_(Tags.Blocks.ORES_DIAMOND)));
        this.f_21345_.m_25352_(3, (Goal)new IfFlagGoal((Goal)new TemptGoal((PathfinderMob)this, 0.6, Ingredient.m_204132_(this.temptTag()), false), () -> StonelingsModule.enableDiamondHeart && !StonelingsModule.tamableStonelings));
        this.f_21345_.m_25352_(2, new RunAndPoofGoal<Player>(this, Player.class, 4.0f, 0.5, 0.5));
        this.waryGoal = new ActWaryGoal(this, 0.1, 6.0, () -> StonelingsModule.cautiousStonelings);
        this.f_21345_.m_25352_(1, (Goal)this.waryGoal);
        this.f_21345_.m_25352_(0, (Goal)new IfFlagGoal((Goal)new TemptGoal((PathfinderMob)this, 0.6, Ingredient.m_204132_(this.temptTag()), false), () -> StonelingsModule.tamableStonelings));
    }

    private TagKey<Item> temptTag() {
        return ModuleLoader.INSTANCE.isModuleEnabled(GlimmeringWealdModule.class) ? GlimmeringWealdModule.glowShroomFeedablesTag : Tags.Items.GEMS_DIAMOND;
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19793_ = this.f_19798_ ? 1.0f : 0.6f;
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        if (this.isTame) {
            return MobCategory.CREATURE;
        }
        return MobCategory.MONSTER;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isTame;
    }

    public void m_6043_() {
        boolean wasAlive = this.m_6084_();
        super.m_6043_();
        if (!this.m_6084_() && wasAlive) {
            for (Entity passenger : this.m_146897_()) {
                if (passenger instanceof Player) continue;
                passenger.m_146870_();
            }
        }
    }

    @Nonnull
    public InteractionResult m_6071_(Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42656_) {
            return stack.m_41720_().m_6880_(stack, player, (LivingEntity)this, hand);
        }
        return super.m_6071_(player, hand);
    }

    @Nonnull
    public InteractionResult m_7111_(@Nonnull Player player, @Nonnull Vec3 vec, @Nonnull InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.m_6084_()) {
            ItemStack playerItem = player.m_21120_(hand);
            Vec3 pos = this.m_20182_();
            if (!this.f_19853_.f_46443_) {
                if (this.isPlayerMade()) {
                    if (!player.m_20163_() && !playerItem.m_41619_()) {
                        StonelingVariant currentVariant = this.getVariant();
                        StonelingVariant targetVariant = null;
                        Block targetBlock = null;
                        block0: for (StonelingVariant variant : StonelingVariant.values()) {
                            for (Block block : variant.getBlocks()) {
                                if (block.m_5456_() != playerItem.m_41720_()) continue;
                                targetVariant = variant;
                                targetBlock = block;
                                break block0;
                            }
                        }
                        if (targetVariant != null) {
                            Level level = this.f_19853_;
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + (double)this.m_20206_(), pos.f_82481_, 1, 0.1, 0.1, 0.1, 0.1);
                                if (targetVariant != currentVariant) {
                                    serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, targetBlock.m_49966_()), pos.f_82479_, pos.f_82480_ + (double)(this.m_20206_() / 2.0f), pos.f_82481_, 16, 0.1, 0.1, 0.1, 0.25);
                                }
                            }
                            if (targetVariant != currentVariant) {
                                this.m_5496_(QuarkSounds.ENTITY_STONELING_EAT, 1.0f, 1.0f);
                                this.f_19804_.m_135381_(VARIANT, (Object)targetVariant.getIndex());
                            }
                            this.m_5496_(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + this.f_19853_.f_46441_.nextFloat());
                            this.m_5634_(1.0f);
                            if (!player.m_150110_().f_35937_) {
                                playerItem.m_41774_(1);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.PASS;
                    }
                    ItemStack stonelingItem = (ItemStack)this.f_19804_.m_135370_(CARRYING_ITEM);
                    if (!stonelingItem.m_41619_() || !playerItem.m_41619_()) {
                        player.m_21008_(hand, stonelingItem.m_41777_());
                        this.f_19804_.m_135381_(CARRYING_ITEM, (Object)playerItem.m_41777_());
                        if (playerItem.m_41619_()) {
                            this.m_5496_(QuarkSounds.ENTITY_STONELING_GIVE, 1.0f, 1.0f);
                        } else {
                            this.m_5496_(QuarkSounds.ENTITY_STONELING_TAKE, 1.0f, 1.0f);
                        }
                    }
                } else if (StonelingsModule.tamableStonelings && playerItem.m_204117_(this.temptTag())) {
                    this.m_5634_(8.0f);
                    this.setPlayerMade(true);
                    this.m_5496_(QuarkSounds.ENTITY_STONELING_PURR, 1.0f, 1.0f + this.f_19853_.f_46441_.nextFloat());
                    if (!player.m_150110_().f_35937_) {
                        playerItem.m_41774_(1);
                    }
                    if (this.f_19853_ instanceof ServerLevel) {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + (double)this.m_20206_(), pos.f_82481_, 4, 0.1, 0.1, 0.1, 0.1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType spawnReason, @Nullable SpawnGroupData data, @Nullable CompoundTag compound) {
        List items;
        byte variant;
        Random rand = world.m_5822_();
        if (data instanceof StonelingVariant) {
            StonelingVariant stonelingVariant = (StonelingVariant)data;
            variant = stonelingVariant.getIndex();
        } else {
            variant = (byte)rand.nextInt(StonelingVariant.values().length);
        }
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(HAS_LICHEN, (Object)(world.m_204166_(this.m_20097_()).m_203373_(GlimmeringWealdModule.BIOME_NAME) && rand.nextInt(5) < 3 ? 1 : 0));
        this.f_19804_.m_135381_(HOLD_ANGLE, (Object)Float.valueOf(world.m_5822_().nextFloat() * 90.0f - 45.0f));
        if (!(this.isTame || world.m_5776_() || (items = world.m_142572_().m_129898_().m_79217_(CARRY_LOOT_TABLE).m_79129_(new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78975_(LootContextParamSets.f_81411_))).isEmpty())) {
            this.f_19804_.m_135381_(CARRYING_ITEM, (Object)((ItemStack)items.get(0)));
        }
        return super.m_6518_(world, difficulty, spawnReason, data, compound);
    }

    public boolean m_6673_(@Nonnull DamageSource source) {
        return source == DamageSource.f_19314_ || Stoneling.isProjectileWithoutPiercing(source) || super.m_6673_(source);
    }

    private static boolean isProjectileWithoutPiercing(DamageSource source) {
        if (!source.m_19360_()) {
            return false;
        }
        Entity sourceEntity = source.m_7640_();
        if (sourceEntity instanceof Pickarang) {
            Pickarang pickarang = (Pickarang)sourceEntity;
            return pickarang.getPiercingModifier() <= 0;
        }
        if (sourceEntity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)sourceEntity;
            return arrow.m_36796_() <= 0;
        }
        return true;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader worldReader) {
        return worldReader.m_5450_((Entity)this, Shapes.m_83064_((AABB)this.m_142469_()));
    }

    public double m_6048_() {
        return this.m_20206_();
    }

    public boolean m_6063_() {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_142535_(float distance, float damageMultiplier, @Nonnull DamageSource source) {
        return false;
    }

    protected void m_6475_(@Nonnull DamageSource damageSrc, float damageAmount) {
        super.m_6475_(damageSrc, damageAmount);
        if (!this.isPlayerMade() && damageSrc.m_7639_() instanceof Player) {
            this.startle();
            for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82400_(16.0))) {
                Stoneling stoneling;
                if (!(entity instanceof Stoneling) || (stoneling = (Stoneling)entity).isPlayerMade() || !stoneling.m_21574_().m_148306_((Entity)this)) continue;
                this.startle();
            }
        }
    }

    public boolean isStartled() {
        return this.waryGoal.isStartled();
    }

    public void startle() {
        this.waryGoal.startle();
        HashSet entries = Sets.newHashSet((Iterable)this.f_21345_.m_148105_());
        for (WrappedGoal task : entries) {
            if (!(task.m_26015_() instanceof TemptGoal)) continue;
            this.f_21345_.m_25363_(task.m_26015_());
        }
    }

    protected void m_7472_(@Nonnull DamageSource damage, int looting, boolean wasRecentlyHit) {
        super.m_7472_(damage, looting, wasRecentlyHit);
        ItemStack stack = this.getCarryingItem();
        if (!stack.m_41619_()) {
            this.m_5552_(stack, 0.0f);
        }
    }

    public void setPlayerMade(boolean value) {
        this.isTame = value;
    }

    public ItemStack getCarryingItem() {
        return (ItemStack)this.f_19804_.m_135370_(CARRYING_ITEM);
    }

    public StonelingVariant getVariant() {
        return StonelingVariant.byIndex((Byte)this.f_19804_.m_135370_(VARIANT));
    }

    public float getItemAngle() {
        return ((Float)this.f_19804_.m_135370_(HOLD_ANGLE)).floatValue();
    }

    public boolean isPlayerMade() {
        return this.isTame;
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(TAG_CARRYING_ITEM, 10)) {
            CompoundTag itemCmp = compound.m_128469_(TAG_CARRYING_ITEM);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemCmp);
            this.f_19804_.m_135381_(CARRYING_ITEM, (Object)stack);
        }
        this.f_19804_.m_135381_(VARIANT, (Object)compound.m_128445_(TAG_VARIANT));
        this.f_19804_.m_135381_(HOLD_ANGLE, (Object)Float.valueOf(compound.m_128457_(TAG_HOLD_ANGLE)));
        this.f_19804_.m_135381_(HAS_LICHEN, (Object)compound.m_128471_(TAG_HAS_LICHEN));
        this.setPlayerMade(compound.m_128471_(TAG_PLAYER_MADE));
    }

    public boolean m_142582_(Entity entityIn) {
        Vec3 pos = this.m_20182_();
        Vec3 epos = entityIn.m_20182_();
        Vec3 origin = new Vec3(pos.f_82479_, pos.f_82480_ + (double)this.m_20192_(), pos.f_82481_);
        float otherEyes = entityIn.m_20192_();
        for (float height = 0.0f; height <= otherEyes; height += otherEyes / 8.0f) {
            if (this.f_19853_.m_45547_(new ClipContext(origin, epos.m_82520_(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() != HitResult.Type.MISS) continue;
            return true;
        }
        return false;
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_(TAG_CARRYING_ITEM, (Tag)this.getCarryingItem().serializeNBT());
        compound.m_128344_(TAG_VARIANT, this.getVariant().getIndex());
        compound.m_128350_(TAG_HOLD_ANGLE, this.getItemAngle());
        compound.m_128379_(TAG_PLAYER_MADE, this.isPlayerMade());
        compound.m_128379_(TAG_HAS_LICHEN, ((Boolean)this.f_19804_.m_135370_(HAS_LICHEN)).booleanValue());
    }

    public static boolean spawnPredicate(EntityType<? extends Stoneling> type, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        return pos.m_123342_() <= StonelingsModule.maxYLevel && (MiscUtil.validSpawnLight(world, pos, rand) || world.m_204166_(pos).m_203373_(GlimmeringWealdModule.BIOME_NAME)) && MiscUtil.validSpawnLocation(type, (LevelAccessor)world, reason, pos);
    }

    public boolean m_5545_(@Nonnull LevelAccessor world, @Nonnull MobSpawnType reason) {
        BlockState state = world.m_8055_(new BlockPos(this.m_20182_()).m_7495_());
        if (state.m_60767_() != Material.f_76278_) {
            return false;
        }
        return StonelingsModule.dimensions.canSpawnHere(world) && super.m_5545_(world, reason);
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_STONELING_CRY;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_STONELING_DIE;
    }

    public int m_8100_() {
        return 1200;
    }

    public void m_8032_() {
        SoundEvent sound = this.m_7515_();
        if (sound != null) {
            this.m_5496_(sound, this.m_6121_(), 1.0f);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        String customName;
        if (this.m_8077_() && ((customName = this.m_7755_().getString()).equalsIgnoreCase("michael stevens") || customName.equalsIgnoreCase("vsauce"))) {
            return QuarkSounds.ENTITY_STONELING_MICHAEL;
        }
        return null;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float m_5610_(@Nonnull BlockPos pos, LevelReader world) {
        return 0.5f - world.m_46863_(pos);
    }

    public static enum StonelingVariant implements SpawnGroupData
    {
        STONE("stone", Blocks.f_50652_, Blocks.f_50069_),
        ANDESITE("andesite", Blocks.f_50334_, Blocks.f_50387_),
        DIORITE("diorite", Blocks.f_50228_, Blocks.f_50281_),
        GRANITE("granite", Blocks.f_50122_, Blocks.f_50175_),
        LIMESTONE("limestone", NewStoneTypesModule.limestoneBlock, NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.limestoneBlock)),
        CALCITE("calcite", Blocks.f_152497_),
        SHALE("shale", NewStoneTypesModule.shaleBlock, NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.shaleBlock)),
        JASPER("jasper", NewStoneTypesModule.jasperBlock, NewStoneTypesModule.polishedBlocks.get(NewStoneTypesModule.jasperBlock)),
        DEEPSLATE("deepslate", Blocks.f_152550_, Blocks.f_152555_),
        TUFF("tuff", Blocks.f_152496_, NewStoneTypesModule.polishedBlocks.get(Blocks.f_152496_)),
        DRIPSTONE("dripstone", Blocks.f_152537_, NewStoneTypesModule.polishedBlocks.get(Blocks.f_152537_));

        private final ResourceLocation texture;
        private final List<Block> blocks;

        private StonelingVariant(String variantPath, Block ... blocks) {
            this.texture = new ResourceLocation("quark", "textures/model/entity/stoneling/" + variantPath + ".png");
            this.blocks = Lists.newArrayList((Object[])blocks);
        }

        public static StonelingVariant byIndex(byte index) {
            StonelingVariant[] values = StonelingVariant.values();
            return values[Mth.m_14045_((int)index, (int)0, (int)(values.length - 1))];
        }

        public byte getIndex() {
            return (byte)this.ordinal();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }
    }
}

