/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.ConnectorBlock;
import com.mrh0.createaddition.blocks.connector.ConnectorMode;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.debug.IDebugDrawer;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.network.RemoveConnectorPacket;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ConnectorTileEntity
extends BaseElectricTileEntity
implements IWireNode,
IObserveTileEntity,
IHaveGoggleInformation,
IDebugDrawer {
    private BlockPos[] connectionPos = new BlockPos[this.getNodeCount()];
    private int[] connectionIndecies = new int[this.getNodeCount()];
    private WireType[] connectionTypes = new WireType[this.getNodeCount()];
    public IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    public static Vec3 OFFSET_DOWN = new Vec3(0.0, -0.1875, 0.0);
    public static Vec3 OFFSET_UP = new Vec3(0.0, 0.1875, 0.0);
    public static Vec3 OFFSET_NORTH = new Vec3(0.0, 0.0, -0.1875);
    public static Vec3 OFFSET_WEST = new Vec3(-0.1875, 0.0, 0.0);
    public static Vec3 OFFSET_SOUTH = new Vec3(0.0, 0.0, 0.1875);
    public static Vec3 OFFSET_EAST = new Vec3(0.1875, 0.0, 0.0);
    public static final int NODE_COUNT = 4;
    public static final int CAPACITY = (Integer)Config.CONNECTOR_CAPACITY.get();
    public static final int MAX_IN = (Integer)Config.CONNECTOR_MAX_INPUT.get();
    public static final int MAX_OUT = (Integer)Config.CONNECTOR_MAX_OUTPUT.get();
    private EnergyNetwork network;
    private int demand = 0;

    public ConnectorTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, MAX_OUT);
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.f_58857_, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        switch ((Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING)) {
            case DOWN: {
                return OFFSET_DOWN;
            }
            case UP: {
                return OFFSET_UP;
            }
            case NORTH: {
                return OFFSET_NORTH;
            }
            case WEST: {
                return OFFSET_WEST;
            }
            case SOUTH: {
                return OFFSET_SOUTH;
            }
            case EAST: {
                return OFFSET_EAST;
            }
        }
        return OFFSET_DOWN;
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return this.m_58900_().m_61143_((Property)ConnectorBlock.FACING) == side;
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return this.m_58900_().m_61143_((Property)ConnectorBlock.FACING) == side;
    }

    @Override
    public int getNodeCount() {
        return 4;
    }

    @Override
    public int getNodeFromPos(Vec3 vector3d) {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BlockPos getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndecies[node];
    }

    @Override
    public void setNode(int node, int other, BlockPos pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndecies[node] = other;
        this.connectionTypes[node] = type;
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.m_6596_();
        if (this.network != null) {
            this.network.invalidate();
        }
    }

    @Override
    public BlockPos getMyPos() {
        return this.f_58858_;
    }

    public void onBlockRemoved() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            IWireNode node;
            if (this.getNodeType(i) == null || (node = this.getNode(i)) == null) continue;
            int other = this.getOtherNodeIndex(i);
            node.removeNode(other);
            node.invalidateNodeCache();
            RemoveConnectorPacket.send(node.getMyPos(), other, this.f_58857_);
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.network != null) {
            this.network.invalidate();
        }
        this.m_7651_();
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    @Override
    public void tick() {
        if (this.getMode() == ConnectorMode.None) {
            return;
        }
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.awakeNetwork(this.f_58857_)) {
            this.causeBlockUpdate();
        }
        this.networkTick(this.network);
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.network;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        this.network = network;
    }

    private void networkTick(EnergyNetwork network) {
        ConnectorMode mode = this.getMode();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        Direction d = (Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING);
        IEnergyStorage ies = (IEnergyStorage)this.getCachedEnergy(d).orElse(null);
        if (ies == null) {
            return;
        }
        if (mode == ConnectorMode.Push || mode == ConnectorMode.Passive) {
            int pull = network.pull(this.demand);
            ies.receiveEnergy(pull, false);
            int testInsert = ies.receiveEnergy(MAX_OUT, true);
            this.demand = network.demand(testInsert);
        }
        if (mode == ConnectorMode.Pull) {
            int extracted = ies.extractEnergy(this.localEnergy.getSpace(), false);
            this.localEnergy.internalProduceEnergy(extracted);
        }
        if (mode == ConnectorMode.Pull || mode == ConnectorMode.Passive) {
            int testExtract = this.localEnergy.extractEnergy(Integer.MAX_VALUE, true);
            int push = network.push(testExtract);
            this.localEnergy.internalConsumeEnergy(push);
        }
    }

    public ConnectorMode getMode() {
        return (ConnectorMode)((Object)this.m_58900_().m_61143_(ConnectorBlock.MODE));
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.f_58858_, this.getNetwork(0).getPulled(), this.getNetwork(0).getPushed(), player);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.connector.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.mode").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TextComponent(" ")).m_7220_((Component)((ConnectorMode)((Object)this.m_58900_().m_61143_(ConnectorBlock.MODE))).getTooltip().m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_130946_(" ").m_130946_(Util.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe/t").m_130940_(ChatFormatting.AQUA));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    @Override
    public boolean ignoreCapSide() {
        return ((ConnectorMode)((Object)this.m_58900_().m_61143_(ConnectorBlock.MODE))).isActive();
    }

    @Override
    public void drawDebug() {
        VoxelShape shape;
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            BlockPos pos = this.connectionPos[i];
            if (pos == null) continue;
            shape = this.f_58857_.m_8055_(pos).m_60816_((BlockGetter)this.f_58857_, pos);
            CreateClient.OUTLINER.chaseAABB((Object)("ca_nodes_" + i), shape.m_83215_().m_82338_(pos)).lineWidth(0.0625f).colored(0xFF5B5B);
        }
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_((Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING)));
        LazyOptional cap = te.getCapability(CapabilityEnergy.ENERGY, ((Direction)this.m_58900_().m_61143_((Property)ConnectorBlock.FACING)).m_122424_());
        if (this.ignoreCapSide() && !cap.isPresent()) {
            cap = te.getCapability(CapabilityEnergy.ENERGY);
        }
        if (te == null || !cap.isPresent()) {
            return;
        }
        shape = this.f_58857_.m_8055_(te.m_58899_()).m_60816_((BlockGetter)this.f_58857_, te.m_58899_());
        CreateClient.OUTLINER.chaseAABB((Object)"ca_output", shape.m_83215_().m_82338_(te.m_58899_())).lineWidth(0.0625f).colored(0x5B5BFF);
    }
}

