/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing.blockentity;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.AbstractInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityInstance<T extends BlockEntity>
extends AbstractInstance {
    protected final T blockEntity;
    protected final BlockPos pos;
    protected final BlockPos instancePos;
    protected final BlockState blockState;

    public BlockEntityInstance(MaterialManager materialManager, T blockEntity) {
        super(materialManager, blockEntity.m_58904_());
        this.blockEntity = blockEntity;
        this.pos = blockEntity.m_58899_();
        this.blockState = blockEntity.m_58900_();
        this.instancePos = this.pos.m_141950_(materialManager.getOriginCoordinate());
    }

    @Override
    public boolean shouldReset() {
        return this.blockEntity.m_58900_() != this.blockState;
    }

    public BlockPos getInstancePosition() {
        return this.pos.m_141950_(this.materialManager.getOriginCoordinate());
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.pos;
    }

    protected Material<ModelData> getTransformMaterial() {
        return this.materialManager.defaultCutout().material(Materials.TRANSFORMED);
    }

    protected Material<OrientedData> getOrientedMaterial() {
        return this.materialManager.defaultCutout().material(Materials.ORIENTED);
    }

    @Override
    public ImmutableBox getVolume() {
        return GridAlignedBB.from(this.pos);
    }
}

