/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.virtual;

import com.jozufozu.flywheel.api.FlywheelWorld;
import com.jozufozu.flywheel.core.virtual.VirtualChunkSource;
import com.jozufozu.flywheel.core.virtual.VirtualLevelEntityGetter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;

public class VirtualRenderWorld
extends Level
implements FlywheelWorld {
    public final Map<BlockPos, BlockState> blocksAdded = new HashMap<BlockPos, BlockState>();
    public final Map<BlockPos, BlockEntity> besAdded = new HashMap<BlockPos, BlockEntity>();
    public final Set<SectionPos> spannedSections = new HashSet<SectionPos>();
    private final BlockPos.MutableBlockPos scratch = new BlockPos.MutableBlockPos();
    protected final Level level;
    protected final LevelLightEngine lighter;
    protected final VirtualChunkSource chunkSource;
    protected final LevelEntityGetter<Entity> entityGetter = new VirtualLevelEntityGetter<Entity>();
    protected final int height;
    protected final int minBuildHeight;
    protected final Vec3i biomeOffset;

    public VirtualRenderWorld(Level level) {
        this(level, Vec3i.f_123288_, level.m_141928_(), level.m_141937_());
    }

    public VirtualRenderWorld(Level level, Vec3i biomeOffset) {
        this(level, biomeOffset, level.m_141928_(), level.m_141937_());
    }

    public VirtualRenderWorld(Level level, Vec3i biomeOffset, int height, int minBuildHeight) {
        super((WritableLevelData)level.m_6106_(), level.m_46472_(), level.m_204156_(), () -> ((Level)level).m_46473_(), true, false, 0L);
        this.biomeOffset = biomeOffset;
        this.level = level;
        this.height = VirtualRenderWorld.nextMultipleOf16(height);
        this.minBuildHeight = VirtualRenderWorld.nextMultipleOf16(minBuildHeight);
        this.chunkSource = new VirtualChunkSource(this);
        this.lighter = new LevelLightEngine((LightChunkGetter)this.chunkSource, true, false);
    }

    public static int nextMultipleOf16(int a) {
        if (a < 0) {
            return -((Math.abs(a) - 1 | 0xF) + 1);
        }
        return (a - 1 | 0xF) + 1;
    }

    public void runLightingEngine() {
        for (Map.Entry<BlockPos, BlockState> entry : this.blocksAdded.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue();
            int light = state.getLightEmission((BlockGetter)this, pos);
            if (light <= 0) continue;
            this.lighter.m_142519_(pos, light);
        }
        this.lighter.m_142528_(Integer.MAX_VALUE, false, false);
    }

    public void setBlockEntities(Collection<BlockEntity> blockEntities) {
        this.besAdded.clear();
        blockEntities.forEach(be -> this.besAdded.put(be.m_58899_(), (BlockEntity)be));
    }

    public void clear() {
        this.blocksAdded.clear();
    }

    public boolean m_7731_(BlockPos pos, BlockState newState, int flags) {
        this.blocksAdded.put(pos, newState);
        SectionPos sectionPos = SectionPos.m_123199_((BlockPos)pos);
        if (this.spannedSections.add(sectionPos)) {
            this.lighter.m_6191_(sectionPos, false);
        }
        if ((flags & 0x80) == 0) {
            this.lighter.m_142202_(pos);
        }
        return true;
    }

    public int m_141928_() {
        return this.height;
    }

    public int m_141937_() {
        return this.minBuildHeight;
    }

    public ChunkSource m_7726_() {
        return this.chunkSource;
    }

    public LevelLightEngine m_5518_() {
        return this.lighter;
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return this.entityGetter;
    }

    public BlockState m_8055_(@Nullable BlockPos pos) {
        BlockState state = this.blocksAdded.get(pos);
        if (state != null) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_46597_(BlockPos pos, BlockState state) {
        return this.m_7731_(pos, state, 0);
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return this.besAdded.get(pos);
    }

    public boolean m_7433_(BlockPos pos, Predicate<BlockState> condition) {
        return condition.test(this.m_8055_(pos));
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.m_8055_((BlockPos)this.scratch.m_122178_(x, y, z));
    }

    public Holder<Biome> m_204166_(BlockPos pPos) {
        return super.m_204166_(pPos.m_141952_(this.biomeOffset));
    }

    public Holder<Biome> m_203675_(int pX, int pY, int pZ) {
        return this.level.m_203675_(pX + this.biomeOffset.m_123341_(), pY + this.biomeOffset.m_123342_(), pZ + this.biomeOffset.m_123343_());
    }

    public Holder<Biome> m_203495_(int pX, int pY, int pZ) {
        return this.level.m_203495_(pX + this.biomeOffset.m_123341_(), pY + this.biomeOffset.m_123342_(), pZ + this.biomeOffset.m_123343_());
    }

    public int m_46803_(BlockPos pos) {
        return 15;
    }

    public float m_7717_(Direction p_230487_1_, boolean p_230487_2_) {
        return 1.0f;
    }

    public BiomeManager m_7062_() {
        return this.level.m_7062_();
    }

    public RegistryAccess m_5962_() {
        return this.level.m_5962_();
    }

    public LevelTickAccess<Block> m_183326_() {
        return this.level.m_183326_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return this.level.m_183324_();
    }

    public RecipeManager m_7465_() {
        return this.level.m_7465_();
    }

    public int m_7354_() {
        return this.level.m_7354_();
    }

    public Scoreboard m_6188_() {
        return this.level.m_6188_();
    }

    @Nullable
    public Entity m_6815_(int id) {
        return null;
    }

    @Nullable
    public MapItemSavedData m_7489_(String mapName) {
        return null;
    }

    public boolean m_46749_(BlockPos pos) {
        return true;
    }

    public boolean isAreaLoaded(BlockPos center, int range) {
        return true;
    }

    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    public String m_46464_() {
        return "";
    }

    public void m_5898_(@Nullable Player player, int type, BlockPos pos, int data) {
    }

    public void m_6263_(@Nullable Player player, double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
    }

    public void m_6269_(@Nullable Player p_217384_1_, Entity p_217384_2_, SoundEvent p_217384_3_, SoundSource p_217384_4_, float p_217384_5_, float p_217384_6_) {
    }

    public void m_142325_(String pMapId, MapItemSavedData pData) {
    }

    public void m_6801_(int breakerId, BlockPos pos, int progress) {
    }

    public void m_46717_(BlockPos p_175666_1_, Block p_175666_2_) {
    }

    public void m_142346_(@Nullable Entity pEntity, GameEvent pEvent, BlockPos pPos) {
    }

    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public LevelChunk getChunkAtImmediately(int chunkX, int chunkZ) {
        return this.chunkSource.m_62227_(chunkX, chunkZ, false);
    }

    public ChunkAccess getAnyChunkImmediately(int chunkX, int chunkZ) {
        return this.chunkSource.getChunk(chunkX, chunkZ);
    }

    public int m_151558_() {
        return this.m_141937_() + this.m_141928_();
    }

    public int m_151559_() {
        return this.m_151561_() - this.m_151560_();
    }

    public int m_151560_() {
        return SectionPos.m_123171_((int)this.m_141937_());
    }

    public int m_151561_() {
        return SectionPos.m_123171_((int)(this.m_151558_() - 1)) + 1;
    }

    public boolean m_151570_(BlockPos pos) {
        return this.m_151562_(pos.m_123342_());
    }

    public boolean m_151562_(int y) {
        return y < this.m_141937_() || y >= this.m_151558_();
    }

    public int m_151564_(int y) {
        return this.m_151566_(SectionPos.m_123171_((int)y));
    }

    public int m_151566_(int sectionY) {
        return sectionY - this.m_151560_();
    }

    public int m_151568_(int sectionIndex) {
        return sectionIndex + this.m_151560_();
    }
}

