/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class Generator {
    public static int spiral(Level world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int count = 0;
        int halfChunk = 7;
        int startX = bounds.getX().getMin() + 7;
        int startZ = bounds.getZ().getMin() + 7;
        BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)new BlockPos(startX, 0, startZ));
        int startY = pollutant.getConcentrationAltitudeIn(biome);
        BlockPos startPos = new BlockPos(startX, startY, startZ);
        int maxLength = 15;
        int offsetY = 0;
        block0: while (true) {
            BlockPos[] blockPosArray = new BlockPos[]{startPos.m_6630_(offsetY), startPos.m_6625_(offsetY)};
            int n = blockPosArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                BlockPos pos = blockPosArray[n2];
                if (count >= amount || world.m_151570_(pos)) {
                    return count;
                }
                boolean pumped = false;
                if (pollutant.pump((LevelAccessor)world, pos)) {
                    pumped = true;
                    ++count;
                }
                int length = 1;
                int turnsCount = 0;
                block2: while (true) {
                    Direction[] directionArray = GameWorld.Directions.CLOCKWISE_HORIZONTALS;
                    int n3 = directionArray.length;
                    int n4 = 0;
                    while (true) {
                        if (n4 >= n3) continue block2;
                        Direction facing = directionArray[n4];
                        if (length > 15) break block2;
                        for (int n5 = 1; n5 <= length; ++n5) {
                            if (count >= amount) {
                                return count;
                            }
                            if (!pollutant.pump((LevelAccessor)world, pos = pos.m_142300_(facing))) continue;
                            pumped = true;
                            ++count;
                        }
                        if (length < 15 && ++turnsCount > 1 || turnsCount > 2) {
                            ++length;
                            turnsCount = 0;
                        }
                        ++n4;
                    }
                    break;
                }
                if (!pumped) {
                    ++offsetY;
                }
                ++n2;
            }
            break;
        }
    }

    public static int generate(Level world, WorldBounds bounds, Pollutant<?> pollutant, int amount) {
        return Generator.spots(world, bounds, pollutant, amount);
    }

    public static int spots(Level world, WorldBounds bounds, Pollutant<?> pollutant, int amount) {
        int count;
        int lastgen;
        for (count = 0; count < amount; count += lastgen) {
            BlockPos startPos = new BlockPos(bounds.getX().randomBetween().intValue(), 0, bounds.getZ().randomBetween().intValue());
            startPos = startPos.m_142082_(0, pollutant.getConcentrationAltitudeIn(BiomeId.from((LevelAccessor)world, (BlockPos)startPos)), 0);
            int remains = amount - count;
            int generate = (int)CommonMath.Random.between((float)1.0f, (float)Mth.m_14116_((float)amount));
            if (generate > remains) {
                generate = remains;
            }
            lastgen = pollutant.generateAt(world, startPos, generate, 16);
            if (lastgen != 0) continue;
            break;
        }
        return count;
    }

    protected static boolean inPyramidBounds(ChunkBounds bounds, BlockPos pos, int startY) {
        int dx = Math.min(Math.abs(bounds.getX().getMin() - pos.m_123341_()), Math.abs(bounds.getX().getMax() - pos.m_123341_()));
        int dz = Math.min(Math.abs(bounds.getZ().getMin() - pos.m_123343_()), Math.abs(bounds.getZ().getMax() - pos.m_123343_()));
        int dy = Math.abs(pos.m_123342_() - startY);
        return bounds.encloses(pos) && dy <= dx && dy <= dz;
    }

    public static int random(Level world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int count = 0;
        block0: while (count < amount) {
            int x = bounds.getX().randomBetween();
            int z = bounds.getY().randomBetween();
            BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)new BlockPos(x, 0, z));
            int startY = pollutant.getConcentrationAltitudeIn(biome);
            for (int offsetY = 0; offsetY <= startY; ++offsetY) {
                for (int k : new int[]{-1, 1}) {
                    BlockPos pos = new BlockPos(x, startY + k * offsetY, z);
                    if (!bounds.encloses(pos)) continue;
                    int pumped = pollutant.pump((LevelAccessor)world, pos, amount - count);
                    count += pumped;
                    if (pumped > 0) continue block0;
                }
            }
        }
        return count;
    }

    public static int randomAfterSpiral(Level world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int pumpsCount = 0;
        int randomMax = 64;
        if (amount > 64) {
            pumpsCount = Generator.spiral(world, bounds, pollutant, amount - 64);
        }
        int remain = amount - pumpsCount;
        return pumpsCount += Generator.random(world, bounds, pollutant, remain);
    }

    public static int randomAndSpots(Level world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int randomMax = 256;
        int pumpsCount = Generator.random(world, bounds, pollutant, Math.min(amount, 256));
        int remain = amount - pumpsCount;
        return pumpsCount += Generator.spots(world, (WorldBounds)bounds, pollutant, remain);
    }
}

