/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IStorageItem
extends IStorage<ItemStack> {
    @Override
    default public IStorage.Content getContent(ItemStack storage) {
        CompoundTag compound = storage.m_41783_();
        if (compound != null) {
            return IStorage.Content.from(compound);
        }
        return new IStorage.Content(0);
    }

    @Override
    default public void onContentChanged(IStorage.Content content, ItemStack storage) {
        CompoundTag compound = storage.m_41784_();
        content.writeToNBT(compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void appendHoverText(ItemStack stack, Level world, List<Component> lines, TooltipFlag flag) {
        IStorage.Content content = this.getContent(stack);
        Tooltip tip = Tooltip.of((AbstractForgeMod)AdPother.getInstance(), (String)"storage_item", lines);
        tip.add(ChatFormatting.WHITE, "contents");
        AdPother.getInstance().pollutants.streamAll().filter(content::hasFilterFor).forEach(pollutant -> {
            Percentage fullness = content.getFullnessPercentageFor((Pollutant<?>)((Object)pollutant));
            tip.addRaw(pollutant.getTextColor() + pollutant.m_49954_().getString() + ": " + fullness.toColoredText());
        });
        if (ForgeEndertech.isDebugMode()) {
            tip.add(ChatFormatting.WHITE, "capacity", (Object)content.getCapacity());
        }
    }
}

