/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntityRenderer;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.screen.ChunkLoaderScreen;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChunkLoadersClient {
    private static KeyMapping CHUNK_LOADING_SCREEN_KEY;

    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerCustomBlockEntityRenderer(type::getBlockEntityType, () -> new ChunkLoaderBlockEntityRenderer((Block)type.getBlock(), type.getFullRotation()));
        }
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        CHUNK_LOADING_SCREEN_KEY = new KeyMapping("chunkloaders.keys.open_screen", 67, "chunkloaders.keys.category");
        ClientRegistry.registerKeyBinding((KeyMapping)CHUNK_LOADING_SCREEN_KEY);
        MinecraftForge.EVENT_BUS.addListener(ChunkLoadersClient::onKey);
    }

    public static void onKey(InputEvent.KeyInputEvent e) {
        if (CHUNK_LOADING_SCREEN_KEY != null && CHUNK_LOADING_SCREEN_KEY.m_90832_(e.getKey(), e.getScanCode()) && ClientUtils.getWorld() != null && ClientUtils.getMinecraft().f_91080_ == null) {
            Player player = ClientUtils.getPlayer();
            if (ChunkLoadersConfig.canPlayersUseMap.get().booleanValue()) {
                ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(player.m_142538_()), player.m_142081_(), player.m_142538_().m_123342_(), 15, 11)));
            } else {
                player.m_5661_((Component)TextComponents.translation((String)"chunkloaders.gui.disabled").color(ChatFormatting.RED).get(), true);
            }
        }
    }

    public static void openChunkLoaderScreen(ChunkLoaderBlockEntity entity) {
        int size = entity.getChunkLoaderType().getGridSize() + 2;
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(entity.m_58899_()), entity.getOwner(), entity.m_58899_().m_123342_(), size, size)));
    }
}

