/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.VerticalSlabBlock;
import com.github.talrey.createdeco.registry.BrickBuilders;
import com.github.talrey.createdeco.registry.DecoCreativeModeTab;
import com.github.talrey.createdeco.registry.MetalDecoBuilders;
import com.github.talrey.createdeco.registry.Props;
import com.github.talrey.createdeco.registry.SheetMetal;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;

public class Registration {
    private static HashMap<DyeColor, String> BRICK_COLOR_NAMES = new HashMap();
    private static HashMap<String, Function<String, Item>> DOOR_TYPES = new HashMap();
    public static HashMap<String, Function<String, Item>> METAL_TYPES = new HashMap();
    public static ItemEntry<Item> WORN_BRICK_ITEM;
    public static HashMap<String, BlockEntry<Block>> WORN_BRICK_TYPES;
    public static HashMap<String, BlockEntry<StairBlock>> WORN_STAIRS;
    public static HashMap<String, BlockEntry<SlabBlock>> WORN_SLABS;
    public static HashMap<String, BlockEntry<VerticalSlabBlock>> WORN_VERTS;
    public static HashMap<String, BlockEntry<WallBlock>> WORN_WALLS;
    public static HashMap<DyeColor, BlockEntry<Block>> BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> TILE_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> LONG_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> SHORT_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_TILE_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_LONG_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> CRACKED_SHORT_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_BRICK_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_TILE_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_LONG_BLOCK;
    public static HashMap<DyeColor, BlockEntry<Block>> MOSSY_SHORT_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<StairBlock>>> BRICK_STAIRS_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<SlabBlock>>> BRICK_SLAB_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<VerticalSlabBlock>>> BRICK_VERT_BLOCK;
    public static HashMap<DyeColor, HashMap<String, BlockEntry<WallBlock>>> BRICK_WALL_BLOCK;
    public static HashMap<String, BlockEntry<DoorBlock>> DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<DoorBlock>> LOCK_DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<IronBarsBlock>> BAR_BLOCKS;
    public static HashMap<String, BlockEntry<IronBarsBlock>> BAR_PANEL_BLOCKS;
    public static HashMap<String, BlockEntry<FenceBlock>> MESH_FENCE_BLOCKS;
    public static HashMap<String, BlockEntry<CatwalkBlock>> CATWALK_BLOCKS;
    public static HashMap<DyeColor, ItemEntry<Item>> BRICK_ITEM;
    public static ItemEntry<Item> ZINC_SHEET;
    public static ItemEntry<Item> NETHERITE_SHEET;
    public static ItemEntry<Item> NETHERITE_NUGGET;
    public static ItemEntry<Item> CAST_IRON_NUGGET;
    public static ItemEntry<Item> CAST_IRON_INGOT;
    public static ItemEntry<Item> CAST_IRON_SHEET;
    public static BlockEntry<Block> CAST_IRON_BLOCK;

    public Registration() {
        BRICK_COLOR_NAMES.put(DyeColor.BLACK, "Dusk");
        BRICK_COLOR_NAMES.put(DyeColor.LIGHT_GRAY, "Pearl");
        BRICK_COLOR_NAMES.put(DyeColor.RED, "Scarlet");
        BRICK_COLOR_NAMES.put(DyeColor.YELLOW, "Dean");
        BRICK_COLOR_NAMES.put(DyeColor.LIGHT_BLUE, "Blue");
        BRICK_COLOR_NAMES.put(null, "Red");
        DOOR_TYPES.put("Andesite", str -> (Item)AllItems.ANDESITE_ALLOY.get());
        DOOR_TYPES.put("Copper", str -> Items.f_151052_);
        DOOR_TYPES.put("Zinc", str -> (Item)AllItems.ZINC_INGOT.get());
        DOOR_TYPES.put("Brass", str -> (Item)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Andesite", str -> (Item)AllItems.ANDESITE_ALLOY.get());
        METAL_TYPES.put("Zinc", str -> (Item)AllItems.ZINC_INGOT.get());
        METAL_TYPES.put("Copper", str -> Items.f_151052_);
        METAL_TYPES.put("Brass", str -> (Item)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Iron", str -> Items.f_42416_);
        METAL_TYPES.put("Gold", str -> Items.f_42417_);
        METAL_TYPES.put("Netherite", str -> Items.f_42418_);
        METAL_TYPES.put("Cast Iron", str -> (Item)CAST_IRON_INGOT.get());
        Props.COIN_TYPES.add("Zinc");
        Props.COIN_TYPES.add("Copper");
        Props.COIN_TYPES.add("Brass");
        Props.COIN_TYPES.add("Iron");
        Props.COIN_TYPES.add("Gold");
        Props.COIN_TYPES.add("Netherite");
        Props.COIN_TYPES.add("Cast Iron");
    }

    public static TagKey<Item> makeItemTag(String path) {
        return ForgeRegistries.ITEMS.tags().createOptionalTagKey(new ResourceLocation("forge", path), Collections.emptySet());
    }

    public static TagKey<Item> makeItemTagWith(String id, String path, Supplier<Item> item) {
        Set include = Collections.emptySet();
        include.add(item);
        return ForgeRegistries.ITEMS.tags().createOptionalTagKey(new ResourceLocation(id, path), include);
    }

    private static BlockEntry<?> getBrickFromName(String overlay, DyeColor dye, String shape) {
        if (overlay.trim().equals("Mossy")) {
            return switch (shape.trim()) {
                case "Brick Tiles" -> MOSSY_TILE_BLOCK.get(dye);
                case "Long Bricks" -> MOSSY_LONG_BLOCK.get(dye);
                case "Short Bricks" -> MOSSY_SHORT_BLOCK.get(dye);
                default -> MOSSY_BRICK_BLOCK.get(dye);
            };
        }
        if (overlay.trim().equals("Cracked")) {
            return switch (shape.trim()) {
                case "Brick Tiles" -> CRACKED_TILE_BLOCK.get(dye);
                case "Long Bricks" -> CRACKED_LONG_BLOCK.get(dye);
                case "Short Bricks" -> CRACKED_SHORT_BLOCK.get(dye);
                default -> CRACKED_BRICK_BLOCK.get(dye);
            };
        }
        return switch (shape.trim()) {
            case "Brick Tiles" -> TILE_BRICK_BLOCK.get(dye);
            case "Long Bricks" -> LONG_BRICK_BLOCK.get(dye);
            case "Short Bricks" -> SHORT_BRICK_BLOCK.get(dye);
            default -> BRICK_BLOCK.get(dye);
        };
    }

    public static String getBrickColorName(DyeColor color) {
        return BRICK_COLOR_NAMES.getOrDefault(color, "");
    }

    public static Item getBrickItemFromColor(DyeColor color) {
        return color != null ? (Item)BRICK_ITEM.get(color).get() : Items.f_42460_;
    }

    public static Block getBrickBlockFromColor(DyeColor color) {
        return color != null ? (Block)BRICK_BLOCK.get(color).get() : Blocks.f_50076_;
    }

    public static Block getBrickStairBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.f_50193_;
        }
        return (Block)BRICK_STAIRS_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickSlabBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.f_50410_;
        }
        return (Block)BRICK_SLAB_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickWallBlockFromColor(DyeColor color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return Blocks.f_50604_;
        }
        return (Block)BRICK_WALL_BLOCK.get(color).get(suf).get();
    }

    public static Block getBrickVertBlockFromColor(DyeColor color, String suf) {
        return (Block)BRICK_VERT_BLOCK.get(color).get(suf).get();
    }

    public static void registerBlocks(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.BRICKS_GROUP);
        BlockBuilder wornBrick = BrickBuilders.buildBrick(reg, null, "", "Worn", "Bricks").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("bb").m_126130_("bb").m_126127_(Character.valueOf('b'), (ItemLike)WORN_BRICK_ITEM.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)WORN_BRICK_ITEM.get()})).m_176498_((Consumer)prov));
        WORN_BRICK_TYPES.put("Worn Bricks", (BlockEntry<Block>)wornBrick.register());
        String[] prefs = new String[]{"", "Cracked", "Mossy"};
        String[] sufs = new String[]{"Bricks", "Brick Tiles", "Long Bricks", "Short Bricks"};
        for (String pre : prefs) {
            for (String suf : sufs) {
                String full = (String)(pre.equals("") ? "" : pre + " ") + "Worn " + suf;
                if (!pre.equals("") || !suf.equals("Bricks")) {
                    WORN_BRICK_TYPES.put(full, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((NonNullSupplier)wornBrick.get(), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((NonNullSupplier)wornBrick.get(), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
                WORN_STAIRS.put(full, (BlockEntry<StairBlock>)BrickBuilders.buildBrickStairs(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    if (!pre.equals("") || !suf.equals("Bricks")) {
                        prov.stonecutting(DataIngredient.items((NonNullSupplier)wornBrick.get(), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                    }
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                    prov.stairs(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_STAIRS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_SLABS.put(full, (BlockEntry<SlabBlock>)BrickBuilders.buildBrickSlabs(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    if (!pre.equals("") || !suf.equals("Bricks")) {
                        prov.stonecutting(DataIngredient.items((NonNullSupplier)wornBrick.get(), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    }
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    prov.slab(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_SLABS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_VERTS.put(full, (BlockEntry<VerticalSlabBlock>)BrickBuilders.buildBrickVerts(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    if (!pre.equals("") || !suf.equals("Bricks")) {
                        prov.stonecutting(DataIngredient.items((NonNullSupplier)wornBrick.get(), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    }
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("s").m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)WORN_SLABS.get(full).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)WORN_SLABS.get(full).get()})).m_176498_((Consumer)prov);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_VERTS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_WALLS.put(full, (BlockEntry<WallBlock>)BrickBuilders.buildBrickWalls(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    if (!pre.equals("") || !suf.equals("Bricks")) {
                        prov.stonecutting(DataIngredient.items((NonNullSupplier)wornBrick.get(), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                    }
                    prov.wall(DataIngredient.items((ItemLike)((Block)WORN_BRICK_TYPES.get(full).get()), (ItemLike[])new Block[0]), (Supplier)ctx);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_WALLS.get(full.substring(8))), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
            }
        }
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye != null) {
                BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "", name, "Bricks").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("bb").m_126130_("bb").m_126127_(Character.valueOf('b'), (ItemLike)Registration.getBrickItemFromColor(dye)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Registration.getBrickItemFromColor(dye)})).m_176498_((Consumer)prov)).register());
            }
            TILE_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            LONG_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            SHORT_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            CRACKED_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_TILE_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Brick Tiles").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)((Block)TILE_BRICK_BLOCK.get(dye).get()), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_LONG_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Long Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)((Block)LONG_BRICK_BLOCK.get(dye).get()), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            CRACKED_SHORT_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Short Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((ItemLike)((Block)SHORT_BRICK_BLOCK.get(dye).get()), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx);
            }).register());
            MOSSY_BRICK_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_TILE_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_LONG_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            MOSSY_SHORT_BLOCK.put((DyeColor)dye, (BlockEntry<Block>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx)).register());
            HashMap<CallSite, BlockEntry> stair = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> slab = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> vert = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> wall = new HashMap<CallSite, BlockEntry>();
            for (String pre : prefs) {
                for (String suf : sufs) {
                    String full = (String)(pre.equals("") ? "" : pre + " ") + name + " " + suf;
                    if (dye != null || !pre.equals("") || !suf.equals("Bricks")) {
                        stair.put((CallSite)((Object)full), BrickBuilders.buildBrickStairs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                            prov.stairs(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickStairBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        slab.put((CallSite)((Object)full), BrickBuilders.buildBrickSlabs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                            prov.slab(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        wall.put((CallSite)((Object)full), BrickBuilders.buildBrickWalls(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.wall(DataIngredient.items((ItemLike)((Block)Registration.getBrickFromName(pre, dye, suf).get()), (ItemLike[])new Block[0]), (Supplier)ctx);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickWallBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                    }
                    vert.put((CallSite)((Object)full), BrickBuilders.buildBrickVerts(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((ItemLike)Registration.getBrickBlockFromColor(dye), (ItemLike[])new Block[0]), (Supplier)ctx, 2);
                        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("s").m_126130_("s").m_126130_("s").m_126127_(Character.valueOf('s'), (ItemLike)Registration.getBrickSlabBlockFromColor(dye, full)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Registration.getBrickSlabBlockFromColor(dye, full)})).m_176498_((Consumer)prov);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((ItemLike)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (ItemLike[])new Block[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
            }
            BRICK_STAIRS_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<StairBlock>>)stair);
            BRICK_SLAB_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<SlabBlock>>)slab);
            BRICK_VERT_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<VerticalSlabBlock>>)vert);
            BRICK_WALL_BLOCK.put((DyeColor)dye, (HashMap<String, BlockEntry<WallBlock>>)wall);
        });
        reg.creativeModeTab(() -> DecoCreativeModeTab.METALS_GROUP);
        SheetMetal.registerBlocks(reg);
        DOOR_TYPES.forEach((metal, ingot) -> DOOR_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<DoorBlock>)MetalDecoBuilders.buildDoor(reg, metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_door", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), Material.f_76281_).lang(metal + " Door").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ctx.get())).m_126130_("mm").m_126130_("mm").m_126130_("mm").m_126127_(Character.valueOf('m'), (ItemLike)ingot.apply(metal)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ingot.apply(metal)})).m_176498_((Consumer)prov)).register()));
        DOOR_TYPES.forEach((metal, ingot) -> LOCK_DOOR_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<DoorBlock>)MetalDecoBuilders.buildDoor(reg, "locked_" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_door", "block/locked_" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).lang("Locked " + metal + " Door").recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126211_((ItemLike)Items.f_41978_, 1).m_126211_((ItemLike)DOOR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get(), 1).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{DOOR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).asStack().m_41720_()})).m_176498_((Consumer)prov)).register()));
        METAL_TYPES.forEach((metal, getter) -> {
            boolean postFlag = metal.contains("Netherite") || metal.contains("Gold") || metal.contains("Cast Iron");
            BAR_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<IronBarsBlock>)MetalDecoBuilders.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "", postFlag).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).recipe((ctx, prov) -> {
                if (!metal.equals("Iron")) {
                    ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)16).m_126130_("mmm").m_126130_("mmm").m_126127_(Character.valueOf('m'), (ItemLike)getter.apply(metal)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)getter.apply(metal)})).m_176498_((Consumer)prov);
                }
                ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)BAR_PANEL_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)BAR_PANEL_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()})).m_142700_((Consumer)prov, new ResourceLocation("createdeco", metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_bars_from_panel"));
            }).register());
            BAR_PANEL_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<IronBarsBlock>)MetalDecoBuilders.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "overlay", postFlag).lang((metal.equals("Iron") ? "Polished Iron" : metal) + " Panel Bars ").recipe((ctx, prov) -> ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)BAR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)BAR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()})).m_176498_((Consumer)prov)).register());
            if (metal.equals("Iron")) {
                BAR_PANEL_BLOCKS.put("vanill_iron", (BlockEntry<IronBarsBlock>)MetalDecoBuilders.buildBars(reg, metal, getter, "overlay").lang(metal + " Panel Bars").recipe((ctx, prov) -> {
                    ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ctx.get())).m_126209_((ItemLike)Items.f_42025_).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42025_})).m_176498_((Consumer)prov);
                    ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42025_).m_126209_((ItemLike)ctx.get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ctx.get()})).m_142700_((Consumer)prov, new ResourceLocation("createdeco", "vanilla_metal_bars_from_panel"));
                }).register());
            }
            MESH_FENCE_BLOCKS.put((String)metal, (BlockEntry<FenceBlock>)MetalDecoBuilders.buildFence(reg, metal).register());
            CATWALK_BLOCKS.put((String)metal, (BlockEntry<CatwalkBlock>)MetalDecoBuilders.buildCatwalk(reg, metal).register());
        });
        CAST_IRON_BLOCK = reg.block("cast_iron_block", Block::new).initialProperties(Material.f_76279_).lang("Block of Cast Iron").simpleItem().register();
        Props.registerBlocks(reg);
    }

    public static void registerItems(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.BRICKS_GROUP, "CreateDeco Bricks");
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye == null) {
                WORN_BRICK_ITEM = reg.item("worn_brick", Item::new).recipe((ctx, prov) -> prov.blasting(DataIngredient.items((ItemLike)Items.f_42460_, (ItemLike[])new Item[0]), (Supplier)ctx, 0.3f)).register();
            } else {
                BRICK_ITEM.put((DyeColor)dye, (ItemEntry<Item>)reg.item(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_brick", Item::new).lang(name + " Brick").recipe((ctx, prov) -> ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)8).m_126130_("bbb").m_126130_("bCb").m_126130_("bbb").m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42460_).m_126127_(Character.valueOf('C'), (ItemLike)DyeItem.m_41082_((DyeColor)dye)).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{DyeItem.m_41082_((DyeColor)dye)})).m_176498_((Consumer)prov)).register());
            }
        });
        reg.creativeModeTab(() -> DecoCreativeModeTab.METALS_GROUP, "CreateDeco Metals");
        ZINC_SHEET = reg.item("zinc_sheet", Item::new).tag(new TagKey[]{Registration.makeItemTag("plates/zinc")}).lang("Zinc Sheet").register();
        NETHERITE_SHEET = reg.item("netherite_sheet", Item::new).properties(p -> p.m_41486_()).tag(new TagKey[]{Registration.makeItemTag("plates/netherite")}).lang("Netherite Sheet").register();
        NETHERITE_NUGGET = reg.item("netherite_nugget", Item::new).properties(p -> p.m_41486_()).tag(new TagKey[]{Registration.makeItemTag("nuggets/netherite")}).lang("Netherite Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> Items.f_42418_)).register();
        CAST_IRON_NUGGET = reg.item("cast_iron_nugget", Item::new).tag(new TagKey[]{Registration.makeItemTag("nuggets/cast_iron")}).lang("Cast Iron Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> (Item)CAST_IRON_INGOT.get())).register();
        CAST_IRON_INGOT = reg.item("cast_iron_ingot", Item::new).tag(new TagKey[]{Registration.makeItemTag("ingots/cast_iron")}).lang("Cast Iron Ingot").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> ((Block)CAST_IRON_BLOCK.get()).m_5456_())).register();
        CAST_IRON_SHEET = reg.item("cast_iron_sheet", Item::new).tag(new TagKey[]{Registration.makeItemTag("plates/cast_iron")}).lang("Cast Iron Sheet").register();
        Props.registerItems(reg);
    }

    static {
        WORN_BRICK_TYPES = new HashMap();
        WORN_STAIRS = new HashMap();
        WORN_SLABS = new HashMap();
        WORN_VERTS = new HashMap();
        WORN_WALLS = new HashMap();
        BRICK_BLOCK = new HashMap();
        TILE_BRICK_BLOCK = new HashMap();
        LONG_BRICK_BLOCK = new HashMap();
        SHORT_BRICK_BLOCK = new HashMap();
        CRACKED_BRICK_BLOCK = new HashMap();
        CRACKED_TILE_BLOCK = new HashMap();
        CRACKED_LONG_BLOCK = new HashMap();
        CRACKED_SHORT_BLOCK = new HashMap();
        MOSSY_BRICK_BLOCK = new HashMap();
        MOSSY_TILE_BLOCK = new HashMap();
        MOSSY_LONG_BLOCK = new HashMap();
        MOSSY_SHORT_BLOCK = new HashMap();
        BRICK_STAIRS_BLOCK = new HashMap();
        BRICK_SLAB_BLOCK = new HashMap();
        BRICK_VERT_BLOCK = new HashMap();
        BRICK_WALL_BLOCK = new HashMap();
        DOOR_BLOCKS = new HashMap();
        LOCK_DOOR_BLOCKS = new HashMap();
        BAR_BLOCKS = new HashMap();
        BAR_PANEL_BLOCKS = new HashMap();
        MESH_FENCE_BLOCKS = new HashMap();
        CATWALK_BLOCKS = new HashMap();
        BRICK_ITEM = new HashMap();
    }
}

