/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.data;

import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;

public class ModLanguageUS
extends LanguageProvider {
    public ModLanguageUS(DataGenerator gen) {
        super(gen, "adchimneys", "en_us");
    }

    protected void addTranslations() {
        AdChimneys mod = AdChimneys.getInstance();
        Blocks blocks = mod.blocks;
        this.addItemGroup("advanced_chimneys");
        this.addBlock((Supplier<? extends Block>)blocks.stone_chimney);
        this.addBlock((Supplier<? extends Block>)blocks.metal_chimney);
        this.addBlock((Supplier<? extends Block>)blocks.glass_chimney);
        this.addBlock((Supplier<? extends Block>)blocks.stone_vent);
        this.addBlock((Supplier<? extends Block>)blocks.metal_vent);
        this.addBlock((Supplier<? extends Block>)blocks.stone_pump);
        this.addBlock((Supplier<? extends Block>)blocks.metal_pump);
        this.addBlock((Supplier)blocks.pipe, "Pump Pipe");
        this.addItem(mod.items.wooden_paintbrush, "Wooden Paintbrush");
    }

    protected String displayName(String regName) {
        return Names.localized().join(UnitId.splitRegName((String)regName, (boolean)true, (boolean)false));
    }

    protected void addItemGroup(String name) {
        this.add(Names.dotted().join(new String[]{"itemGroup", name}), this.displayName(name));
    }

    protected void addBlock(Supplier<? extends Block> block) {
        this.addBlock(block, this.displayName(block.get().getRegistryName().m_135815_()));
    }
}

