/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.transformers;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@FunctionalInterface
public interface PacketSink {
    public static PacketSink ofPlayer(ServerPlayer player) {
        return packet -> Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").f_8906_.m_141995_(packet);
    }

    public static PacketSink ofPlayers(Iterable<? extends ServerPlayer> players) {
        return packet -> {
            for (ServerPlayer player : players) {
                Objects.requireNonNull(player, (String)"Unable to send packet to a 'null' player!").f_8906_.m_141995_(packet);
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PacketSink client() {
        return packet -> {
            if (Minecraft.m_91087_().m_91403_() == null) {
                throw new IllegalStateException("Unable to send packet to the server while not in game!");
            }
            Minecraft.m_91087_().m_91403_().m_104955_(packet);
        };
    }

    public void accept(Packet<?> var1);
}

