/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.lib.manual.ManualElementCrafting;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import com.electronwill.nightconfig.core.Config;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.client.ClientEventHandler;
import flaxbeard.immersivepetroleum.client.gui.CokerUnitScreen;
import flaxbeard.immersivepetroleum.client.gui.DerrickScreen;
import flaxbeard.immersivepetroleum.client.gui.DistillationTowerScreen;
import flaxbeard.immersivepetroleum.client.gui.HydrotreaterScreen;
import flaxbeard.immersivepetroleum.client.particle.FluidParticleData;
import flaxbeard.immersivepetroleum.client.render.SeismicResultRenderer;
import flaxbeard.immersivepetroleum.client.render.debugging.DebugRenderHandler;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.RecipeReloadListener;
import flaxbeard.immersivepetroleum.common.items.ProjectorItem;
import flaxbeard.immersivepetroleum.common.multiblocks.CokerUnitMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.DerrickMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.HydroTreaterMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.OilTankMultiblock;
import flaxbeard.immersivepetroleum.common.multiblocks.PumpjackMultiblock;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientProxy
extends CommonProxy {
    public static final String CAT_IP = "ip";
    private static Tree.InnerNode<ResourceLocation, ManualEntry> IP_CATEGORY;

    @Override
    public void setup() {
    }

    @Override
    public void registerContainersAndScreens() {
        MenuScreens.m_96206_(IPMenuTypes.DISTILLATION_TOWER.getType(), DistillationTowerScreen::new);
        MenuScreens.m_96206_(IPMenuTypes.COKER.getType(), CokerUnitScreen::new);
        MenuScreens.m_96206_(IPMenuTypes.DERRICK.getType(), DerrickScreen::new);
        MenuScreens.m_96206_(IPMenuTypes.HYDROTREATER.getType(), HydrotreaterScreen::new);
    }

    @Override
    public void completed(ParallelDispatchEvent event) {
        event.enqueueWork(() -> ManualHelper.addConfigGetter(str -> switch (str) {
            case "distillationtower_operationcost" -> (int)(1024.0 * (Double)IPServerConfig.REFINING.distillationTower_energyModifier.get());
            case "coker_operationcost" -> (int)(1024.0 * (Double)IPServerConfig.REFINING.cokerUnit_energyModifier.get());
            case "hydrotreater_operationcost_lower" -> (int)(80.0 * (Double)IPServerConfig.REFINING.hydrotreater_energyModifier.get());
            case "hydrotreater_operationcost_upper" -> (int)(512.0 * (Double)IPServerConfig.REFINING.hydrotreater_energyModifier.get());
            case "pumpjack_consumption" -> (Integer)IPServerConfig.EXTRACTION.pumpjack_consumption.get();
            case "pumpjack_speed" -> (Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get();
            case "pumpjack_days" -> {
                int oil_min = 1000000;
                int oil_max = 5000000;
                for (ReservoirType reservoir : ReservoirType.map.values()) {
                    if (!reservoir.name.equals("oil")) continue;
                    oil_min = reservoir.minSize;
                    oil_max = reservoir.maxSize;
                    break;
                }
                float averageSize = (float)(oil_min + oil_max) / 2.0f;
                float pumpspeed = ((Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get()).intValue();
                yield Mth.m_14143_((float)(averageSize / pumpspeed / 24000.0f));
            }
            case "autolubricant_speedup" -> 1.25;
            case "portablegenerator_flux" -> FuelHandler.getFluxGeneratedPerTick((Fluid)IPContent.Fluids.GASOLINE.still().get());
            default -> {
                Config cfg = IPServerConfig.getRawConfig();
                if (cfg.contains(str)) {
                    yield cfg.get(str);
                }
                yield null;
            }
        }));
        this.setupManualPages();
    }

    @Override
    public void preInit() {
    }

    @Override
    public void preInitEnd() {
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RecipeReloadListener(null));
        MinecraftForge.EVENT_BUS.register((Object)new DebugRenderHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeismicResultRenderer());
        ProjectorItem.ClientInputHandler.keybind_preview_flip.setKeyConflictContext((IKeyConflictContext)KeyConflictContext.IN_GAME);
        ClientRegistry.registerKeyBinding((KeyMapping)ProjectorItem.ClientInputHandler.keybind_preview_flip);
    }

    @Override
    public void renderTile(BlockEntity te, VertexConsumer iVertexBuilder, PoseStack transform, MultiBufferSource buffer) {
        BlockEntityRenderer tesr = Minecraft.m_91087_().m_167982_().m_112265_(te);
        if (tesr == null) {
            return;
        }
        if (te instanceof PumpjackTileEntity) {
            PumpjackTileEntity pumpjack = (PumpjackTileEntity)te;
            transform.m_85836_();
            transform.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
            transform.m_85837_(1.0, 1.0, -2.0);
            float pt = 0.0f;
            if (MCUtil.getPlayer() != null) {
                pumpjack.activeTicks = MCUtil.getPlayer().f_19797_;
                pt = Minecraft.m_91087_().m_91296_();
            }
            tesr.m_6922_((BlockEntity)pumpjack, pt, transform, buffer, 0xF000F0, OverlayTexture.f_118083_);
            transform.m_85849_();
        } else {
            transform.m_85836_();
            transform.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
            transform.m_85837_(0.0, 1.0, -4.0);
            tesr.m_6922_(te, 0.0f, transform, buffer, 0xF000F0, OverlayTexture.f_118083_);
            transform.m_85849_();
        }
    }

    @Override
    public void drawUpperHalfSlab(PoseStack transform, ItemStack stack) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockState state = ((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)).defaultBlockState();
        BakedModel model = blockRenderer.m_110907_().m_110893_(state);
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        transform.m_85836_();
        transform.m_85837_(0.0, 0.5, 1.0);
        blockRenderer.m_110937_().renderModel(transform.m_85850_(), buffers.m_6299_(RenderType.m_110451_()), state, model, 1.0f, 1.0f, 1.0f, -1, -1, (IModelData)EmptyModelData.INSTANCE);
        transform.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnSpillParticles(Level world, BlockPos pos, Fluid fluid, int particles, float yOffset, float flow) {
        if (fluid == null || fluid == Fluids.f_76191_) {
            return;
        }
        for (int i = 0; i < particles; ++i) {
            float xa = (world.f_46441_.nextFloat() - 0.5f) / 2.0f;
            float ya = 0.25f + (0.5f + world.f_46441_.nextFloat() * 0.25f) * flow / 800.0f;
            float za = (world.f_46441_.nextFloat() - 0.5f) / 2.0f;
            float rx = (world.f_46441_.nextFloat() - 0.5f) * 0.5f;
            float rz = (world.f_46441_.nextFloat() - 0.5f) * 0.5f;
            double x = (double)pos.m_123341_() + 0.5 + (double)rx;
            double y = (float)pos.m_123342_() + yOffset;
            double z = (double)pos.m_123343_() + 0.5 + (double)rz;
            world.m_7106_((ParticleOptions)new FluidParticleData(fluid), x, y, z, (double)xa, (double)ya, (double)za);
        }
    }

    @Override
    public Level getClientWorld() {
        return MCUtil.getLevel();
    }

    @Override
    public Player getClientPlayer() {
        return MCUtil.getPlayer();
    }

    @Override
    public void handleEntitySound(SoundEvent soundEvent, Entity entity, boolean active, float volume, float pitch) {
    }

    @Override
    public void handleTileSound(SoundEvent soundEvent, BlockEntity te, boolean active, float volume, float pitch) {
    }

    private static ManualRecipeRef[][] singleRecipeRef(ItemStack stack) {
        return new ManualRecipeRef[][]{{new ManualRecipeRef(stack)}};
    }

    public void setupManualPages() {
        ManualInstance man = ManualHelper.getManual();
        IP_CATEGORY = man.getRoot().getOrCreateSubnode((Comparable)ResourceUtils.ip("main"), 100);
        int priority = 0;
        ClientProxy.handleReservoirManual(ResourceUtils.ip("reservoir"), priority++);
        ClientProxy.fluids(ResourceUtils.ip("fluids"), priority++);
        man.addEntry(IP_CATEGORY, ResourceUtils.ip("asphalt"), priority++);
        ClientProxy.lubricant(ResourceUtils.ip("lubricant"), priority++);
        ClientProxy.plastics(ResourceUtils.ip("plastics"), priority++);
        ClientProxy.derrick(ResourceUtils.ip("derrick"), priority++);
        ClientProxy.pumpjack(ResourceUtils.ip("pumpjack"), priority++);
        ClientProxy.oiltank(ResourceUtils.ip("oiltank"), priority++);
        ClientProxy.distillation(ResourceUtils.ip("distillationtower"), priority++);
        ClientProxy.coker(ResourceUtils.ip("cokerunit"), priority++);
        ClientProxy.hydrotreater(ResourceUtils.ip("hydrotreater"), priority++);
        ClientProxy.flarestack(ResourceUtils.ip("flarestack"), priority++);
        ClientProxy.generator(ResourceUtils.ip("portablegenerator"), priority++);
        ClientProxy.autolube(ResourceUtils.ip("automaticlubricator"), priority++);
        ClientProxy.projector(ResourceUtils.ip("projector"), priority++);
        ClientProxy.speedboat(ResourceUtils.ip("speedboat"), priority++);
    }

    private static void flarestack(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.readFromFile(location);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("flarestack0", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.Blocks.FLARESTACK.get())))));
        builder.appendText(() -> {
            ArrayList<Component[]> list = new ArrayList<Component[]>();
            for (TagKey<Fluid> tag : FlarestackHandler.getSet()) {
                for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                    if (!fluid.m_205067_(tag)) continue;
                    Component[] entry = new Component[]{TextComponent.f_131282_, new FluidStack(fluid, 1).getDisplayName()};
                    list.add(entry);
                }
            }
            StringBuilder additionalText = new StringBuilder();
            ArrayList<ManualEntry.SpecialElementData> newElements = new ArrayList<ManualEntry.SpecialElementData>();
            int nextLine = 0;
            int page = 0;
            while (nextLine < list.size()) {
                int linesOnPage = page == 0 ? 12 : 14;
                int endIndex = Math.min(nextLine + linesOnPage, list.size());
                List onPage = list.subList(nextLine, endIndex);
                nextLine = endIndex;
                String key = "flarestack_table" + page;
                additionalText.append("<&").append(key).append(">");
                newElements.add(new ManualEntry.SpecialElementData(key, 0, (SpecialManualElement)new ManualElementTable(man, (Component[][])onPage.toArray(x$0 -> new Component[x$0][]), false)));
                ++page;
            }
            return Pair.of((Object)additionalText.toString(), newElements);
        });
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void autolube(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("automaticlubricator0", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.Blocks.AUTO_LUBRICATOR.get())))));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void generator(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("portablegenerator0", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.Blocks.GAS_GENERATOR.get())))));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void speedboat(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("speedboat0", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.Items.SPEEDBOAT.get())))));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("speedboat1", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.BoatUpgrades.TANK.get())))));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("speedboat2", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.BoatUpgrades.RUDDERS.get())))));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("speedboat3", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.BoatUpgrades.ICE_BREAKER.get())))));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("speedboat4", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.BoatUpgrades.REINFORCED_HULL.get())))));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("speedboat5", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.BoatUpgrades.PADDLES.get())))));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void lubricant(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("lubricant1", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.Items.OIL_CAN.get())))));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void plastics(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("plastics0", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.NAPHTHA.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("plastics1", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.NAPHTHA_CRACKED.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("plastics2", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.BENZENE.bucket().get()), new ItemStack((ItemLike)IPContent.Fluids.PROPYLENE.bucket().get()), new ItemStack((ItemLike)IPContent.Fluids.ETHYLENE.bucket().get())})));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void fluids(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("crude", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.NAPHTHA.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("lubricant", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.LUBRICANT.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("diesel", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.DIESEL_SULFUR.bucket().get()), new ItemStack((ItemLike)IPContent.Fluids.DIESEL.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("kerosene", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.KEROSENE.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("naphtha", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.NAPHTHA.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("naphtha_derivates", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.BENZENE.bucket().get()), new ItemStack((ItemLike)IPContent.Fluids.PROPYLENE.bucket().get()), new ItemStack((ItemLike)IPContent.Fluids.ETHYLENE.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("gasoline", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.GASOLINE.bucket().get()), new ItemStack((ItemLike)IPContent.Fluids.GASOLINE_ADDITIVES.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("napalm", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Fluids.NAPALM.bucket().get())})));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("paraffin", 0, (SpecialManualElement)new ManualElementItem(man, new ItemStack[]{new ItemStack((ItemLike)IPContent.Items.PARAFFIN_WAX.get())})));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void pumpjack(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("pumpjack0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)PumpjackMultiblock.INSTANCE)));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void distillation(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("distillationtower0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)DistillationTowerMultiblock.INSTANCE)));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void coker(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("cokerunit0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)CokerUnitMultiblock.INSTANCE)));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void hydrotreater(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("hydrotreater0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)HydroTreaterMultiblock.INSTANCE)));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void derrick(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("derrick0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)DerrickMultiblock.INSTANCE)));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void oiltank(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("oiltank0", 0, () -> new ManualElementMultiblock(man, (MultiblockHandler.IMultiblock)OilTankMultiblock.INSTANCE)));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static void projector(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ItemStack projectorWithNBT = new ItemStack((ItemLike)IPContent.Items.PROJECTOR.get());
        ItemNBTHelper.putString((ItemStack)projectorWithNBT, (String)"multiblock", (String)IEMultiblocks.ARC_FURNACE.getUniqueName().toString());
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.addSpecialElement(new ManualEntry.SpecialElementData("projector0", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(new ItemStack((ItemLike)IPContent.Items.PROJECTOR.get())))));
        builder.addSpecialElement(new ManualEntry.SpecialElementData("projector1", 0, (SpecialManualElement)new ManualElementCrafting(man, ClientProxy.singleRecipeRef(projectorWithNBT))));
        builder.readFromFile(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    private static void handleReservoirManual(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.setContent(ClientProxy::createContent);
        builder.setLocation(location);
        man.addEntry(IP_CATEGORY, builder.create(), priority);
    }

    protected static ManualEntry.EntryData createContent() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ReservoirType[] reservoirs = ReservoirType.map.values().toArray(new ReservoirType[0]);
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(I18n.m_118938_((String)"ie.manual.entry.reservoirs.oil0", (Object[])new Object[0]));
        contentBuilder.append(I18n.m_118938_((String)"ie.manual.entry.reservoirs.oil1", (Object[])new Object[0]));
        for (int i = 0; i < reservoirs.length; ++i) {
            StringBuilder strBuilder;
            char c;
            ReservoirType reservoir = reservoirs[i];
            ImmersivePetroleum.log.debug("Creating entry for " + reservoir);
            String name = "desc.immersivepetroleum.info.reservoir." + reservoir.name;
            String localizedName = I18n.m_118938_((String)name, (Object[])new Object[0]);
            if (localizedName.equalsIgnoreCase(name)) {
                localizedName = reservoir.name;
            }
            boolean isVowel = (c = localizedName.toLowerCase().charAt(0)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
            String aOrAn = I18n.m_118938_((String)(isVowel ? "ie.manual.entry.reservoirs.vowel" : "ie.manual.entry.reservoirs.consonant"), (Object[])new Object[0]);
            String dimBWList = "";
            String bioBWList = "";
            if (reservoir.getDimensions().hasEntries()) {
                strBuilder = new StringBuilder();
                reservoir.getDimensions().forEach(rl -> strBuilder.append(strBuilder.length() > 0 ? ", " : "").append("<dim;").append(rl).append(">"));
                dimBWList = reservoir.getDimensions().isBlacklist() ? I18n.m_118938_((String)"ie.manual.entry.reservoirs.dim.invalid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn}) : I18n.m_118938_((String)"ie.manual.entry.reservoirs.dim.valid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn});
            } else {
                dimBWList = I18n.m_118938_((String)"ie.manual.entry.reservoirs.dim.any", (Object[])new Object[]{localizedName, aOrAn});
            }
            if (reservoir.getBiomes().hasEntries()) {
                strBuilder = new StringBuilder();
                reservoir.getBiomes().forEach(rl -> {
                    Biome bio = (Biome)ForgeRegistries.BIOMES.getValue(rl);
                    strBuilder.append(strBuilder.length() > 0 ? ", " : "").append((Object)(bio != null ? bio.toString() : rl));
                });
                dimBWList = reservoir.getBiomes().isBlacklist() ? I18n.m_118938_((String)"ie.manual.entry.reservoirs.bio.invalid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn}) : I18n.m_118938_((String)"ie.manual.entry.reservoirs.bio.valid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn});
            } else {
                dimBWList = I18n.m_118938_((String)"ie.manual.entry.reservoirs.bio.any", (Object[])new Object[]{localizedName, aOrAn});
            }
            String fluidName = "";
            Fluid fluid = reservoir.getFluid();
            if (fluid != null) {
                fluidName = new FluidStack(fluid, 1).getDisplayName().getString();
            }
            String repRate = "";
            if (reservoir.residual > 0) {
                repRate = I18n.m_118938_((String)"ie.manual.entry.reservoirs.replenish", (Object[])new Object[]{reservoir.residual, fluidName});
            }
            contentBuilder.append(I18n.m_118938_((String)"ie.manual.entry.reservoirs.content", (Object[])new Object[]{dimBWList, fluidName, Utils.fDecimal(reservoir.minSize), Utils.fDecimal(reservoir.maxSize), repRate, bioBWList}));
            if (i < reservoirs.length - 1) {
                contentBuilder.append("<np>");
            }
            list.add(new ItemStack((ItemLike)fluid.m_6859_()));
        }
        String translatedTitle = I18n.m_118938_((String)"ie.manual.entry.reservoirs.title", (Object[])new Object[0]);
        String tanslatedSubtext = I18n.m_118938_((String)"ie.manual.entry.reservoirs.subtitle", (Object[])new Object[0]);
        String formattedContent = contentBuilder.toString().replaceAll("\r\n|\r|\n", "\n");
        return new ManualEntry.EntryData(translatedTitle, tanslatedSubtext, formattedContent, List.of());
    }
}

