/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPClientTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPServerTickableTile;
import flaxbeard.immersivepetroleum.common.gui.IPMenuProvider;
import flaxbeard.immersivepetroleum.common.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.inventory.MultiFluidTankFiltered;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DistillationTowerTileEntity
extends PoweredMultiblockBlockEntity<DistillationTowerTileEntity, DistillationTowerRecipe>
implements IPServerTickableTile,
IPClientTickableTile,
IPMenuProvider<DistillationTowerTileEntity>,
IEBlockInterfaces.IBlockBounds {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final int INV_0 = 0;
    public static final int INV_1 = 1;
    public static final int INV_2 = 2;
    public static final int INV_3 = 3;
    public static final BlockPos Fluid_IN = new BlockPos(3, 0, 3);
    public static final BlockPos Fluid_OUT = new BlockPos(1, 0, 3);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 1);
    public static final Set<PoweredMultiblockBlockEntity.MultiblockFace> Energy_IN = ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(3, 1, 3, RelativeBlockFace.UP));
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(0, 1, 3));
    public NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    public final MultiFluidTank[] tanks = new MultiFluidTank[]{new MultiFluidTankFiltered(24000, fs -> DistillationTowerRecipe.findRecipe(fs) != null), new MultiFluidTankFiltered(24000)};
    private int cooldownTicks = 0;
    private boolean wasActive = false;
    private final MultiblockCapability<IFluidHandler> outputHandler = MultiblockCapability.make((Object)this, be -> be.outputHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidOutput(new IFluidTank[]{this.tanks[1]}));
    private final MultiblockCapability<IFluidHandler> inputHandler = MultiblockCapability.make((Object)this, be -> be.inputHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidInput(new IFluidTank[]{this.tanks[0]}));
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(DistillationTowerTileEntity::getShape);

    public DistillationTowerTileEntity(BlockEntityType<DistillationTowerTileEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super((IETemplateMultiblock)DistillationTowerMultiblock.INSTANCE, 16000, true, type, pWorldPosition, pBlockState);
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.m_128469_("tank0"));
        this.tanks[1].readFromNBT(nbt.m_128469_("tank1"));
        this.cooldownTicks = nbt.m_128451_("cooldownTicks");
        if (!descPacket) {
            this.inventory = this.readInventory(nbt.m_128469_("inventory"));
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128365_("tank0", (Tag)this.tanks[0].writeToNBT(new CompoundTag()));
        nbt.m_128365_("tank1", (Tag)this.tanks[1].writeToNBT(new CompoundTag()));
        nbt.m_128405_("cooldownTicks", this.cooldownTicks);
        if (!descPacket) {
            nbt.m_128365_("inventory", (Tag)this.writeInventory(this.inventory));
        }
    }

    protected NonNullList<ItemStack> readInventory(CompoundTag nbt) {
        NonNullList list = NonNullList.m_122779_();
        ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)list);
        if (list.size() == 0) {
            list = this.inventory.size() == 4 ? this.inventory : NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
        } else if (list.size() < 4) {
            while (list.size() < 4) {
                list.add((Object)ItemStack.f_41583_);
            }
        }
        return list;
    }

    protected CompoundTag writeInventory(NonNullList<ItemStack> list) {
        return ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), list);
    }

    @Override
    public void tickClient() {
        if (this.isDummy()) {
            return;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
    }

    @Override
    public void tickServer() {
        ItemStack emptyContainer;
        if (this.isDummy()) {
            return;
        }
        super.tickServer();
        boolean update = false;
        if (!this.isRSDisabled()) {
            MultiblockProcessInMachine process;
            DistillationTowerRecipe recipe;
            if (this.energyStorage.getEnergyStored() > 0 && this.processQueue.size() < this.getProcessQueueMaxLength() && this.tanks[0].getFluidAmount() > 0 && (recipe = DistillationTowerRecipe.findRecipe(this.tanks[0].getFluid())) != null && this.tanks[0].getFluidAmount() >= recipe.getInputFluid().getAmount() && this.energyStorage.getEnergyStored() >= recipe.getTotalProcessEnergy() && this.addProcessToQueue((MultiblockProcess)(process = new MultiblockProcessInMachine((MultiblockRecipe)recipe, this::getRecipeForId, new int[0]).setInputTanks(new int[]{0})), true)) {
                this.addProcessToQueue((MultiblockProcess)process, false);
                update = true;
            }
            if (!this.processQueue.isEmpty()) {
                this.wasActive = true;
                this.cooldownTicks = 10;
                update = true;
            } else if (this.wasActive) {
                this.wasActive = false;
                update = true;
            }
            super.tickServer();
        }
        if (this.inventory.get(0) != ItemStack.f_41583_ && this.tanks[0].getFluidAmount() < this.tanks[0].getCapacity() && !(emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)))).m_41619_()) {
            if (!((ItemStack)this.inventory.get(1)).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer)) {
                ((ItemStack)this.inventory.get(1)).m_41769_(emptyContainer.m_41613_());
            } else if (((ItemStack)this.inventory.get(1)).m_41619_()) {
                this.inventory.set(1, (Object)emptyContainer.m_41777_());
            }
            ((ItemStack)this.inventory.get(0)).m_41774_(1);
            if (((ItemStack)this.inventory.get(0)).m_41613_() <= 0) {
                this.inventory.set(0, (Object)ItemStack.f_41583_);
            }
            update = true;
        }
        if (this.tanks[1].getFluidAmount() > 0) {
            if (this.inventory.get(2) != ItemStack.f_41583_ && this.tanks[1].getFluidTypes() > 0) {
                MultiFluidTank outTank = this.tanks[1];
                for (int i = outTank.getFluidTypes() - 1; i >= 0; --i) {
                    ItemStack filledContainer;
                    FluidStack fs = outTank.getFluidInTank(i);
                    if (fs.getAmount() <= 0 || (filledContainer = FluidHelper.fillFluidContainer((IFluidTank)outTank, fs, (ItemStack)this.inventory.get(2), (ItemStack)this.inventory.get(3))).m_41619_()) continue;
                    if (((ItemStack)this.inventory.get(3)).m_41613_() == 1 && !FluidHelper.isFluidContainerFull(filledContainer)) {
                        this.inventory.set(3, (Object)filledContainer.m_41777_());
                    } else {
                        if (!((ItemStack)this.inventory.get(3)).m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer)) {
                            ((ItemStack)this.inventory.get(3)).m_41769_(filledContainer.m_41613_());
                        } else if (((ItemStack)this.inventory.get(3)).m_41619_()) {
                            this.inventory.set(3, (Object)filledContainer.m_41777_());
                        }
                        ((ItemStack)this.inventory.get(2)).m_41774_(1);
                        if (((ItemStack)this.inventory.get(2)).m_41613_() <= 0) {
                            this.inventory.set(2, (Object)ItemStack.f_41583_);
                        }
                    }
                    update = true;
                    break;
                }
            }
            BlockPos outPos = this.getBlockPosForPos(Fluid_OUT).m_142300_(this.getFacing().m_122424_());
            update |= FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)outPos, (Direction)this.getFacing()).map(output -> {
                boolean ret = false;
                if (this.tanks[1].fluids.size() > 0) {
                    ArrayList<FluidStack> toDrain = new ArrayList<FluidStack>();
                    boolean iePipe = this.f_58857_.m_7702_(outPos) instanceof IFluidPipe;
                    for (FluidStack target : this.tanks[1].fluids) {
                        FluidStack outStack = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 100), iePipe);
                        int accepted = output.fill(outStack, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) continue;
                        int drained = output.fill(FluidHelper.copyFluid(outStack, Math.min(outStack.getAmount(), accepted), iePipe), IFluidHandler.FluidAction.EXECUTE);
                        toDrain.add(new FluidStack(target.getFluid(), drained));
                        ret = true;
                    }
                    toDrain.forEach(fluid -> this.tanks[1].drain(fluid, IFluidHandler.FluidAction.EXECUTE));
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            this.updateMasterBlock(null, true);
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates() {
        this.updateMasterBlock(null, true);
    }

    public DistillationTowerTileEntity getGuiMaster() {
        return (DistillationTowerTileEntity)this.master();
    }

    @Override
    @Nonnull
    public IPMenuProvider.BEContainerIP<? super DistillationTowerTileEntity, ?> getContainerTypeIP() {
        return IPMenuTypes.DISTILLATION_TOWER;
    }

    public boolean canUseGui(@Nonnull Player player) {
        return this.formed;
    }

    public boolean skipGui(BlockHitResult hit) {
        Direction facing;
        block6: {
            block5: {
                facing = this.getFacing();
                if (Energy_IN.stream().anyMatch(t -> t.posInMultiblock() == this.posInMultiblock) && hit.m_82434_() == Direction.UP) {
                    return true;
                }
                if (Redstone_IN.contains(this.posInMultiblock) && (this.getIsMirrored() ? hit.m_82434_() == facing.m_122427_() : hit.m_82434_() == facing.m_122428_())) {
                    return true;
                }
                if (this.posInMultiblock.equals((Object)Fluid_IN) && (!this.getIsMirrored() ? hit.m_82434_() == facing.m_122427_() : hit.m_82434_() == facing.m_122428_())) break block5;
                if (!this.posInMultiblock.equals((Object)Fluid_OUT) || hit.m_82434_() != facing.m_122424_()) break block6;
            }
            return true;
        }
        return this.posInMultiblock.equals((Object)Item_OUT) && (this.getIsMirrored() ? hit.m_82434_() == facing.m_122427_() : hit.m_82434_() == facing.m_122428_());
    }

    protected DistillationTowerRecipe getRecipeForId(Level level, ResourceLocation id) {
        return DistillationTowerRecipe.recipes.get(id);
    }

    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return Energy_IN;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    public DistillationTowerRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return null;
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public boolean additionalCanProcessCheck(MultiblockProcess<DistillationTowerRecipe> process) {
        int outputAmount = 0;
        for (FluidStack outputFluid : ((DistillationTowerRecipe)process.getRecipe(this.f_58857_)).getFluidOutputs()) {
            outputAmount += outputFluid.getAmount();
        }
        return this.tanks[1].getCapacity() >= this.tanks[1].getFluidAmount() + outputAmount;
    }

    public void doProcessOutput(ItemStack output) {
        IItemHandler handler;
        Direction outputdir = this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_();
        BlockPos outputpos = this.getBlockPosForPos(Item_OUT).m_142300_(outputdir);
        BlockEntity te = this.f_58857_.m_7702_(outputpos);
        if (te != null && (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputdir.m_122424_()).orElse(null)) != null) {
            output = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)output, (boolean)false);
        }
        if (!output.m_41619_()) {
            Direction facing;
            double x = (double)outputpos.m_123341_() + 0.5;
            double y = (double)outputpos.m_123342_() + 0.25;
            double z = (double)outputpos.m_123343_() + 0.5;
            Direction direction = facing = this.getIsMirrored() ? this.getFacing().m_122424_() : this.getFacing();
            if (facing != Direction.EAST && facing != Direction.WEST) {
                x = (double)outputpos.m_123341_() + (facing == Direction.SOUTH ? 0.15 : 0.85);
            }
            if (facing != Direction.NORTH && facing != Direction.SOUTH) {
                z = (double)outputpos.m_123343_() + (facing == Direction.WEST ? 0.15 : 0.85);
            }
            ItemEntity ei = new ItemEntity(this.f_58857_, x, y, z, output.m_41777_());
            ei.m_20334_(0.075 * (double)outputdir.m_122429_(), 0.025, 0.075 * (double)outputdir.m_122431_());
            this.f_58857_.m_7967_((Entity)ei);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(MultiblockProcess<DistillationTowerRecipe> process) {
    }

    public float getMinProcessDistance(MultiblockProcess<DistillationTowerRecipe> process) {
        return 1.0f;
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    public boolean shouldRenderAsActiveImpl() {
        return this.cooldownTicks > 0 || super.shouldRenderAsActiveImpl();
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(@Nonnull Capability<C> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.posInMultiblock.equals((Object)Fluid_IN) && (side == null || (this.getIsMirrored() ? side == this.getFacing().m_122428_() : side == this.getFacing().m_122427_()))) {
                return this.inputHandler.getAndCast();
            }
            if (this.posInMultiblock.equals((Object)Fluid_OUT) && (side == null || side == this.getFacing().m_122424_())) {
                return this.outputHandler.getAndCast();
            }
        }
        return super.getCapability(capability, side);
    }

    public boolean isLadder() {
        return this.posInMultiblock.m_123342_() > 0 && this.posInMultiblock.m_123341_() == 2 && this.posInMultiblock.m_123343_() == 0;
    }

    @Nonnull
    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        int bX = posInMultiblock.m_123341_();
        int bY = posInMultiblock.m_123342_();
        int bZ = posInMultiblock.m_123343_();
        if (bY < 2 && bX == 0 && bZ == 3) {
            if (bY == 1) {
                return List.of(new AABB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0));
            }
            return Arrays.asList(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AABB(0.125, 0.0, 0.75, 0.375, 1.0, 0.875), new AABB(0.125, 0.0, 0.125, 0.375, 1.0, 0.25));
        }
        if (bY == 2 && bX == 3 && bZ == 2) {
            return Arrays.asList(new AABB(-0.0625, 0.375, 0.125, 0.0625, 1.125, 0.875), new AABB(0.125, 0.0, 0.125, 0.875, 0.125, 0.875), new AABB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AABB(0.0, 0.5, 0.25, 0.75, 1.0, 0.75));
        }
        if (bY > 0 && bX == 1 && bZ == 3) {
            if (bY != 15) {
                ArrayList<AABB> list = new ArrayList<AABB>();
                list.add(new AABB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125));
                if (bY > 0 && bY % 4 == 0) {
                    list.add(new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
                }
                return list;
            }
            return List.of(new AABB(0.1875, 0.0, -0.0625, 0.8125, 0.625, 0.8125));
        }
        if (bY > 0 && bX == 2 && bZ == 0) {
            ArrayList<AABB> list = new ArrayList<AABB>();
            list.add(new AABB(0.0625, bY == 1 ? 0.125 : 0.0, 0.875, 0.9375, 1.0, 1.0625));
            if (bY > 0 && bY % 4 == 0) {
                list.add(new AABB(0.0, 0.5, 0.875, 1.0, 1.0, 1.0625));
                list.add(new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 0.0625));
            }
            return list;
        }
        if (bX > 0 && bX < 3 && bZ > 0 && bZ < 3) {
            if (bY > 0) {
                AABB bb = new AABB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
                if (bZ == 1) {
                    if (bX == 1) {
                        bb = new AABB(0.0625, 0.0, 0.0625, 1.0, 1.0, 1.0);
                    }
                    if (bX == 2) {
                        bb = new AABB(0.0, 0.0, 0.0625, 0.9375, 1.0, 1.0);
                    }
                } else if (bZ == 2) {
                    if (bX == 1) {
                        bb = new AABB(0.0625, 0.0, 0.0, 1.0, 1.0, 0.9375);
                    }
                    if (bX == 2) {
                        bb = new AABB(0.0, 0.0, 0.0, 0.9375, 1.0, 0.9375);
                    }
                }
                return List.of(bb);
            }
            return Arrays.asList(new AABB(-0.125, 0.5, -0.125, 1.125, 1.125, 1.125), new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        if (bY > 0 && bY % 4 == 0) {
            return List.of(new AABB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0));
        }
        if (bY == 0) {
            ArrayList<AABB> list = new ArrayList<AABB>();
            if (bX == 0 && bZ == 1 || bX == 1 && bZ == 3 || bX == 3 && bZ == 2 || bX == 3 && bZ == 3) {
                list.add(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
            } else {
                list.add(new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
            }
            return list;
        }
        return List.of(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }
}

