/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.computer.cctweaked.multiblocks;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DerrickTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellTileEntity;
import flaxbeard.immersivepetroleum.common.util.compat.computer.cctweaked.CCTUtils;
import flaxbeard.immersivepetroleum.common.util.compat.computer.cctweaked.multiblocks.generic.PoweredMultiblockPeripheral;
import java.util.Map;
import net.minecraft.server.level.ColumnPos;
import net.minecraftforge.fluids.FluidStack;

public class DerrickPeripheral
extends PoweredMultiblockPeripheral {
    DerrickTileEntity master;

    public DerrickPeripheral(DerrickTileEntity tower) {
        super(tower);
        this.master = (DerrickTileEntity)tower.master();
    }

    public String getType() {
        return "ip_derrick";
    }

    @LuaFunction
    public final boolean isDrilling() {
        return this.master.drilling;
    }

    @LuaFunction
    public final boolean isSpilling() {
        return this.master.spilling;
    }

    @LuaFunction
    public final boolean completed() {
        WellTileEntity well = this.master.getWell();
        if (well == null) {
            return false;
        }
        return well.wellPipeLength >= well.getMaxPipeLength() && !this.master.spilling;
    }

    @LuaFunction
    public final Map<String, Object> getInputTank() {
        return CCTUtils.fluidToMap(this.master.tank.getFluid());
    }

    @LuaFunction
    public final MethodResult getExpectedFluid() {
        WellTileEntity well = this.master.getWell();
        if (well == null) {
            return MethodResult.of((Object[])new Object[]{null, "Well not found!"});
        }
        int realPipeLength = this.master.m_58899_().m_123342_() - 1 - well.m_58899_().m_123342_();
        int concreteNeeded = DerrickTileEntity.CONCRETE.getAmount() * (realPipeLength - well.wellPipeLength);
        if (concreteNeeded > 0) {
            return MethodResult.of(CCTUtils.fluidToMap(new FluidStack(DerrickTileEntity.CONCRETE, concreteNeeded)));
        }
        int waterNeeded = DerrickTileEntity.WATER.getAmount() * (well.getMaxPipeLength() - well.wellPipeLength);
        if (waterNeeded > 0) {
            return MethodResult.of(CCTUtils.fluidToMap(new FluidStack(DerrickTileEntity.WATER, waterNeeded)));
        }
        return MethodResult.of();
    }

    @LuaFunction
    public final float getPressure() {
        WellTileEntity well = this.master.getWell();
        if (well == null) {
            return 0.0f;
        }
        float highest = 0.0f;
        for (ColumnPos cPos : well.tappedIslands) {
            float pressure;
            ReservoirIsland island = ReservoirHandler.getIsland(this.master.getLevelNonnull(), cPos);
            if (island == null || !(highest < (pressure = island.getPressure(this.master.getLevelNonnull(), cPos.f_140723_, cPos.f_140724_)))) continue;
            highest = pressure;
        }
        return highest;
    }

    @LuaFunction
    public final int getFlowrate() {
        WellTileEntity well = this.master.getWell();
        if (well == null) {
            return 0;
        }
        int totalFlowrate = 0;
        for (ColumnPos cPos : well.tappedIslands) {
            ReservoirIsland island = ReservoirHandler.getIsland(this.master.getLevelNonnull(), cPos);
            if (island == null) continue;
            float pressure = island.getPressure(this.master.getLevelNonnull(), cPos.f_140723_, cPos.f_140724_);
            totalFlowrate += ReservoirIsland.getFlow(pressure);
        }
        return totalFlowrate;
    }
}

