/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    public void onRender(EntityViewRenderEvent.CameraSetup evt) {
        if (this.getCar() != null && !this.mc.f_91066_.m_92176_().m_90612_()) {
            evt.getCamera().m_90568_(-evt.getCamera().m_90566_((Double)Main.CLIENT_CONFIG.carZoom.get() - 4.0), 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public void onRender(InputEvent.MouseScrollEvent evt) {
        if (this.getCar() != null && !this.mc.f_91066_.m_92176_().m_90612_()) {
            Main.CLIENT_CONFIG.carZoom.set((Object)Math.max(1.0, Math.min(20.0, (Double)Main.CLIENT_CONFIG.carZoom.get() - evt.getScrollDelta())));
            Main.CLIENT_CONFIG.carZoom.save();
            evt.setCanceled(true);
        }
    }

    private EntityGenericCar getCar() {
        Entity e = this.mc.f_91074_.m_20202_();
        if (e instanceof EntityGenericCar) {
            return (EntityGenericCar)e;
        }
        return null;
    }

    public void renderFuelBar(PoseStack matrixStack, float percent) {
        percent = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
        int x = this.mc.m_91268_().m_85445_() / 2 - 91;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        int k = this.mc.m_91268_().m_85446_() - 32 + 3;
        this.mc.f_91065_.m_93228_(matrixStack, x, k, 0, 64, 182, 5);
        int j = (int)(percent * 182.0f);
        if (j > 0) {
            this.mc.f_91065_.m_93228_(matrixStack, x, k, 0, 69, j, 5);
        }
    }

    public void renderSpeed(PoseStack matrixStack, float speed) {
        String s = String.valueOf(MathUtils.round(Math.abs(speed), 2));
        int i1 = (this.mc.m_91268_().m_85445_() - this.mc.f_91065_.m_93082_().m_92895_(s)) / 2;
        int j1 = this.mc.m_91268_().m_85446_() - 31 - 4;
        this.mc.f_91065_.m_93082_().m_92883_(matrixStack, s, (float)(i1 + 1), (float)j1, 0);
        this.mc.f_91065_.m_93082_().m_92883_(matrixStack, s, (float)(i1 - 1), (float)j1, 0);
        this.mc.f_91065_.m_93082_().m_92883_(matrixStack, s, (float)i1, (float)(j1 + 1), 0);
        this.mc.f_91065_.m_93082_().m_92883_(matrixStack, s, (float)i1, (float)(j1 - 1), 0);
        this.mc.f_91065_.m_93082_().m_92883_(matrixStack, s, (float)i1, (float)j1, 8453920);
    }

    @SubscribeEvent
    public void renderToolTip(RenderTooltipEvent.Pre event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag compound = stack.m_41783_();
        if (!compound.m_128441_("trading_item") && !compound.m_128471_("trading_item")) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        EntityGenericCar car = this.getCar();
        if (car != null) {
            event.getPoseStack().m_85836_();
            event.getPoseStack().m_85841_(EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR, EntityVehicleBase.SCALE_FACTOR);
            event.getPoseStack().m_85837_(0.0, (double)(event.getPlayer().m_20206_() - event.getPlayer().m_20206_() * EntityVehicleBase.SCALE_FACTOR) / 1.5 + car.getPlayerYOffset(), 0.0);
        }
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        if (this.getCar() != null) {
            event.getPoseStack().m_85849_();
        }
    }
}

