/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageStarting
implements Message<MessageStarting> {
    private boolean start;
    private boolean playSound;
    private UUID uuid;

    public MessageStarting() {
    }

    public MessageStarting(boolean start, boolean playSound, Player player) {
        this.start = start;
        this.playSound = playSound;
        this.uuid = player.m_142081_();
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        if (!context.getSender().m_142081_().equals(this.uuid)) {
            Main.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        Entity riding = context.getSender().m_20202_();
        if (!(riding instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)riding;
        if (context.getSender().equals((Object)car.getDriver())) {
            car.setStarting(this.start, this.playSound);
        }
    }

    @Override
    public MessageStarting fromBytes(FriendlyByteBuf buf) {
        this.start = buf.readBoolean();
        this.playSound = buf.readBoolean();
        this.uuid = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.start);
        buf.writeBoolean(this.playSound);
        buf.m_130077_(this.uuid);
    }
}

