/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Optional;
import java.util.UUID;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.chiseling.ChiselingContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class ChiselingManager
implements IChiselingManager {
    private static final ChiselingManager INSTANCE = new ChiselingManager();
    private UUID activeInstanceId = UUID.randomUUID();
    private final ThreadLocal<UUID> activeThreadId = ThreadLocal.withInitial(() -> this.activeInstanceId);
    private final ThreadLocal<Table<UUID, ResourceLocation, IChiselingContext>> contexts = ThreadLocal.withInitial(HashBasedTable::create);
    private final ThreadLocal<Table<UUID, ResourceLocation, Long>> lastUsedChiselMoments = ThreadLocal.withInitial(HashBasedTable::create);

    private ChiselingManager() {
    }

    public static ChiselingManager getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<IChiselingContext> get(Player playerEntity, IChiselMode mode) {
        UUID playerId = playerEntity.m_142081_();
        ResourceLocation worldId = playerEntity.m_20193_().m_46472_().m_135782_();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored == null) {
            return Optional.empty();
        }
        return Optional.of(currentStored);
    }

    @Override
    public Optional<IChiselingContext> get(Player playerEntity, IChiselMode mode, ChiselingOperation modeOfOperandus) {
        UUID playerId = playerEntity.m_142081_();
        ResourceLocation worldId = playerEntity.m_20193_().m_46472_().m_135782_();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored == null) {
            return Optional.empty();
        }
        if (currentStored.getModeOfOperandus() == modeOfOperandus) {
            return Optional.of(currentStored);
        }
        return Optional.empty();
    }

    @Override
    public IChiselingContext create(Player playerEntity, IChiselMode mode, ChiselingOperation modeOfOperandus, boolean simulation, ItemStack causingItemStack) {
        UUID playerId = playerEntity.m_142081_();
        ResourceLocation worldId = playerEntity.m_20193_().m_46472_().m_135782_();
        IChiselingContext currentStored = (IChiselingContext)this.contexts.get().get((Object)playerId, (Object)worldId);
        if (currentStored != null && !simulation) {
            this.contexts.get().remove((Object)playerId, (Object)worldId);
        }
        ChiselingContext newContext = new ChiselingContext((LevelAccessor)playerEntity.m_20193_(), mode, modeOfOperandus, simulation, () -> {
            if (simulation) {
                return;
            }
            this.lastUsedChiselMoments.get().put((Object)playerId, (Object)worldId, (Object)playerEntity.f_19797_);
            this.contexts.get().remove((Object)playerId, (Object)worldId);
        }, causingItemStack, playerEntity);
        if (!simulation) {
            this.contexts.get().put((Object)playerId, (Object)worldId, (Object)newContext);
        }
        return newContext;
    }

    public boolean canChisel(Player playerEntity) {
        this.validateOrSetup();
        UUID playerId = playerEntity.m_142081_();
        ResourceLocation worldId = playerEntity.m_20193_().m_46472_().m_135782_();
        Long lastChiselTime = (Long)this.lastUsedChiselMoments.get().get((Object)playerId, (Object)worldId);
        if (lastChiselTime == null) {
            return true;
        }
        long time = playerEntity.f_19797_;
        long diffSinceLastUse = time - lastChiselTime;
        if (diffSinceLastUse < 0L || diffSinceLastUse > 3L) {
            this.resetLastChiselCountdown(playerEntity);
            return true;
        }
        return false;
    }

    public void onServerStarting() {
        this.activeInstanceId = UUID.randomUUID();
    }

    private void validateOrSetup() {
        UUID threadId = this.activeThreadId.get();
        if (threadId != this.activeInstanceId) {
            this.contexts.get().clear();
            this.lastUsedChiselMoments.get().clear();
            this.activeThreadId.set(this.activeInstanceId);
        }
    }

    public void resetLastChiselCountdown(Player player) {
        this.lastUsedChiselMoments.get().row((Object)player.m_142081_()).clear();
    }
}

