/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.neighborhood;

import java.util.EnumMap;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.neighborhood.BlockNeighborhood;
import mod.chiselsandbits.neighborhood.BlockNeighborhoodEntry;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockNeighborhoodBuilder
implements IBlockNeighborhoodBuilder {
    private static final BlockNeighborhoodBuilder INSTANCE = new BlockNeighborhoodBuilder();

    public static BlockNeighborhoodBuilder getInstance() {
        return INSTANCE;
    }

    private BlockNeighborhoodBuilder() {
    }

    @Override
    @NotNull
    public IBlockNeighborhood build(@Nullable Function<Direction, BlockInformation> neighborhoodBlockStateProvider, @Nullable Function<Direction, IAreaAccessor> neighborhoodAreaAccessorProvider) {
        EnumMap<Direction, BlockNeighborhoodEntry> neighborhoodMap = new EnumMap<Direction, BlockNeighborhoodEntry>(Direction.class);
        try (IProfilerSection ignored2 = ProfilingManager.getInstance().withSection("Key building");){
            for (Direction value : Direction.values()) {
                IAreaAccessor accessor;
                BlockInformation state = neighborhoodBlockStateProvider != null ? neighborhoodBlockStateProvider.apply(value) : BlockInformation.AIR;
                IAreaAccessor iAreaAccessor = accessor = neighborhoodAreaAccessorProvider != null ? neighborhoodAreaAccessorProvider.apply(value) : null;
                if (accessor == null) {
                    neighborhoodMap.put(value, new BlockNeighborhoodEntry(state));
                    continue;
                }
                neighborhoodMap.put(value, new BlockNeighborhoodEntry(state, accessor));
            }
        }
        return new BlockNeighborhood(neighborhoodMap);
    }
}

